<template id="list_task">
    <div>
        <div class="d-flex justify-content-end mb-3">
            <div class="input-group rounded-3 has-clear-btn-input-group me-3">
                <span class="input-group-text bg-white border-end-0" style="border-color: #ced4da">
                    <i class="ri-search-line" style="color: #878a99"></i>
                </span>
                <input type="text" class="form-control border-start-0 ps-0 pe-3 rounded-end-1" v-model="search"
                    @keyup="handleSearch" style="border-color: #ced4da;" placeholder="{{ trans('label.search') }}">
                <i class="bi bi-x fs-22 position-absolute clearSearchButton" @click="clearInput"
                    v-if="showClearSearch"></i>
            </div>
            <a class="btn text-black bg-white border rounded-3 text-nowrap" data-bs-toggle="modal"
                data-bs-target="#addPreProjectTaskModal">
                <i class="fe fe-plus button_icon"></i>{{ trans('pre_project.new_comment_task') }}
            </a>
            <select class="btn btn-light bg-white text-start rounded-3 collapse-all-btn ms-3">
                <option value="expand_all">{{ trans('label.expand_all') }}</option>
                <option value="collapse_all">{{ trans('label.collapse_all') }}</option>
            </select>
        </div>
        <div class="position-relative table-wrapper bg-white rounded-1 mb-3" v-for="item in list">
            <item_task :item="item" template_id="list_task"></item_task>
        </div>

        <div class="position-relative table-wrapper bg-white rounded-1 mb-4 pb-3" v-if="loading">
            <div class="p-3 pb-1 ps-4 pe-4 d-flex align-items-center justify-content-center">
                <div class="spinner-border"><span class="visually-hidden">Loading...</span></div>
            </div>
        </div>
    </div>
</template>

<script>
    Vue.component('list_task', {
        template: '#list_task',
        delimiters: ["((", "))"],
        props: {
            count_data: {
                type: Object,
                default: () => ({})
            },
        },
        data() {
            return {
                list: [],
                page: 1,
                perPage: "{{ $default_records_per_page }}",
                total: 0,
                loading: false,
                search: '',
                showClearSearch: false,
                selectedObject: {},
                searchTimeout: null,
            };
        },
        created() {
            EventBus.$on('reload_list_task', this.reloadList);
            this.onLoadPagination();
        },
        methods: {
            async onLoadPagination() {
                this.loading = true;
                try {
                    const response = await this.fetchTasks();
                    this.updateList(response);
                } catch (error) {
                    notifier.warning('Error fetching tasks.');
                } finally {
                    this.loading = false;
                }
            },
            async fetchTasks() {
                const params = new URLSearchParams({
                    page: this.page,
                    perPage: this.perPage,
                    type: 4,
                    pre_project_id: "{{ $model->id }}",
                    s: this.search,
                });
                const url = `{{ route('api.pre_projects.list_comment', $model->id) }}?${params}`;
                const response = await jQuery.get(url);
                return response.result;
            },
            updateList(data) {
                this.list = data.data;
                this.total = data.total;
                this.count_data.task = this.total;
            },
            handleSearch() {
                clearTimeout(this.searchTimeout);
                this.showClearSearch = !!this.search;
                this.searchTimeout = setTimeout(this.onLoadPagination, 400);
            },
            clearInput() {
                this.search = '';
                this.showClearSearch = false;
                this.onLoadPagination();
            },
            async updatePreProjectTask() {
                this.loading = true;
                try {
                    const form = $('#updatePreProjectTaskForm')[0];
                    const formData = new FormData(form);
                    await this.saveTask(this.selectedObject.id, formData);
                    notifier.success('{{ trans('label.success') }}');
                    EventBus.$emit('reload_list_activity');
                    $('.modal').modal('hide');
                    this.onLoadPagination();
                } catch (error) {
                    notifier.alert(error.responseJSON.message);
                } finally {
                    this.loading = false;
                }
            },
            async saveTask(taskId, formData) {
                const url = `{{ route('view.pre_project_comment.update') }}/${taskId}`;
                return await jQuery.post({
                    url,
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                });
            },
            reloadList() {
                this.page = 1;
                this.onLoadPagination();
            },
        },
    });
</script>
