<template id="list_meeting">
    <div>
        <!-- Search and Actions Section -->
        <div class="d-flex justify-content-end mb-3">
            <div class="input-group rounded-3 has-clear-btn-input-group me-3">
                <span class="input-group-text bg-white border-end-0" style="border-color: #ced4da">
                    <i class="ri-search-line" style="color: #878a99"></i>
                </span>
                <input type="text" class="form-control border-start-0 ps-0 pe-3 rounded-end-1" v-model="search"
                    @keyup="handleSearch" style="border-color: #ced4da;" placeholder="{{ trans('label.search') }}">
                <i class="bi bi-x fs-22 position-absolute clearSearchButton" @click="clearInput"
                    v-if="showClearSearch"></i>
            </div>

            <!-- Add Meeting Button -->
            <a class="btn text-black bg-white border rounded-3 text-nowrap" data-bs-toggle="modal"
                data-bs-target="#addPreProjectMeetingModal">
                <i class="fe fe-plus button_icon"></i>{{ trans('pre_project.new_comment_meeting') }}
            </a>

            <!-- Expand/Collapse Dropdown -->
            <select class="btn btn-light bg-white text-start rounded-3 collapse-all-btn ms-3"
                style="border-color: #ced4da;">
                <option value="expand_all">{{ trans('label.expand_all') }}</option>
                <option value="collapse_all">{{ trans('label.collapse_all') }}</option>
            </select>
        </div>

        <!-- Meeting List -->
        <div class="position-relative table-wrapper bg-white rounded-1 mb-3" v-for="item in list">
            <item_meeting :item="item" template_id="list_meeting"></item_meeting>
        </div>

        <!-- Loading Spinner -->
        <div v-if="loading" class="position-relative table-wrapper bg-white rounded-1 mb-4 pb-3">
            <div class="p-3 pb-1 ps-4 pe-4 d-flex align-items-center justify-content-center">
                <div class="spinner-border">
                    <span class="visually-hidden">Loading...</span>
                </div>
            </div>
        </div>
    </div>
</template>

<script>
    Vue.component('list_meeting', {
        template: '#list_meeting',
        delimiters: ["((", "))"],
        props: {
            count_data: {
                type: Object,
                default: () => ({})
            },
        },
        data() {
            return {
                list: [],
                search: '',
                page: 1,
                perPage: "{{ $default_records_per_page }}",
                total: 0,
                loading: false,
                showClearSearch: false,
                searchTimeout: null,
            };
        },
        created() {
            EventBus.$on('reload_list_meeting', this.reloadMeetings);
        },
        mounted() {
            this.onLoadPagination();
        },
        methods: {
            handleSearch() {
                clearTimeout(this.searchTimeout);
                this.searchTimeout = setTimeout(() => {
                    this.onLoadPagination();
                    this.showClearSearch = this.search !== '';
                }, 400);
            },
            clearInput() {
                this.search = '';
                this.onLoadPagination();
                this.showClearSearch = false;
            },
            onLoadPagination() {
                this.loading = true;
                let queryParams = {
                    page: this.page,
                    perPage: this.perPage,
                    s: this.search,
                    type: 5,
                    pre_project_id: "{{ $model->id }}",
                };

                jQuery.ajax({
                    url: "{{ route('api.pre_projects.list_comment', $model->id) }}",
                    data: queryParams,
                    success: (data) => {
                        this.list = data.result.data;
                        this.total = data.result.total;
                        this.loading = false;
                    },
                    error: () => {
                        this.loading = false;
                        notifier.warning('Error loading meetings.');
                    }
                });
            },
            reloadMeetings() {
                this.list = [];
                this.onLoadPagination();
            }
        }
    });
</script>
