<template id="list_invoice">
    <div>
        <div class="position-relative table-wrapper bg-white rounded-3 mb-4">
            <div class="p-4 d-flex align-items-center">
                <button type="button" data-bs-toggle="collapse" :data-bs-target="`#collapseInvoice${type}`"
                    aria-expanded="true" :aria-controls="`collapseInvoice${type}`"
                    class="me-auto gino-accordion-item__button  text-black fw-bold">
                    <div v-if="type == 1"> {{ trans('pre_project.invoice1_card_title') }} </div>
                    <div v-if="type == 2"> {{ trans('pre_project.invoice2_card_title') }} </div>
                </button>
                <div class="input-group rounded-3 has-clear-btn-input-group me-3">
                    <span class="input-group-text bg-white border-end-0" style="border-color: #ced4da"><i
                            class="ri-search-line" style="color: #878a99"></i></span>
                    <input type="text" class="form-control border-start-0  ps-0 pe-3 rounded-end-1 " v-model="search"
                        @keyup="handleSearch" style="border-color: #ced4da;" placeholder="{{ trans('label.search') }}">
                    <i class="bi bi-x fs-22 position-absolute clearSearchButton" @click="clearInput"
                        v-if="showClearSearch"></i>
                </div>
                <a class="btn text-black bg-white border rounded-3 text-nowrap" data-bs-toggle="modal"
                    :data-bs-target="`#createInvoiceModal${type}`">
                    <i class="fe fe-plus button_icon"></i>{{ trans('customer.add_customer_staff') }}
                </a>
            </div>
            <div :id="`collapseInvoice${type}`" class="accordion-collapse collapse show">
                <div class="table-responsive gino-custom-table-2 pb-0 ">
                    <table class="table mb-0 text-nowrap border-top">
                        <thead>
                            <tr>
                                <th @click="sortSelect('select')" role='button' style="width: 1px"
                                    class=" col_checkbox px-4">
                                    <input type="checkbox"
                                        :class="[{ 'gino-checkbox--checked2': selectAll == 2 },
                                            'gino-checkbox form-check-input'
                                        ]"
                                        v-model="selectAll" :checked="selectAll" @click.stop>
                                    <i v-if="sortBy == 'select'"
                                        v-bind:class="sortDirection == 'desc' ? 
                                'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                                </th>
                                <th @click="sort('id')" role='button'>
                                    {{ trans('invoice.id') }}
                                    <i v-if="sortBy == 'id'"
                                        v-bind:class="sortDirection == 'desc' ? 
                                'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                                </th>
                                <th @click="sort('name')" role='button'>
                                    {{ trans('invoice.name') }}
                                    <i v-if="sortBy == 'name'"
                                        v-bind:class="sortDirection == 'desc' ? 
                                'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                                </th>

                                <th @click="sort('status')" role='button'>
                                    {{ trans('invoice.status') }}
                                    <i v-if="sortBy == 'status'"
                                        v-bind:class="sortDirection == 'desc' ? 
                                'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                                </th>

                                <th @click="sort('created_on')" role='button'>
                                    {{ trans('invoice.created_on') }}
                                    <i v-if="sortBy == 'created_on'"
                                        v-bind:class="sortDirection == 'desc' ? 
                                'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                                </th>

                                <th @click="sort('submited_on')" role='button'>
                                    {{ trans('invoice.submited_on') }}
                                    <i v-if="sortBy == 'submited_on'"
                                        v-bind:class="sortDirection == 'desc' ? 
                                'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                                </th>

                                <th style="width:1px">
                                    <div>{{ trans('label.action') }}</div>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="item in list" :key="item.id">
                                <td scope="col" class=" px-4">
                                    <input type="checkbox" class="gino-checkbox form-check-input" v-model="selected"
                                        :value="item.id">
                                </td>
                                <td class=" text-center">((item.id))</td>
                                <td>((item.name))</td>
                                <td>((item.status_name))</td>
                                <td>((item.created_at))</td>
                                <td>((item.submited_on))</td>
                                <td>
                                    <div class="hstack gap-2 me-2">
                                        <a :href="`{{ asset('invoice') }}/` + item.id + `/detail`"
                                            class="  action-btn rounded  p-1" title="{{ trans('label.view') }}">
                                            @include('icons.eye')
                                        </a>
                                     
                                        <form :action="`{{ asset('invoice') }}/` + item.id"
                                            :id="'formDelete_' + ((item.id))" method="post">
                                            @method('DELETE')
                                            @csrf
                                            <a href="##" @click="deleteItem(item.id)"
                                                class="  action-btn rounded  p-1">
                                                @include('icons.trash')</a>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            <tr v-if="loading">
                                <td colspan="100%" class=" text-center">
                                    <div class="spinner-border">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                </td>
                            </tr>
                            <tr v-if="list.length < 1 && !loading">
                                <td colspan="100%" class="text-center">{{ trans('label.no_record') }}</td>
                            </tr>

                        </tbody>
                    </table>
                </div>
                @include('includes.pagination')
            </div>


            <div class="modal fade gino-modal" :id="`createInvoiceModal${type}`" tabindex="-1" role="dialog"
                :aria-labelledby="`createInvoiceModalLabel${type}`" aria-hidden="true">
                <div class="modal-dialog " role="document">
                    <div class="modal-content custom-modal-content">
                        <div class="modal-header border-0  bg-light p-3">
                            <h6 class="modal-title" :id="`createInvoiceModalLabel${type}`">
                                {{ trans('customer.update_customer_staff_dialog1') }}
                            </h6>
                            <button type="button" class="btn-close btn-close-black " data-bs-dismiss="modal"
                                aria-label="Close">
                            </button>
                        </div>
                        <form @submit.prevent="createInvoice(`#createInvoiceForm${type}`)"
                            :ref="`createInvoiceForm${type}`" :id="`createInvoiceForm${type}`" method="post"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="modal-body p-20">
                                <div class="row">
                                    <input type="hidden" name="type" :value="type">

                                    <div class="col-sm-12 mb-3">
                                        <label for="name" class="form-label">{{ trans('invoice.name') }}</label>
                                        <input type="text"
                                            :class="[{ 'validate-error--input': validateErrors.name },
                                                'form-control'
                                            ]"
                                            name="name" value="" v-model="createObj.name">
                                        <div class="validate-error--text text-danger" v-if="validateErrors.name"
                                            v-for="err in validateErrors.name">
                                            <small>
                                                (( err ))
                                            </small>
                                        </div>
                                    </div>


                                    <div class="col-sm-12 mb-3">
                                        <label for="note" class="form-label">{{ trans('invoice.note') }}</label>
                                        <ckeditor name="note" v-model="createObj.note"></ckeditor>
                                        {{-- <textarea
                                            :class="[{ 'validate-error--input': validateErrors.note },
                                                'form-control '
                                            ]"
                                            name="note"></textarea> --}}
                                        <div class="validate-error--text text-danger" v-if="validateErrors.note"
                                            v-for="err in validateErrors.note">
                                            <small>
                                                (( err ))
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer border-0 p-3 pt-0 gap-2 justify-content-end">
                                <div v-if="createLoading">
                                    <div class="spinner-border">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                </div>
                                <div class="btn btn-light" data-bs-dismiss="modal" aria-hidden="true">
                                    {{ trans('label.cancel') }}
                                </div>

                                <button type="submit" class="btn btn-primary ">
                                    {{ trans('label.save') }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>


        </div>
</template>

<script>
    Vue.component('list_invoice', {
        template: `#list_invoice`,
        delimiters: ["((", "))"],
        props: {
            type: {
                type: [Number, String],
                default: 2,
            }
        },
        data() {
            return {
                sortDirection: 'desc',
                sortBy: '',
                count: 0, //total page
                page: 1, //pagination: curent page
                perPage: "{{ $default_records_per_page }}", // pagination: records per page
                total: 0, //pagination: total records
                pageRange: 3, // pagination:controls nearby page display. currenpage counted
                from: 1,
                to: 10,
                list: [],
                conditionSearch: '',
                search: '',
                airport_date_to: '',
                airport_date_from: '',
                return_date_to: '',
                return_date_from: '',
                filterObj: {
                    status: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
                },
                showClearSearch: false,
                putMethod: false,
                selectedObject: {},
                createObj: {},
                listPage: [],
                showCount: 10,
                selected: [],
                validateErrors: {},
                updateValidateErrors: {},
                createLoading: false,
                viewType: 'list',
                loading: false,
                addModalLoading: true,
                customers: @json($customers),
            }
        },
        mounted() {
            const that = this;
            this.onLoadPagination();
        },
        computed: {
            selectAll: {
                get: function() {
                    if (!this.list || this.selected.length == 0) return 0
                    if (this.selected.length == this.list.length) return 1
                    if (this.selected.length != this.list.length) return 2
                },
                set: function(value) {
                    this.selected = value ? this.list.map((row) => row.id) : [];
                }
            }
        },

        methods: {
            resetCreateObj() {
                this.createObj = {
                    customer_type: @json(@$customer_types[0]->key3),
                    invoice_type: @json(@$invoice_types[0]->key3),
                }
                $('#customer_id').val(this.createObj.customer_id).trigger('change')
                $('#manager_id').val(this.createObj.manager_id).trigger('change')
            },
            copyItem(item) {
                this.createObj = {
                    ...item,
                }
                $('#customer_id').val(this.createObj.customer_id).trigger('change')
                $('#manager_id').val(this.createObj.manager_id).trigger('change')
            },
            sortSelect: function(s) {
                if (s === this.sortBy) {
                    this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                }
                this.sortBy = s;
                this.list.sort((p1, p2) => {
                    let modifier = 1;
                    if (this.sortDirection === 'asc') modifier = -1;
                    let indexA = this.selected.indexOf(p1.id);
                    let indexB = this.selected.indexOf(p2.id);
                    // Nếu id không có trong selected thì cho nó giá trị lớn để nó được đẩy về sau
                    if (indexA === -1) indexA = Infinity;
                    if (indexB === -1) indexB = Infinity;

                    return (indexA - indexB) * modifier;
                });
            },
            sortTime: function(s) {
                if (s === this.sortBy) {
                    this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                }
                this.sortBy = s;
                this.list = this.list.sort((p1, p2) => {
                    let modifier = this.sortDirection === 'asc' ? 1 : -1;

                    const time1 = p1[this.sortBy].split(':').map(num => parseInt(num));
                    const time2 = p2[this.sortBy].split(':').map(num => parseInt(num));

                    if (time1[0] < time2[0]) return -1 * modifier;
                    if (time1[0] > time2[0]) return 1 * modifier;
                    if (time1[1] < time2[1]) return -1 * modifier;
                    if (time1[1] > time2[1]) return 1 * modifier;
                    return 0;
                });
            },
            sort: function(s) {
                if (s === this.sortBy) {
                    this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                }
                this.sortBy = s;
                this.list = this.list.sort((p1, p2) => {
                    let modifier = 1;
                    if (this.sortDirection === 'desc') modifier = -1;

                    if (p1[this.sortBy] == undefined && p2[this.sortBy] != undefined) return -1 *
                        modifier;
                    if (p1[this.sortBy] != undefined && p2[this.sortBy] == undefined) return 1 *
                        modifier;
                    if (p1[this.sortBy] == undefined && p2[this.sortBy] == undefined) return 0;

                    if (p1[this.sortBy].length == 0 && p2[this.sortBy].length > 0) return -1 *
                        modifier;
                    if (p1[this.sortBy].length > 0 && p2[this.sortBy].length == 0) return 1 *
                        modifier;
                    if (p1[this.sortBy].length == 0 && p2[this.sortBy].length == 0) return 0;

                    if (!Number.isNaN(parseInt(p1[this.sortBy])) && !Number.isNaN(parseInt(p2[this
                            .sortBy]))) {
                        if (p1[this.sortBy].indexOf && p2[this.sortBy].indexOf && p1[this.sortBy]
                            .indexOf("-") == -1 && p2[this.sortBy].indexOf("-") == -1) {
                            return (p1[this.sortBy] - p2[this.sortBy]) * modifier;
                        }
                    }

                    if (p1[this.sortBy] < p2[this.sortBy]) return -1 * modifier;
                    if (p1[this.sortBy] > p2[this.sortBy]) return 1 * modifier;
                    return 0;
                });
            },
            setViewType(type) {
                this.viewType = type;
            },
            onPerPageChange(perPage) {
                this.page = 1;
                this.perPage = perPage;
                this.onLoadPagination();
            },
            onPageChange(_p) {
                this.page = _p;
                this.onLoadPagination();
            },
            onPrePage() {
                if (this.page > 1) {
                    this.page = this.page - 1;
                }
                this.onLoadPagination();
            },
            onNextPage() {
                if (this.page < this.count) {
                    this.page = this.page + 1;
                }
                this.onLoadPagination();
            },
            async onLoadPagination() {
                const that = this;
                that.selected = [];
                that.loading = true
                that.list = [];
                let conditionSearch = '?page=' + that.page;
                conditionSearch += '&perPage=' + that.perPage;
                conditionSearch += '&showcount=' + that.showCount;
                conditionSearch += '&type=' + that.type;
                conditionSearch += '&project_id={{ $model->id }}';
                conditionSearch += '&s=' + that.search;
                that.conditionSearch = conditionSearch;

                await jQuery.ajax({
                    type: 'GET',
                    data: that.filterObj,
                    url: "{{ route('api.invoices.getPreProjectInvoice', $model->id) }}" + that
                        .conditionSearch,
                    success: function(data) {

                        that.list = data?.result?.data;
                        that.count = data.result.last_page;
                        that.from = data.result.from;
                        that.to = data.result.to;
                        that.total = data.result.total;

                        let pageArr = [];
                        if (that.page - 2 > 0) {
                            pageArr.push(that.page - 2);
                        }
                        if (that.page - 1 > 0) {
                            pageArr.push(that.page - 1);
                        }
                        pageArr.push(that.page);
                        if (that.page + 1 <= that.count) {
                            pageArr.push(that.page + 1);
                        }
                        if (that.page + 2 <= that.count) {
                            pageArr.push(that.page + 2);
                        }
                        that.listPage = pageArr;
                        that.loading = false
                    },
                    error: function(xhr, textStatus, error) {
                        notifier.warning('Lỗi Hệ Thống!');
                        that.loading = false
                    }
                });
            },
            async createInvoice(formID) {
                let that = this;
                this.createLoading = true
                const form = $(formID);
                console.log(formID);

                const formData = new FormData(form[0]);
                await jQuery.ajax({
                    type: 'POST',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    url: "{{ route('view.invoice.createPreProjectInvoice', $model->id) }}",
                    success: function(data) {
                        that.createLoading = false
                        notifier.success('label.success');
                        resetForm(form[0])
                        $('.modal').modal('hide');
                        that.onLoadPagination();
                        that.validateErrors = {}
                    },
                    error: function(data) {
                        that.createLoading = false
                        that.validateErrors = data.responseJSON.errors
                        notifier.alert(data.responseJSON.message);
                    }
                });
            },
            /*  async bulkDelete() {
                 let that = this;
                 const result = await Swal.fire({
                     title: "{{ trans('label.are_you_sure') }}",
                     html: "{{ trans('label.cant_revert') }}" + "{!! '<br>' !!}" +
                         that.selected,
                     icon: 'warning',
                     showCancelButton: true,
                     confirmButtonColor: '#dc3545',
                     cancelButtonColor: '#ffffff',
                     confirmButtonText: "{{ trans('label.yes_delete_it') }}",
                     cancelButtonText: "{{ trans('label.cancel') }}"
                 });
                 if (result.isConfirmed) {
                     that.createLoading = true
                     await jQuery.ajax({
                         type: 'DELETE',
                         data: {
                             _method: 'DELETE',
                             ids: that.selected
                         },
                         url: "{{ route('view.invoice.bulk_delete') }}",
                         success: function(data) {
                             console.log(data);
                             notifier.success('label.success');
                             that.onLoadPagination();
                         },
                         error: function(data) {
                             notifier.alert(data.responseJSON.message);
                              notifier.alert(data.responseJSON.message);
                         }
                     });
                     that.createLoading = false
                 }
             }, */
            handleSearch() {
                this.loading = true
                this.list = []
                if (this.search !== '') this.showClearSearch = true
                else this.showClearSearch = false;

                if (this.searchTimeout) clearTimeout(this.searchTimeout)
                this.searchTimeout = setTimeout(() => {
                    this.searchFunction();
                }, 400);
            },
            searchFunction() {
                this.page = 1
                this.onLoadPagination();
            },
            clearInput() {
                this.search = ''
                this.showClearSearch = false
                this.onLoadPagination();
            },
            resetSearch() {
                Object.assign(this.filterObj, {
                    status: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
                })
                this.onLoadPagination();
            },
            deleteItem(id) {
                Swal.fire({
                    title: '{{ trans('label.are_you_sure') }}',
                    text: '{{ trans('label.cant_revert') }}',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#dc3545',
                    cancelButtonColor: '#ffffff',
                    confirmButtonText: '{{ trans('label.yes_delete_it') }}',
                    cancelButtonText: '{{ trans('label.cancel') }}'
                }).then((result) => {
                    if (result.isConfirmed) {
                        jQuery('#formDelete_' + id).submit();
                    }
                })

            },
        },
    });
</script>
