 <template id="list_chat">
     <div>
         <div class="d-flex gap-4 pt-1 list-chat">
             <div @click="toggleList" class="user-select-none" role="button">
                 <i class="bi bi-chat-right-dots-fill text-gray-5 pr-2"></i>
                 <span v-if="items.length>0">
                     (( showBtnText ))
                 </span>
                 <span v-else>
                     コメントの追加
                 </span>
             </div>
             <div v-if="listState.isShown && remainingItems > 0" class="user-select-none ms-1" @click="showMore"
                 role="button">
                 (( nextItem)){{ trans('pre_project_comment.show_remain') }}
             </div>
         </div>
         <div v-if="listState.isShown" class="pt-2">
             <div v-for="item in displayedItems" :key="item.id" class="ps-3 mb-3 d-flex chat-item">
                 <div class="d-flex align-item-center floating-button-group-wrapper">
                     {{--  
                   <div class="floating-button-group" v-if="!item.isEditing">
                         <a href="##" class="action-btn rounded p-1 border-none" @click="toggleEdit(item)">
                             @include('icons.pen', ['color' => ['stroke' => '#fff', 'fill' => '#fff']])
                         </a>
                         <a href="##" @click="deleteCommentChat( item.id )"
                             class="action-btn rounded  p-1 border-none">

                             @include('icons.trash', ['color' => ['stroke' => '#fff', 'fill' => '#fff']])
                         </a>

                     </div>
                      --}}
                     <div class="pe-2 rounded-circle">
                         <img :src="((item.creator?.avatar_url))" alt="" class="rounded-circle object-fit-cover"
                             width="30" height="30">
                     </div>
                     <div class="flex-grow-1" v-if="!item.isEditing">
                         <div class="d-flex">
                             <div class="w-100 d-flex flex-column">
                                 <div class=" d-flex">
                                     <p class="m-0 p-0 text-black fw-bold">(( item.creator?.name ))</p>
                                     <div class="ms-auto d-flex align-self-start align-items-center text-nowrap"
                                         v-if="item.isEditable">
                                         <a href="javascript:void(0);" class="pe-3 text-nowrap text-bondi-blue"
                                             data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                             {{ trans('label.action') }} <i class="fas fa-caret-down button_icon"></i>
                                         </a>
                                         <div class="dropdown-menu rounded-7 " data-popper-placement="bottom-start">
                                             <a class="dropdown-item d-flex gap-2" href="##"
                                                 @click="deleteCommentChat( item )">
                                                 {{ trans('label.delete') }}
                                             </a>
                                         </div>
                                         <small class="text-secondary">(( item.created_at_formatted ))</small>
                                     </div>
                                 </div>
                                 <span :class="[{ 'editable-span': item.isEditable }, 'm-0 p-2 text-black']"
                                     v-html="item.content" @click="toggleEdit(item)"></span>
                             </div>

                         </div>
                     </div>

                     <div class="mb-3 flex-grow-1" v-if="item.isEditing">
                         <form @submit.prevent="updateCommentChat" ref="'updateCommentChatForm'+item.id"
                             :id="'updateCommentChatForm' + item.id" method="post" enctype="multipart/form-data">
                             @csrf
                             <ckeditor name="content" v-model="item.content"></ckeditor>
                             <div @click="saveRecord(item)" class="btn btn-primary btn-sm mt-3">
                                 {{ trans('label.save') }}
                             </div>
                             <div class="btn btn-light btn-sm mt-3" @click="toggleEdit(item)">
                                 {{ trans('label.cancel') }}
                             </div>
                         </form>
                     </div>
                 </div>
             </div>
             <form @submit.prevent="createCommentChat" :id="'createCommentChatForm' + comment.id" method="post"
                 enctype="multipart/form-data" class="ps-2 mt-3">
                 @csrf
                 <div>
                     <textarea rows="2" class="form-control" placeholder="用件" @click="toggleAddComment(comment,event)"
                         v-show="!addingComment"></textarea>
                     <ckeditor v-if="addingComment"
                         :textareaClass="[{ 'validate-error--input': validateErrors.content },
                             'form-control'
                         ]"
                         name="content" v-model="content"></ckeditor>
                     <div v-if="addingComment">
                         <div @click="createCommentChat()"
                             :class="[{ 'disabled': createLoading }, 'btn btn-primary btn-sm mt-3']">
                             {{ trans('label.save') }}
                         </div>
                         <div @click="toggleAddComment(comment)"
                             :class="[{ 'disabled': createLoading }, 'btn btn-light btn-sm mt-3']">
                             {{ trans('label.cancel') }}
                         </div>
                     </div>
                 </div>
             </form>
         </div>

     </div>
 </template>


 <script>
     Vue.component('list_chat', {
         template: `#list_chat`,
         delimiters: ["((", "))"],
         props: {
             items: {
                 type: Array,
                 required: true
             },
             comment: {
                 type: Object,
                 required: true
             },
             template_id: {
                 type: String,
                 required: true
             }
         },
         data() {
             return {
                 listState: {
                     isShown: false,
                     currentIndex: 0,
                 },
                 itemsToShow: 5,
                 showBtnText: "{{ trans('pre_project_comment.show_chat') }}",
                 selectedObject: {},
                 validateErrors: {},
                 init: true,
                 content: "",
                 createLoading: false,
                 addingComment: false,
             };
         },
         computed: {
             displayedItems(i = 0) {
                 let arr = this.items.slice(0, this.listState.currentIndex);
                 return arr.reverse();
             },
             remainingItems() {
                 return this.items.length - this.listState.currentIndex;
             },
             nextItem() {
                 return Math.min(5, this.remainingItems);
             },
         },
         mounted() {
             if (this.items.length > 0)
                 this.showBtnText = this.items.length + "{{ trans('pre_project_comment.show_chat') }}"
         },
         methods: {
             toggleAddComment(item, event) {
                 this.addingComment = !this.addingComment;

                 if (event) {
                     setTimeout(() => {
                         const nextElement = $(event.target).next();
                         const editorId = nextElement.find('.cke').attr('id');
                         const editorInstance = CKEDITOR.instances[editorId];
                     }, 100);
                 }
             },
             toggleEdit(item) {
                 if (item.isEditable)
                     item.isEditing = !item.isEditing;
             },
             async saveRecord(item) {
                 this.selectedObject.id = item.id
                 item.isEditing = false;
                 await this.updateCommentChat(item)
             },
             toggleList() {
                 if (this.listState.isShown) {
                     this.listState.isShown = false;
                     this.showBtnText = (this.items.length > 0 ? this.items.length : "") +
                         " {{ trans('pre_project_comment.show_chat') }}"
                     this.listState.currentIndex = 0;
                 } else {
                     this.listState.isShown = true;
                     this.showBtnText = "{{ trans('pre_project_comment.hide_chat') }}"
                     this.listState.currentIndex = Math.min(this.itemsToShow, this.items.length);
                 }
             },
             showMore(i = 0) {
                 if (i > 0)
                     this.listState.currentIndex = this.listState.currentIndex + i
                 else
                     this.listState.currentIndex = Math.min(
                         this.listState.currentIndex + this.itemsToShow,
                         this.items.length
                     );
             },
             async createCommentChat() {
                 let that = this;
                 if (that.content == "" || this.createLoading) {
                     if (that.content == "")
                         notifier.alert("{{ trans('pre_project_comment.please_add_content') }}");
                     return;
                 }
                 this.createLoading = true
                 await jQuery.ajax({
                     type: 'POST',
                     data: {
                         'content': that.content,
                     },
                     url: "{{ route('view.pre_project_comment.addChat') }}/" + that
                         .comment.id,
                     success: function(data) {
                         that.items.unshift({
                             ...data.result
                         })
                         that.showMore(1)
                         that.content = "";
                         that.createLoading = false
                         if (that.template_id == 'list_activity') {
                             if (that.comment.type == 1)
                                 EventBus.$emit('reload_list_note')
                             if (that.comment.type == 2)
                                 EventBus.$emit('reload_list_email')
                             if (that.comment.type == 3)
                                 EventBus.$emit('reload_list_call')
                             if (that.comment.type == 4)
                                 EventBus.$emit('reload_list_task')
                             if (that.comment.type == 5)
                                 EventBus.$emit('reload_list_meeting')
                         } else
                             EventBus.$emit('reload_list_activity')
                     },
                     error: function(data) {
                         that.createLoading = false
                         notifier.alert(data.responseJSON.message);
                     }
                 });
             },
             async updateCommentChat(obj) {
                 let that = this;
                 this.createLoading = true
                 console.log('obj.content');
                 console.log(obj.content);

                 await jQuery.ajax({
                     type: 'POST',
                     data: {
                         'content': obj.content
                     },
                     url: "{{ route('view.pre_project_comment.updateChat') }}/" +
                         that.selectedObject.id,
                     success: function(data) {
                         if (that.template_id == 'list_activity') {
                             if (that.comment.type == 1)
                                 EventBus.$emit('reload_list_note')
                             if (that.comment.type == 2)
                                 EventBus.$emit('reload_list_email')
                             if (that.comment.type == 3)
                                 EventBus.$emit('reload_list_call')
                             if (that.comment.type == 4)
                                 EventBus.$emit('reload_list_task')
                             if (that.comment.type == 5)
                                 EventBus.$emit('reload_list_meeting')
                         } else
                             EventBus.$emit('reload_list_activity')
                         that.createLoading = false
                     },
                     error: function(data) {
                         that.createLoading = false
                         that.validateErrors = data.responseJSON.errors
                         notifier.alert(data.responseJSON.message);
                     }
                 });
             },
             async deleteCommentChat(item) {
                 if (!item.isEditable) return;
                 let that = this;
                 const result = await Swal.fire({
                     title: "{{ trans('label.are_you_sure') }}",
                     html: "{{ trans('label.cant_revert') }}",
                     icon: 'warning',
                     showCancelButton: true,
                     confirmButtonColor: '#dc3545',
                     cancelButtonColor: '#ffffff',
                     confirmButtonText: "{{ trans('label.yes_delete_it') }}",
                     cancelButtonText: "{{ trans('label.cancel') }}"
                 });
                 if (result.isConfirmed) {
                     that.createLoading = true
                     await jQuery.ajax({
                         type: 'DELETE',
                         data: {
                             _method: 'DELETE',
                         },
                         url: "{{ route('view.pre_project_comment.deleteChat') }}/" + item.id,
                         success: function(data) {
                             const index = that.items.findIndex(it => it.id === item.id);
                             if (index !== -1) {
                                 that.items = that.items.splice(index, 1)[0];
                             }
                             if (that.template_id == 'list_activity') {
                                 if (that.comment.type == 1)
                                     EventBus.$emit('reload_list_note')
                                 if (that.comment.type == 2)
                                     EventBus.$emit('reload_list_email')
                                 if (that.comment.type == 3)
                                     EventBus.$emit('reload_list_call')
                                 if (that.comment.type == 4)
                                     EventBus.$emit('reload_list_task')
                                 if (that.comment.type == 5)
                                     EventBus.$emit('reload_list_meeting')
                             } else
                                 EventBus.$emit('reload_list_activity')
                             notifier.success('label.success');
                         },
                         error: function(data) {
                             notifier.alert(data.responseJSON.message);
                             /* notifier.alert(data.responseJSON.message); */
                         }
                     });
                     that.createLoading = false
                 }
             },
         }
     });
 </script>
