<template id="list_call">

    <div>
        <div class="d-flex justify-content-end mb-3">
            <div class="input-group rounded-3 has-clear-btn-input-group me-3">
                <span class="input-group-text bg-white border-end-0" style="border-color: #ced4da"><i
                        class="ri-search-line" style="color: #878a99"></i></span>
                <input type="text" class="form-control border-start-0  ps-0 pe-3 rounded-end-1 " v-model="search"
                    @keyup="handleSearch" style="border-color: #ced4da;" placeholder="{{ trans('label.search') }}">
                <i class="bi bi-x fs-22 position-absolute clearSearchButton" @click="clearInput"
                    v-if="showClearSearch"></i>
            </div>
            <a class="btn text-black bg-white border rounded-3 text-nowrap" data-bs-toggle="modal"
                data-bs-target="#addPreProjectCallModal">
                <i class="fe fe-plus button_icon"></i>{{ trans('pre_project.new_comment_call') }}
            </a>
            <select class="btn btn-light bg-white text-start rounded-3 collapse-all-btn ms-3"
                style="border-color: rgb(206, 212, 218);">
                <option value="expand_all">{{ trans('label.expand_all') }}</option>
                <option value="collapse_all">{{ trans('label.collapse_all') }}</option>
            </select>
        </div>
        <div class="position-relative table-wrapper bg-white rounded-1 mb-3" v-for="item in list">
            <item_call :item="item" template_id="list_call"></item_call>
        </div>

        <div class="position-relative table-wrapper bg-white rounded-1 mb-4 pb-3" v-if="loading">
            <div class="p-3 pb-1  ps-4 pe-4 d-flex align-items-center justify-content-center">
                <div class="spinner-border">
                    <span class="visually-hidden">Loading...</span>
                </div>
            </div>
        </div>

    </div>

</template>

<script>
    Vue.component('list_call', {
        template: '#list_call',
        delimiters: ["((", "))"],
        created() {
            EventBus.$on('reload_list_call', (msg = null) => {
                if (msg) console.log(msg);
                this.list = []
                this.onLoadPagination()
            });
        },
        props: {
            count_data: {
                type: Object,
                default: () => {}
            },
        },
        data() {
            return {
                sortDirection: 'desc',
                sortBy: '',
                count: 0, //total page
                page: 1, //pagination: curent page
                perPage: "{{ $default_records_per_page }}", // pagination: records per page
                total: 0, //pagination: total records
                pageRange: 3, // pagination:controls nearby page display. currenpage counted
                from: 1,
                to: 10,
                list: [],
                conditionSearch: '',
                search: '',
                previewUrl: "{{ $model->logo_url }}",
                modalUrl: "{{ route('view.user.store') }}",
                selectedObject: {},
                listPage: [],
                showCount: 10,
                addChatValidateErrors: {},
                validateErrors: {},
                updateValidateErrors: {},
                createLoading: false,
                viewType: 'list',
                action: 'edit',
                loading: false,
                showClearSearch: false,
                selected: [],
                showed: [],
                attributes: [],
                customer_staff_id: null,
            };
        },
        mounted() {
            const that = this;

            this.onLoadPagination();
        },
        computed: {
            selectAll: {
                get: function() {
                    if (!this.list || this.selected.length == 0) return 0
                    if (this.selected.length == this.list.length) return 1
                    if (this.selected.length != this.list.length) return 2
                },
                set: function(value) {
                    this.selected = value ? this.list.map((row) => row.id) : [];
                }
            }
        },
        methods: {
            sortSelect: function(s) {
                if (s === this.sortBy) {
                    this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                }
                this.sortBy = s;
                this.list.sort((p1, p2) => {
                    let modifier = 1;
                    if (this.sortDirection === 'asc') modifier = -1;
                    let indexA = this.selected.indexOf(p1.template_id);
                    let indexB = this.selected.indexOf(p2.template_id);
                    // Nếu id không có trong selected thì cho nó giá trị lớn để nó được đẩy về sau
                    if (indexA === -1) indexA = Infinity;
                    if (indexB === -1) indexB = Infinity;

                    return (indexA - indexB) * modifier;
                });
            },
            sortTime: function(s) {
                if (s === this.sortBy) {
                    this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                }
                this.sortBy = s;
                this.list = this.list.sort((p1, p2) => {
                    let modifier = this.sortDirection === 'asc' ? 1 : -1;

                    const time1 = p1[this.sortBy].split(':').map(num => parseInt(num));
                    const time2 = p2[this.sortBy].split(':').map(num => parseInt(num));

                    if (time1[0] < time2[0]) return -1 * modifier;
                    if (time1[0] > time2[0]) return 1 * modifier;
                    if (time1[1] < time2[1]) return -1 * modifier;
                    if (time1[1] > time2[1]) return 1 * modifier;
                    return 0;
                });
            },
            sort: function(s) {
                if (s === this.sortBy) {
                    this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                }
                this.sortBy = s;
                this.list = this.list.sort((p1, p2) => {
                    let modifier = 1;
                    if (this.sortDirection === 'desc') modifier = -1;

                    if (p1[this.sortBy] == undefined && p2[this.sortBy] != undefined) return -1 *
                        modifier;
                    if (p1[this.sortBy] != undefined && p2[this.sortBy] == undefined) return 1 *
                        modifier;
                    if (p1[this.sortBy] == undefined && p2[this.sortBy] == undefined) return 0;

                    if (p1[this.sortBy].length == 0 && p2[this.sortBy].length > 0) return -1 *
                        modifier;
                    if (p1[this.sortBy].length > 0 && p2[this.sortBy].length == 0) return 1 *
                        modifier;
                    if (p1[this.sortBy].length == 0 && p2[this.sortBy].length == 0) return 0;

                    if (!Number.isNaN(parseInt(p1[this.sortBy])) && !Number.isNaN(parseInt(p2[this
                            .sortBy]))) {
                        if (p1[this.sortBy].indexOf && p2[this.sortBy].indexOf && p1[this.sortBy]
                            .indexOf("-") == -1 && p2[this.sortBy].indexOf("-") == -1) {
                            return (p1[this.sortBy] - p2[this.sortBy]) * modifier;
                        }
                    }

                    if (p1[this.sortBy] < p2[this.sortBy]) return -1 * modifier;
                    if (p1[this.sortBy] > p2[this.sortBy]) return 1 * modifier;
                    return 0;
                });
            },
            handleSearch() {
                this.loading = true
                this.list = []
                if (this.search !== '') this.showClearSearch = true
                else this.showClearSearch = false;

                if (this.searchTimeout) clearTimeout(this.searchTimeout)
                this.searchTimeout = setTimeout(() => {
                    this.searchFunction();
                }, 400);
            },
            searchFunction() {
                this.page = 1
                this.onLoadPagination();
            },
            clearInput() {
                this.search = ''
                this.list = []
                this.showClearSearch = false
                this.onLoadPagination();
            },
            resetSearch() {
                Object.assign(this.filterObj, {
                    status: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
                })
                this.onLoadPagination();
            },
            previewImage(event) {
                const file = event.target.files[0];
                if (file) {
                    this.previewUrl = URL.createObjectURL(file)
                }
            },
            onPerPageChange(perPage) {
                this.page = 1;
                this.perPage = perPage;
                this.onLoadPagination();
            },
            onPageChange(_p) {
                this.page = _p;
                this.onLoadPagination();
            },
            onPrePage() {
                if (this.page > 1) {
                    this.page = this.page - 1;
                }
                this.onLoadPagination();
            },
            onNextPage() {
                if (this.page < this.count) {
                    this.page = this.page + 1;
                }
                this.onLoadPagination();
            },
            searchFunction() {
                this.page = 1
                this.onLoadPagination();
            },
            onLoadPagination() {
                const that = this;
                that.list = []
                this.loading = true
                let conditionSearch = '?page=' + this.page;
                conditionSearch += '&perPage=' + this.perPage;
                conditionSearch += '&showcount=' + this.showCount;
                conditionSearch += '&type=3';
                conditionSearch += '&pre_project_id={{ $model->id }}';
                conditionSearch += '&s=' + this.search;
                this.conditionSearch = conditionSearch;

                jQuery.ajax({
                    type: 'GET',
                    url: "{{ route('api.pre_projects.list_comment', $model->id) }}" +
                        conditionSearch,
                    success: function(data) {
                        that.list = data.result.data;
                        that.count = data.result.last_page;
                        that.from = data.result.from;
                        that.to = data.result.to;
                        that.total = data.result.total;
                        that.count_data.call = that.total
                        let pageArr = [];
                        if (that.page - 2 > 0) {
                            pageArr.push(that.page - 2);
                        }
                        if (that.page - 1 > 0) {
                            pageArr.push(that.page - 1);
                        }
                        pageArr.push(that.page);
                        if (that.page + 1 <= that.count) {
                            pageArr.push(that.page + 1);
                        }
                        if (that.page + 2 <= that.count) {
                            pageArr.push(that.page + 2);
                        }
                        that.listPage = pageArr;
                        that.loading = false
                    },
                    error: function(xhr, textStatus, error) {
                        that.loading = false
                        notifier.warning('Lỗi Hệ Thống!');
                    }
                });
            },
            openUpdatePreProjectCallModal(obj, modalId, action = 'edit') {
                this.selectedObject = {
                    ...obj
                }
                //fix vue select2
                this.action = action
                $(modalId + " [name='customer_staff_id'")?.val(obj.customer_staff_id)
                $(modalId + " [name='customer_staff_id'")?.trigger('change')
                CKEDITOR.instances['update_comment_note']?.setData(obj.note);
            },

            async updatePreProjectCall() {
                let that = this;
                this.createLoading = true
                const form = $('#updatePreProjectCallForm');
                const formData = new FormData(form[0]);
                await jQuery.ajax({
                    type: 'POST',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    url: "{{ route('view.pre_project_comment.update') }}/" +
                        that.selectedObject.id,
                    success: function(data) {
                        notifier.success('label.success');
                        that.createLoading = false
                        resetForm(form[0])

                        $('.modal').modal('hide');
                        that.onLoadPagination();
                    },
                    error: function(data) {
                        that.createLoading = false
                        that.validateErrors = data.responseJSON.errors
                        notifier.alert(data.responseJSON.message);
                    }
                });
            },
            async deletePreProjectCall(id) {
                Swal.fire({
                    title: '{{ trans('label.are_you_sure') }}',
                    text: '{{ trans('label.cant_revert') }}',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#dc3545',
                    cancelButtonColor: '#ffffff',
                    confirmButtonText: '{{ trans('label.yes_delete_it') }}',
                    cancelButtonText: '{{ trans('label.cancel') }}'
                }).then((result) => {
                    if (result.isConfirmed) {
                        console.log('#formDeletePreProjectCall_' + id);
                        $('#formDeletePreProjectCall_' + id).submit();
                    }
                })
            },

        },
    });
</script>
