<template id="item_note">

    <div class="pb-3 rounded-1 pre-project-comment" :style="{ backgroundColor: item.theme_color.str_val1 }">
        <div class="p-3 pb-1 ps-4 pe-4 d-flex align-items-center">
            <button type="button" data-bs-toggle="collapse" :data-bs-target="'#collapsePreProjectComment' + item.id"
                aria-expanded="true" aria-controls="collapsePreProjectComment"
                class=" gino-accordion-item__button text-black flex-1 ">
                <span v-html="item.title"></span>
            </button>
            <div class="chat-count text-secondary">
                <i class="bi bi-chat-right-dots-fill  pr-2"></i>
                <small>(( item.chats.length ))</small>
            </div>
            <div class="text-bondi-blue text-nowrap ms-auto d-flex align-items-center">
                <div class="d-flex me-2 comment-color-picker dropdown-center action-btn rounded p-1">
                    <a href="javascript:void(0);" class="color-picker-dropdown-button" data-bs-toggle="dropdown"
                        data-bs-offset="0,10" aria-haspopup="true" aria-expanded="true"
                        :style="{ backgroundColor: item.theme_color.str_val3 }">
                    </a>
                    {{--  :style="{ backgroundColor: item.theme_color.str_val3 }" --}}
                    <div class="color-picker-dropdown dropdown-menu rounded-7" style="width:188px"
                        data-popper-placement="bottom-start">
                        <div class="color-picker-list">
                            <span class="flex-1 color-picker-item" v-for="themeColor in commentThemeColor"
                                :style="{ backgroundColor: themeColor.str_val3 }"
                                @click="changeCommentThemeColor(themeColor)"></span>

                        </div>
                    </div>
                </div>
                <div class="d-inline-flex me-3 gap-2">
                    <a class="action-btn rounded p-1" href="##"
                        @click="toggleEdit(item,'content'+ template_id + item.id)">
                        @include('icons.pen')</a>
                    </a>
                    <a class="action-btn rounded p-1" href="##" @click="deleteItem">
                        @include('icons.trash')</a>
                    </a>
                    <a class="action-btn rounded p-1" href="javascript:void(0);"
                        onclick="copyContent('{{ Request::url() }}')">
                        @include('icons.copy')</a>
                    </a>
                </div>
                <a href="javascript:void(0);" class="pe-3 text-nowrap text-bondi-blue" data-bs-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="true">
                    {{ trans('label.action') }} <i class="fas fa-caret-down button_icon"></i>
                </a>
                <div class="dropdown-menu rounded-7" data-popper-placement="bottom-start">
                    <a class="dropdown-item" href="javascript:void(0);">
                        {{ trans('label.pin') }}
                    </a>
                    {{--  <a class="dropdown-item d-flex gap-2" href="##" @click="deleteItem">
                        {{ trans('label.delete') }}
                    </a>
                    <a class="dropdown-item" href="javascript:void(0);">
                        {{ trans('label.copy') }}
                    </a> --}}
                </div>
                <small class="text-secondary">(( item.created_at_formatted ))</small>
            </div>
        </div>
        <div :id="'collapsePreProjectComment' + item.id"
            class="accordion-collapse collapse show px-4 text-bondi-blue editable-content">
            <div>
                <div v-if="!item.isEditing" class="mb-2">
                    <span @click="toggleEdit(item,'content'+ template_id + item.id)" v-html="item.content"
                        class="editable-span text-black"></span>
                </div>

                <div v-if="item.isEditing" class="mb-3">
                    <form @submit.prevent="" :ref="'updatePreProjectCommentForm' + template_id + item.id"
                        :id="'updatePreProjectCommentForm' + template_id + item.id" method="post"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <ckeditor name="content" v-model="item.content" class="content"></ckeditor>
                        <div @click="saveRecord(item ,'content' + template_id + item.id)"
                            class="btn btn-primary btn-sm mt-3">
                            {{ trans('label.save') }}
                        </div>
                        <div class="btn btn-light btn-sm mt-3"
                            @click="toggleEdit(item, 'content' + template_id + item.id)">
                            {{ trans('label.cancel') }}
                        </div>

                    </form>
                </div>
            </div>
            <list_chat :items="item.chats" :comment="item" :template_id="template_id"></list_chat>
        </div>
    </div>

</template>



<script>
    Vue.component('item_note', {
        template: `#item_note`,
        delimiters: ["((", "))"],
        props: {
            item: {
                type: Object,
                required: true
            },
            template_id: {
                type: String,
                required: true
            }
        },
        data() {
            return {
                selectedObject: {},
                addChatValidateErrors: {},
                validateErrors: {},
                updateValidateErrors: {},
                createLoading: false,
                viewType: 'list',
                action: 'edit',
                loading: false,
                showClearSearch: false,
                selected: [],
                showed: [],
                attributes: [],
                customer_staff_id: null,
                commentThemeColor: @json($commentThemeColor),
            };
        },
        mounted() {
            const that = this;
        },
        computed: {},
        methods: {
            changeCommentThemeColor(themeColor) {
                that = this
                if (that.item.theme_color_id == themeColor.key3) return;
                that.item.theme_color = themeColor;
                that.item.theme_color_id = themeColor.key3;

                jQuery.ajax({
                    type: 'POST',
                    data: {
                        'theme_color_id': themeColor.key3,
                    },
                    url: "{{ route('view.pre_project_comment.update_theme_color') }}/" +
                        that.item.id,
                    success: function(data) {},
                    error: function(data) {}
                });
            },
            toggleEdit(obj, id) {
                obj.isEditing = !obj.isEditing;
            },
            saveRecord(obj, id) {

                this.selectedObject.id = obj.id
                this.updatePreProjectComment()
                obj.isEditing = false
            },
            async updatePreProjectComment() {
                let that = this;
                this.createLoading = true
                await jQuery.ajax({
                    type: 'PUT',
                    data: {
                        'content': that.item?.content,
                    },
                    url: "{{ route('view.pre_project_comment.update') }}/" +
                        that.selectedObject.id,
                    success: function(data) {
                        that.createLoading = false
                        if (that.template_id == 'list_note')
                            EventBus.$emit('reload_list_activity')
                        if (that.template_id == 'list_activity')
                            EventBus.$emit('reload_list_note')
                    },
                    error: function(data) {
                        that.createLoading = false
                        that.validateErrors = data.responseJSON.errors
                        notifier.alert(data.responseJSON.message);
                    }
                });
            },
            async deletePreProjectComment(id) {
                Swal.fire({
                    title: '{{ trans('label.are_you_sure') }}',
                    text: '{{ trans('label.cant_revert') }}',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#dc3545',
                    cancelButtonColor: '#ffffff',
                    confirmButtonText: '{{ trans('label.yes_delete_it') }}',
                    cancelButtonText: '{{ trans('label.cancel') }}'
                }).then((result) => {
                    if (result.isConfirmed) {
                        console.log('#formDeletePreProjectComment_' + id);
                        $('#formDeletePreProjectComment_' + id).submit();
                    }
                })
            },
            async deleteItem() {
                const result = await Swal.fire({
                    title: "{{ trans('label.are_you_sure') }}",
                    html: "{{ trans('label.cant_revert') }}",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#dc3545',
                    cancelButtonColor: '#ffffff',
                    confirmButtonText: "{{ trans('label.yes_delete_it') }}",
                    cancelButtonText: "{{ trans('label.cancel') }}"
                });
                if (result.isConfirmed) {
                    that = this
                    that.createLoading = true
                    await jQuery.ajax({
                        type: 'DELETE',
                        data: {
                            _method: 'DELETE',
                        },
                        url: "{{ route('view.pre_project_comment.destroy') }}/" +
                            that?.item?.id,
                        success: function(data) {
                            EventBus.$emit('reload_list_note')
                            EventBus.$emit('reload_list_activity')
                            notifier.success('label.success');
                        },
                        error: function(data) {
                            notifier.alert(data.responseJSON.message);
                        }
                    });
                    that.createLoading = false
                }
            },
        },
    });
</script>
