<template id="item_meeting">

    <div class="pb-3 rounded-1 pre-project-comment" :style="{ backgroundColor: item.theme_color.str_val1 }">
        <div class="p-3 pb-1  ps-4 pe-4 d-flex align-items-center">
            <button type="button" data-bs-toggle="collapse"
                :data-bs-target="'#collapsePreProjectComment' + template_id + item.id" aria-expanded="true"
                aria-controls="collapsePreProjectComment" class="gino-accordion-item__button text-black flex-1 ">
                <span v-html="item.title"></span>
            </button>
            <div class="chat-count text-secondary">
                <i class="bi bi-chat-right-dots-fill  pr-2"></i>
                <small>(( item.chats.length ))</small>
            </div>
            <div class="text-bondi-blue text-nowrap ms-auto d-flex align-items-center">
                <div class="d-flex me-2 comment-color-picker dropdown-center action-btn rounded p-1">
                    <a href="javascript:void(0);" class="color-picker-dropdown-button" data-bs-toggle="dropdown"
                        data-bs-offset="0,10" aria-haspopup="true" aria-expanded="true"
                        :style="{ backgroundColor: item.theme_color.str_val3 }">
                    </a>
                    {{--  :style="{ backgroundColor: item.theme_color.str_val3 }" --}}
                    <div class="color-picker-dropdown dropdown-menu rounded-7" style="width:188px"
                        data-popper-placement="bottom-start">
                        <div class="color-picker-list">
                            <span class="flex-1 color-picker-item" v-for="themeColor in commentThemeColor"
                                :style="{ backgroundColor: themeColor.str_val3 }"
                                @click="changeCommentThemeColor(themeColor)"></span>

                        </div>
                    </div>
                </div>
                <div class="d-inline-flex me-3 gap-2">
                    <a class="action-btn rounded p-1" href="##"
                        @click="openUpdateModal('#updatePreProjectCommentModal' + template_id + item.id)">
                        @include('icons.pen')</a>
                    </a>
                    <a class="action-btn rounded p-1" href="##" @click="deleteItem">
                        @include('icons.trash')</a>
                    </a>
                    <a class="action-btn rounded p-1" href="javascript:void(0);"
                        onclick="copyContent('{{ Request::url() }}')">
                        @include('icons.copy')</a>
                    </a>
                </div>
                <a href="javascript:void(0);" class="pe-3 text-nowrap text-bondi-blue" data-bs-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="true">
                    {{ trans('label.action') }} <i class="fas fa-caret-down button_icon"></i>
                </a>
                <div class="dropdown-menu rounded-7" data-popper-placement="bottom-start">
                    <a class="dropdown-item d-flex align-items-center gap-2" href="javascript:void(0);">
                        <i class="bi bi-pin-angle "></i> {{ trans('label.pin') }}
                    </a>
                    <a class="dropdown-item d-flex align-items-center gap-2" href="javascript:void(0);"
                        @click="createEvent">
                        <i class="bi bi-calendar-plus"></i> {{ trans('pre_project_comment.create_event') }}
                    </a>
                </div>
                <small class="text-secondary">(( item.created_at_formatted ))</small>
            </div>
        </div>
        <div :id="'collapsePreProjectComment' + template_id + item.id"
            class="accordion-collapse collapse show px-4  editable-content text-bondi-blue">
            <div>
                <div :class="[{ 'd-none': item.isEditing }, 'mb-3']">
                    <span v-html="item.content" class=" text-black"></span>
                </div>
                <div class="d-flex gap-5 border-top pt-2 pb-3 mb-2 border-bottom">

                    <div>
                        <div class="text-gray-8 fs-12 mb-1 lh-lg"> {{ trans('pre_project_comment.result') }}
                        </div>
                        <div class="d-flex align-items-center gap-2" v-if="item.result">
                            ((item.result_name))</div>
                    </div>
                    <div>
                        <div class="text-gray-8 fs-12 mb-1 lh-lg"> {{ trans('pre_project_comment.participants') }}
                        </div>
                        <div class="d-flex align-items-center gap-2" v-if="item.participants">
                            ((item.participants))</div>
                    </div>
                    <div>
                        <div class="text-gray-8 fs-12 mb-1 lh-lg"> {{ trans('pre_project_comment.time_count') }}
                        </div>
                        <div class="d-flex align-items-center gap-2" v-if="item.time_count">
                            ((item.time_count))</div>
                    </div>

                    <div>
                        <div class="text-gray-8 fs-12 mb-1 lh-lg"> {{ trans('pre_project_comment.date') }}</div>
                        <div class="d-flex align-items-center gap-2" v-if="item.date"><i
                                class="ri-calendar-line"></i>((item.date))</div>
                    </div>
                    <div>
                        <div class="text-gray-8 fs-12 mb-1 lh-lg"> {{ trans('pre_project_comment.time') }}</div>
                        <div class="d-flex align-items-center gap-2" v-if="item.time"><i
                                class="ri-time-line"></i>((item.time))</div>
                    </div>

                </div>
            </div>
            <list_chat :items="item.chats" :comment="item" :template_id="template_id"></list_chat>
        </div>

        <!-- Modal -->
        <div class="modal fade gino-modal" v-if="!modalLoading"
            :id="'updatePreProjectCommentModal' + template_id + item.id" tabindex="-1" role="dialog"
            aria-hidden="true">
            <div class="modal-dialog " role="document">
                <div class="modal-content custom-modal-content">
                    <div class="modal-header border-0  bg-light p-3">
                        <h6 class="modal-title">
                            (( modalTitle ))
                        </h6>
                        <button type="button" class="btn-close btn-close-black " data-bs-dismiss="modal"
                            aria-label="Close">
                        </button>
                    </div>
                    <form @submit.prevent="updatePreProjectComment"
                        :ref="'updatePreProjectCommentForm' + template_id + item.id"
                        :id="'updatePreProjectCommentForm' + template_id + item.id" method="post"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="modal-body p-20">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <label for="result"
                                        class="form-label">{{ trans('pre_project_comment.result') }}</label>
                                    <select
                                        :class="[{ 'validate-error--input': validateErrors.result }, 'form-control']"
                                        v-model="selectedObject.result" name="result">
                                        @foreach ($result as $key => $item)
                                            <option value="{{ $item->key3 }}">
                                                {{ $item->str_val1 }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <div class="validate-error--text text-danger" v-if="validateErrors.result"
                                        v-for="err in validateErrors.customer_type">
                                        <small>
                                            (( err ))
                                        </small>
                                    </div>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="participants"
                                        class="form-label">{{ trans('pre_project_comment.participants') }}</label>
                                    <input type="text" v-model="selectedObject.participants"
                                        :class="[{ 'validate-error--input': validateErrors.participants }, 'form-control']"
                                        name="participants">
                                    <div class="validate-error--text text-danger" v-if="validateErrors.participants"
                                        v-for="err in validateErrors.participants">
                                        <small>
                                            (( err ))
                                        </small>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="time_count"
                                        class="form-label">{{ trans('pre_project_comment.time_count') }}</label>
                                    <input type="number" v-model="selectedObject.time_count"
                                        :class="[{ 'validate-error--input': validateErrors.time_count }, 'form-control']"
                                        name="time_count">
                                    <div class="validate-error--text text-danger" v-if="validateErrors.time_count"
                                        v-for="err in validateErrors.time_count">
                                        <small>
                                            (( err ))
                                        </small>
                                    </div>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="date"
                                        class="form-label">{{ trans('pre_project_comment.date') }}</label>
                                    <input type="date" v-model="selectedObject.date"
                                        :class="[{ 'validate-error--input': validateErrors.date }, 'form-control']"
                                        name="date">
                                    <div class="validate-error--text text-danger" v-if="validateErrors.date"
                                        v-for="err in validateErrors.date">
                                        <small>
                                            (( err ))
                                        </small>
                                    </div>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="time"
                                        class="form-label">{{ trans('pre_project_comment.time') }}</label>
                                    <input type="time" v-model="selectedObject.time"
                                        :class="[{ 'validate-error--input': validateErrors.time }, 'form-control']"
                                        name="time">
                                    <div class="validate-error--text text-danger" v-if="validateErrors.time"
                                        v-for="err in validateErrors.time">
                                        <small>
                                            (( err ))
                                        </small>
                                    </div>
                                </div>

                                <div class="col-sm-12 mb-3">
                                    <label for="content"
                                        class="form-label">{{ trans('pre_project_comment.content') }}</label>
                                    <ckeditor
                                        :textareaClass="[{ 'validate-error--input': updateValidateErrors.content },
                                            'form-control'
                                        ]"
                                        name="content" v-model="selectedObject.content"></ckeditor>
                                    <div class="validate-error--text text-danger" v-if="updateValidateErrors.content"
                                        v-for="err in updateValidateErrors.content">
                                        <small>
                                            (( err ))
                                        </small>
                                    </div>
                                </div>
                                <div class="col-sm-12 mb-3">
                                    <label for="reply_content"
                                        class="form-label">{{ trans('pre_project_comment.reply_content') }}</label>
                                    <ckeditor
                                        :textareaClass="[{ 'validate-error--input': updateValidateErrors.reply_content },
                                            'form-control'
                                        ]"
                                        name="reply_content" v-model="selectedObject.reply_content">
                                    </ckeditor>
                                    <div class="validate-error--text text-danger"
                                        v-if="updateValidateErrors.reply_content"
                                        v-for="err in updateValidateErrors.reply_content">
                                        <small>
                                            (( err ))
                                        </small>
                                    </div>
                                </div>

                                <div class="col-sm-12 mb-3">
                                    <label for="file"
                                        class="form-label">{{ trans('pre_project_comment.file') }}</label>
                                    <div v-if="selectedObject.file_url"> <a :href="selectedObject.file_url"
                                            target="_blank" class="mb-2">((selectedObject.file))</a></div>

                                    <input type="file"
                                        :class="[{ 'validate-error--input': updateValidateErrors.file }, 'form-control']"
                                        :disabled="action == 'view'" name="file">
                                    <div class="validate-error--text text-danger" v-if="updateValidateErrors.file"
                                        v-for="err in updateValidateErrors.file">
                                        <small>
                                            (( err ))
                                        </small>
                                    </div>
                                </div>

                                <div class="col-12 mb-3">
                                    <label for="customer_staff_id"
                                        class="form-label">{{ trans('pre_project.customer_staff_id') }}</label>
                                    <select
                                        :class="[{ 'validate-error--select2': updateValidateErrors.customer_staff_id },
                                            'form-control'
                                        ]"
                                        :disabled="action == 'view'" name="customer_staff_id"
                                        :id="'customer_staff_id' + template_id + item.id"
                                        v-model="selectedObject.customer_staff_id"
                                        :data-dropdown-parent="'#updatePreProjectCommentModal' + template_id + item.id"
                                        data-allow-clear="true" v-select2>
                                        <option value=""></option>
                                        @foreach ($customer_staffs as $item)
                                            <option value="{{ $item->customer_staff_id }}">
                                                {{ $item->customer_staff_id . ' ' . $item->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <div class="validate-error--text text-danger"
                                        v-if="updateValidateErrors.customer_staff_id"
                                        v-for="err in updateValidateErrors.customer_staff_id">
                                        <small>
                                            (( err ))
                                        </small>
                                    </div>
                                </div>
                                <!-- ((action)) -->
                                <div class="col-md-12 mb-3">
                                    <label for="status"
                                        class="form-label">{{ trans('pre_project.status') }}</label>
                                    <select
                                        :class="[{ 'validate-error--input': updateValidateErrors.status }, 'form-control']"
                                        :disabled="action == 'view'" v-model="item.status" name="status">
                                        @foreach ($comment_status as $key => $item)
                                            <option value="{{ $item->key3 }}"
                                                {{ $model->status == $item->key3 ? 'selected' : '' }}>
                                                {{ $item->str_val1 }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <div class="validate-error--text text-danger" v-if="updateValidateErrors.status"
                                        v-for="err in updateValidateErrors.status">
                                        <small>
                                            (( err ))
                                        </small>
                                    </div>
                                </div>


                            </div>
                        </div>
                        <div class="modal-footer border-0 p-3 pt-0 gap-2 justify-content-end" v-if="action !='view'">
                            <div v-if="createLoading">
                                <div class="spinner-border">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                            </div>
                            <div class="btn btn-light" data-bs-dismiss="modal" aria-hidden="true">
                                {{ trans('label.cancel') }}
                            </div>

                            <button type="submit" class="btn btn-primary ">
                                {{ trans('label.save') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</template>



<script>
    Vue.component('item_meeting', {
        template: `#item_meeting`,
        delimiters: ["((", "))"],
        props: {
            item: {
                type: Object,
                required: true
            },
            template_id: {
                type: String,
                required: true
            }
        },
        data() {
            return {
                selectedObject: {},
                addChatValidateErrors: {},
                validateErrors: {},
                updateValidateErrors: {},
                createLoading: false,
                viewType: 'list',
                action: 'edit',
                loading: false,
                showClearSearch: false,
                selected: [],
                showed: [],
                attributes: [],
                customer_staff_id: null,
                modalTitle: '',
                modalLoading: true,
                commentThemeColor: @json($commentThemeColor),
            };
        },
        mounted() {
            const that = this;

            switch (that.item.type) {
                case 2:
                    that.modalTitle =
                        "{{ trans('pre_project_comment.update_email') }}";
                    break;
                case 3:
                    that.modalTitle =
                        "{{ trans('pre_project_comment.update_call') }}";
                    break;
                case 4:
                    that.modalTitle =
                        "{{ trans('pre_project_comment.update_task') }}";
                    break;
                case 5:
                    that.modalTitle =
                        "{{ trans('pre_project_comment.update_meeting') }}";
                    break;
                default:
                    that.modalTitle =
                        "{{ trans('pre_project_comment.update_note') }}";
            }

            that.selectedObject = {
                ...that.item
            }

        },
        computed: {},
        methods: {
            changeCommentThemeColor(themeColor) {
                that = this
                if (that.item.theme_color_id == themeColor.key3) return;
                that.item.theme_color = themeColor;
                that.item.theme_color_id = themeColor.key3;

                jQuery.ajax({
                    type: 'POST',
                    data: {
                        'theme_color_id': themeColor.key3,
                    },
                    url: "{{ route('view.pre_project_comment.update_theme_color') }}/" +
                        that.item.id,
                    success: function(data) {},
                    error: function(data) {}
                });
            },
            openUpdateModal(id) {
                this.modalLoading = false
                setTimeout(() => {
                    $(id).modal('show');
                }, 100);
            },
            createEvent() {
                console.log(1)
                let that = this
                jQuery.ajax({
                    type: 'POST',
                    url: "{{ route('view.pre_project_comment.createEvent') }}/" +
                        that.item.id,
                    success: function(data) {
                        console.log(data);

                        let element = notifier.success(
                            '予定<a href="' + data.result.url + '">' +
                            data.result.event.event_id + '</a>を新規追加しました。'
                        );
                        customizeNotification(element);
                    },
                    error: function(data) {
                        that.validateErrors = data.responseJSON.errors
                        notifier.alert(data.responseJSON.message);
                    }
                });
            },
            async updatePreProjectComment() {
                let that = this;
                that.createLoading = true
                const form = $('#updatePreProjectCommentForm' + that.template_id + that.item.id);
                const formData = new FormData(form[0]);
                formData.append('_method', 'PUT');
                await jQuery.ajax({
                    type: 'POST',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    url: "{{ route('view.pre_project_comment.update') }}/" +
                        that.item.id,
                    success: function(data) {
                        that.createLoading = false
                        $('.modal').modal('hide');
                        if (that.template_id == 'list_activity') {
                            if (that.item.type == 2)
                                EventBus.$emit('reload_list_email')
                            if (that.item.type == 3)
                                EventBus.$emit('reload_list_call')
                            if (that.item.type == 4)
                                EventBus.$emit('reload_list_task')
                            if (that.item.type == 5)
                                EventBus.$emit('reload_list_meeting')
                        } else
                            EventBus.$emit('reload_list_activity')

                        that.item = data.result
                    },
                    error: function(data) {
                        that.createLoading = false
                        that.validateErrors = data.responseJSON.errors
                        notifier.alert(data.responseJSON.message);
                    }
                });
            },
            async deletePreProjectComment(id) {
                Swal.fire({
                    title: '{{ trans('label.are_you_sure') }}',
                    text: '{{ trans('label.cant_revert') }}',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#dc3545',
                    cancelButtonColor: '#ffffff',
                    confirmButtonText: '{{ trans('label.yes_delete_it') }}',
                    cancelButtonText: '{{ trans('label.cancel') }}'
                }).then((result) => {
                    if (result.isConfirmed) {
                        console.log('#formDeletePreProjectComment_' + id);
                        $('#formDeletePreProjectComment_' + id).submit();
                    }
                })
            },
            async deleteItem() {
                const result = await Swal.fire({
                    title: "{{ trans('label.are_you_sure') }}",
                    html: "{{ trans('label.cant_revert') }}",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#dc3545',
                    cancelButtonColor: '#ffffff',
                    confirmButtonText: "{{ trans('label.yes_delete_it') }}",
                    cancelButtonText: "{{ trans('label.cancel') }}"
                });
                if (result.isConfirmed) {
                    that = this
                    that.createLoading = true
                    await jQuery.ajax({
                        type: 'DELETE',
                        data: {
                            _method: 'DELETE',
                        },
                        url: "{{ route('view.pre_project_comment.destroy') }}/" +
                            that?.item?.id,
                        success: function(data) {
                            EventBus.$emit('reload_list_meeting')
                            EventBus.$emit('reload_list_activity')
                            notifier.success('label.success');
                        },
                        error: function(data) {
                            notifier.alert(data.responseJSON.message);
                        }
                    });
                    that.createLoading = false
                }
            },
        },
    });
</script>
