<template id="item_default">

    <div class="pb-3">
        {{-- init --}}
        <template v-if="item.type == 0">
            <div class="p-3 pb-1  ps-4 pe-4 d-flex align-items-center">

                <span v-html="item.content" class=" text-black"></span>
                <div class="text-bondi-blue text-nowrap ms-auto d-flex align-items-center">

                    <small class="text-secondary">(( item.created_at_formatted ))</small>
                </div>
            </div>
        </template>

        {{-- update status --}}
        <template v-if="item.type == 99">
            <div class="p-3 pb-1  ps-4 pe-4 d-flex align-items-center">
                <button type="button" data-bs-toggle="collapse"
                    :data-bs-target="'#collapsePreProjectComment' + template_id + item.id" aria-expanded="true"
                    aria-controls="collapsePreProjectComment" class=" gino-accordion-item__button text-black flex-1 ">
                    <span v-html="item.title"></span>
                </button>
                {{-- <span v-html="item.content" class=" text-black"></span> --}}
                <div class="text-bondi-blue text-nowrap ms-auto d-flex align-items-center">

                    <small class="text-secondary">(( item.created_at_formatted ))</small>
                </div>
            </div>
            <div :id="'collapsePreProjectComment' + template_id + item.id"
                class="accordion-collapse collapse show px-4 text-bondi-blue editable-content">
                <div>
                    <div class="mb-2">
                        <span v-html="item.content" class=" text-black"></span>
                    </div>

                </div>
            </div>
        </template>

    </div>
</template>



<script>
    Vue.component('item_default', {
        template: `#item_default`,
        delimiters: ["((", "))"],
        props: {
            item: {
                type: Object,
                required: true
            },
            template_id: {
                type: String,
                required: true
            }
        },
        data() {
            return {
                selectedObject: {},
                addChatValidateErrors: {},
                validateErrors: {},
                updateValidateErrors: {},
                createLoading: false,
                viewType: 'list',
                action: 'edit',
                loading: false,
                showClearSearch: false,
                selected: [],
                showed: [],
                attributes: [],
                customer_staff_id: null,
                modalTitle: '',
                modalLoading: true,
                commentThemeColor: @json($commentThemeColor),
            };
        },
        mounted() {
            const that = this;

            switch (that.item.type) {
                case 2:
                    that.modalTitle =
                        "{{ trans('pre_project_comment.update_email') }}";
                    break;
                case 3:
                    that.modalTitle =
                        "{{ trans('pre_project_comment.update_call') }}";
                    break;
                case 4:
                    that.modalTitle =
                        "{{ trans('pre_project_comment.update_task') }}";
                    break;
                case 5:
                    that.modalTitle =
                        "{{ trans('pre_project_comment.update_meeting') }}";
                    break;
                default:
                    that.modalTitle =
                        "{{ trans('pre_project_comment.update_note') }}";
            }

            that.selectedObject = {
                ...that.item
            }


        },
        computed: {},
        methods: {
            changeCommentThemeColor(themeColor) {
                that = this
                that.item.theme_color = themeColor;

                jQuery.ajax({
                    type: 'POST',
                    data: {
                        'theme_color_id': themeColor.key3,
                    },
                    url: "{{ route('view.pre_project_comment.update_theme_color') }}/" +
                        that.item.id,
                    success: function(data) {},
                    error: function(data) {}
                });
            },
            openUpdateModal(id) {
                this.modalLoading = false
                setTimeout(() => {
                    $(id).modal('show');
                }, 100);
            },
            async updatePreProjectComment() {
                let that = this;
                that.createLoading = true
                const form = $('#updatePreProjectCommentForm' + that.template_id + that.item.id);
                const formData = new FormData(form[0]);
                formData.append('_method', 'PUT');
                await jQuery.ajax({
                    type: 'POST',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    url: "{{ route('view.pre_project_comment.update') }}/" +
                        that.item.id,
                    success: function(data) {
                        that.createLoading = false
                        $('.modal').modal('hide');
                        if (that.template_id == 'list_activity') {
                            if (that.item.type == 2)
                                EventBus.$emit('reload_list_email')
                            if (that.item.type == 3)
                                EventBus.$emit('reload_list_call')
                            if (that.item.type == 4)
                                EventBus.$emit('reload_list_task')
                            if (that.item.type == 5)
                                EventBus.$emit('reload_list_meeting')
                        } else
                            EventBus.$emit('reload_list_activity')
                        that.item = data.result
                    },
                    error: function(data) {
                        that.createLoading = false
                        that.validateErrors = data.responseJSON.errors
                        notifier.alert(data.responseJSON.message);
                    }
                });
            },
            createTask() {
                let that = this
                jQuery.ajax({
                    type: 'POST',
                    url: "{{ route('view.pre_project_comment.createTask') }}/" +
                        that.item.id,
                    success: function(data) {
                        console.log(data);

                        let element = notifier.success(
                            '予定<a href="' + data.result.url + '">' +
                            data.result.task.task_id + '</a>を新規追加しました。'
                        );
                        customizeNotification(element);
                    },
                    error: function(data) {
                        that.validateErrors = data.responseJSON.errors
                        notifier.alert(data.responseJSON.message);
                    }
                });
            },
            async deletePreProjectComment(id) {
                Swal.fire({
                    title: '{{ trans('label.are_you_sure') }}',
                    text: '{{ trans('label.cant_revert') }}',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#dc3545',
                    cancelButtonColor: '#ffffff',
                    confirmButtonText: '{{ trans('label.yes_delete_it') }}',
                    cancelButtonText: '{{ trans('label.cancel') }}'
                }).then((result) => {
                    if (result.isConfirmed) {
                        console.log('#formDeletePreProjectComment_' + id);
                        $('#formDeletePreProjectComment_' + id).submit();
                    }
                })
            },
            async deleteItem() {
                const result = await Swal.fire({
                    title: "{{ trans('label.are_you_sure') }}",
                    html: "{{ trans('label.cant_revert') }}",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#dc3545',
                    cancelButtonColor: '#ffffff',
                    confirmButtonText: "{{ trans('label.yes_delete_it') }}",
                    cancelButtonText: "{{ trans('label.cancel') }}"
                });
                if (result.isConfirmed) {
                    that = this
                    that.createLoading = true
                    await jQuery.ajax({
                        type: 'DELETE',
                        data: {
                            _method: 'DELETE',
                        },
                        url: "{{ route('view.pre_project_comment.destroy') }}/" +
                            that?.item?.id,
                        success: function(data) {
                            if (that.item.type == 4)
                                EventBus.$emit('reload_list_task')
                            if (that.item.type == 5)
                                EventBus.$emit('reload_list_meeting')
                            EventBus.$emit('reload_list_activity')
                            notifier.success('label.success');
                        },
                        error: function(data) {
                            notifier.alert(data.responseJSON.message);
                        }
                    });
                    that.createLoading = false
                }
            },
        },
    });
</script>
