@extends('layouts.master')

@section('title', 'pre_project')

@section('content')
    <div id="App">
        <div class="container-fluid">
            <!-- Page Header -->
            <div class="d-md-flex d-block align-items-center justify-content-between my-4 page-header-breadcrumb">
                <div class="my-auto">
                    <h4 class="mb-0">{{ trans('pre_project.pre_project') }}</h4>
                    <nav>
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="{{ asset('/') }}">{{ trans('common.homepage') }}</a>
                            </li>
                            <li class="breadcrumb-item " aria-current="page">
                                <a href="{{ route('view.pre_project.index') }}">
                                    {{ trans('pre_project.pre_project') }}
                                </a>
                            </li>
                            <li class="breadcrumb-item disable" aria-current="page">
                                <span>
                                    {{ trans('label.detail') }}
                                </span>
                            </li>
                        </ol>
                    </nav>
                </div>
                <div class=" text-end">
                    <a href="##" class="btn text-black bg-white border rounded-3 text-nowrap" data-bs-toggle="modal"
                        data-bs-target="#exampleModal">
                        @include('icons.copy') {{ trans('label.copy_item') }}
                    </a>
                    <a class="btn text-black bg-white border rounded-3 text-nowrap" @click="deleteItem()">
                        <i class="bi bi-trash-fill"></i> {{ trans('label.delete') }}
                    </a>
                </div>
            </div>
            <!-- End Page Header -->
            <div class="d-flex flex-column flex-xl-row">

                <div class="flex-column flex-lg-row-auto w-100 w-xl-350px mb-10">

                    @include('pages.pre_project.detail.card_detail')

                    @include('pages.pre_project.detail.card_customer')

                    @include('pages.pre_project.detail.card_contacts')

                    @include('pages.pre_project.detail.card_manager')

                    @include('pages.pre_project.detail.card_system_properites')
                </div>

                <div class="flex-lg-row-fluid ms-lg-20 gino-tab">
                    <div class="stepper">
                        <div v-for="item in status" :key="item.id"
                            :class="[{ 'completed': modelStatusOrder >= item.sort_order }, 'stepper-item']"
                            :style="[modelStatusOrder >= item.sort_order ? { backgroundColor: item.str_val2 } : {}]"
                            @click="updateStatus(item)">
                            <div class="stepper-title">
                                (( item.str_val1 ))
                            </div>
                        </div>
                    </div>
                    <ul class="nav nav-custom nav-tabs d-sm-flex d-block mb-3" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab_activity"
                                aria-current="page" href="#tab_activity">{{ trans('pre_project.tab_activity') }} ((
                                `(${list.length})` ))
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" data-bs-target="#tab_note" aria-current="page"
                                href="#tab_note">{{ trans('pre_project.tab_note') }} (( `(${count_data.note ?? 0})` ))
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" data-bs-target="#tab_email" aria-current="page"
                                href="#tab_email">{{ trans('pre_project.tab_email') }} (( `(${count_data.email ?? 0})` ))
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" data-bs-target="#tab_call" aria-current="page"
                                href="#tab_call">{{ trans('pre_project.tab_call') }} (( `(${count_data.call ?? 0})` ))
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" data-bs-target="#tab_task" aria-current="page"
                                href="#tab_task">{{ trans('pre_project.tab_task') }} (( `(${count_data.task ?? 0})` ))
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" data-bs-target="#tab_meeting" aria-current="page"
                                href="#tab_meeting">{{ trans('pre_project.tab_meeting') }} (( `(${count_data.meeting ??
                                0})` ))
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" data-bs-target="#tab_invoice" aria-current="page"
                                href="#tab_invoice">{{ trans('pre_project.tab_invoice') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" data-bs-target="#tab_estimate" aria-current="page"
                                href="#tab_estimate">{{ trans('pre_project.tab_estimate') }}</a>
                        </li>
                    </ul>

                    <div class="tab-content tab-content-custom rounded-3 mt-1 bg-transparent p-0 collapse-all-content">
                        <div class="tab-pane active" id="tab_activity" role="tab_activity">
                            @include('pages.pre_project.detail.list.list_activity')
                        </div>
                        <div class="tab-pane" id="tab_note" role="tab_note">
                            <list_note :count_data="count_data"></list_note>
                        </div>
                        <div class="tab-pane" id="tab_email" role="tab_email">
                            <list_email :count_data="count_data"></list_email>
                        </div>
                        <div class="tab-pane" id="tab_call" role="tab_call">
                            <list_call :count_data="count_data"></list_call>
                        </div>
                        <div class="tab-pane" id="tab_task" role="tab_task">
                            <list_task :count_data="count_data"></list_task>
                        </div>
                        <div class="tab-pane" id="tab_meeting" role="tab_meeting">
                            <list_meeting :count_data="count_data"></list_meeting>
                        </div>
                        <div class="tab-pane" id="tab_estimate" role="tab_estimate">
                            <list_invoice type="1"></list_invoice>
                        </div>
                        <div class="tab-pane" id="tab_invoice" role="tab_invoice">
                            <list_invoice></list_invoice>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        @include('pages.pre_project.detail.modal.add_activity')
        @include('pages.pre_project.detail.modal.update')
        @include('pages.pre_project.components.add_modal')
    </div>
    <form action="{{ asset('pre-project') }}/{{ $model->id }}" id="formDelete" method="post">
        @method('DELETE')
        @csrf
    </form>
@endsection

@section('script-footer')

    <!-- Chartjs Chart JS -->
    <!-- <script src="{{ asset('assets/js/index.js') }}"></script> -->

    <script src="{{ asset('assets/js/prism-custom.js') }}"></script>

    <script src="{{ asset('assets/js/custom-switcher.min.js') }}"></script>
    <!-- Custom JS -->
    <script src="{{ asset('assets/js/custom.js') }}"></script>
    <script src="{{ asset('assets/js/csrf.js') }}"></script>



    @include('pages.pre_project.detail.list.list_chat')
    @include('pages.pre_project.detail.list.list_call')
    @include('pages.pre_project.detail.list.list_email')
    @include('pages.pre_project.detail.list.list_note')
    @include('pages.pre_project.detail.list.list_task')
    @include('pages.pre_project.detail.list.list_meeting')
    @include('pages.pre_project.detail.list.list_invoice')

    @include('pages.pre_project.detail.item.item_note')
    @include('pages.pre_project.detail.item.item_default')
    @include('pages.pre_project.detail.item.item_email')
    @include('pages.pre_project.detail.item.item_call')
    @include('pages.pre_project.detail.item.item_task')
    @include('pages.pre_project.detail.item.item_meeting')

    <script>
        $(document).ready(function() {
            $('.collapse-all-btn').on('change', function(event) {
                if (event.target.value == 'expand_all') {
                    $('.collapse-all-content .accordion-collapse').addClass('show')
                    $('.collapse-all-content .gino-accordion-item__button').removeClass('collapsed')
                }
                if (event.target.value == 'collapse_all') {
                    $('.collapse-all-content .accordion-collapse').removeClass('show')
                    $('.collapse-all-content .gino-accordion-item__button').addClass('collapsed')
                }
                $('.collapse-all-btn').val(event.target.value)
            })
        });
    </script>

    <script type="text/javascript">
        var reloadTimeout = 500

        var options = {
            durations: {
                alert: 0,
                warning: 0,
                success: 2000,
            },
            labels: {
                alert: '',
                warning: '',
                success: '',
            },
            icons: {
                enabled: false
            }
        }
        var notifier = new AWN(options);


        var EventBus = new Vue();

        new Vue({
            el: '#App',
            data: {
                sortDirection: 'desc',
                sortBy: 'id',
                count: 0, //total page
                page: 1, //pagination: curent page
                perPage: "{{ $default_records_per_page }}", // pagination: records per page
                total: 0, //pagination: total records
                pageRange: 3, // pagination:controls nearby page display. currenpage counted
                from: 1,
                to: 10,
                list: [],
                conditionSearch: '',
                search: '',
                showClearSearch: false,
                previewUrl: "{{ $model->logo_url }}",
                modalUrl: "{{ route('view.user.store') }}",
                putMethod: false,
                updateObj: @json($model),
                selectedObject: {},
                createNoteObj: {},
                createEmailObj: {},
                createCallObj: {},
                createTaskObj: {},
                createMeetingObj: {},
                count_data: {},
                listPage: [],
                showCount: 10,
                updateValidateErrors: {},
                validateErrors: {},
                createLoading: false,
                viewType: 'list',
                loading: false,
                action: 'view',
                selected: [],
                showed: [],
                modelStatusOrder: @json($model->status_order),
                status: @json($status),
                customers: @json($customers),
                customer_staffs: @json($customer_staffs),
                selectedCustomerId: @json($model->customer_id),
                selectedCustomerStaffId: @json($model->customer_staff_id),
                filteredCustomerStaff: {},
                preProjectCommentId: "",
                staff: @json($staff),
                sale: @json($staff),
                createObj: @json($model),
            },
            delimiters: ["((", "))"],
            created() {
                EventBus.$on('reload_list_activity', (msg = null) => {
                    if (msg) console.log(msg);
                    this.list = []
                    this.onLoadPagination()
                });
            },
            mounted() {
                const that = this;
                this.filterCustomerStaff()
                this.onLoadPagination();
            },
            computed: {
                showAll: {
                    get: function() {
                        if (!this.list || this.showed.length == 0) return 0
                        if (this.showed.length == this.list.length) return 1
                        if (this.showed.length != this.list.length) return 2
                    },
                    set: function(value) {
                        this.showed = value ? this.list.map((row) => row.file_attribute_id) : [];
                    }
                },
                selectAll: {
                    get: function() {
                        if (!this.list || this.selected.length == 0) return 0
                        if (this.selected.length == this.list.length) return 1
                        if (this.selected.length != this.list.length) return 2
                    },
                    set: function(value) {
                        this.selected = value ? this.list.map((row) => row.file_attribute_id) : [];
                    }
                },
            },
            methods: {
                filterCustomerStaff() {
                    let customer = this.customers.find(customer => customer.customer_id === this
                        .selectedCustomerId)?.customer_staffs;
                    console.log(customer);
                    this.filteredCustomerStaff = customer ?? {}
                },
                sortSelect: function(s) {
                    if (s === this.sortBy) {
                        this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                    }
                    this.sortBy = s;
                    this.list.sort((p1, p2) => {
                        let modifier = 1;
                        if (this.sortDirection === 'asc') modifier = -1;
                        let indexA = this.selected.indexOf(p1.template_id);
                        let indexB = this.selected.indexOf(p2.template_id);
                        // Nếu id không có trong selected thì cho nó giá trị lớn để nó được đẩy về sau
                        if (indexA === -1) indexA = Infinity;
                        if (indexB === -1) indexB = Infinity;

                        return (indexA - indexB) * modifier;
                    });
                },
                sortTime: function(s) {
                    if (s === this.sortBy) {
                        this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                    }
                    this.sortBy = s;
                    this.list = this.list.sort((p1, p2) => {
                        let modifier = this.sortDirection === 'asc' ? 1 : -1;

                        const time1 = p1[this.sortBy].split(':').map(num => parseInt(num));
                        const time2 = p2[this.sortBy].split(':').map(num => parseInt(num));

                        if (time1[0] < time2[0]) return -1 * modifier;
                        if (time1[0] > time2[0]) return 1 * modifier;
                        if (time1[1] < time2[1]) return -1 * modifier;
                        if (time1[1] > time2[1]) return 1 * modifier;
                        return 0;
                    });
                },
                sort: function(s) {
                    if (s === this.sortBy) {
                        this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                    }
                    this.sortBy = s;
                    this.list = this.list.sort((p1, p2) => {
                        let modifier = 1;
                        if (this.sortDirection === 'desc') modifier = -1;

                        if (p1[this.sortBy] == undefined && p2[this.sortBy] != undefined) return -1 *
                            modifier;
                        if (p1[this.sortBy] != undefined && p2[this.sortBy] == undefined) return 1 *
                            modifier;
                        if (p1[this.sortBy] == undefined && p2[this.sortBy] == undefined) return 0;

                        if (p1[this.sortBy].length == 0 && p2[this.sortBy].length > 0) return -1 *
                            modifier;
                        if (p1[this.sortBy].length > 0 && p2[this.sortBy].length == 0) return 1 *
                            modifier;
                        if (p1[this.sortBy].length == 0 && p2[this.sortBy].length == 0) return 0;

                        if (!Number.isNaN(parseInt(p1[this.sortBy])) && !Number.isNaN(parseInt(p2[this
                                .sortBy]))) {
                            if (p1[this.sortBy].indexOf && p2[this.sortBy].indexOf && p1[this.sortBy]
                                .indexOf("-") == -1 && p2[this.sortBy].indexOf("-") == -1) {
                                return (p1[this.sortBy] - p2[this.sortBy]) * modifier;
                            }
                        }

                        if (p1[this.sortBy] < p2[this.sortBy]) return -1 * modifier;
                        if (p1[this.sortBy] > p2[this.sortBy]) return 1 * modifier;
                        return 0;
                    });
                },
                handleSearch() {
                    this.loading = true
                    this.list = []
                    if (this.search !== '') this.showClearSearch = true
                    else this.showClearSearch = false;

                    if (this.searchTimeout) clearTimeout(this.searchTimeout)
                    this.searchTimeout = setTimeout(() => {
                        this.searchFunction();
                    }, 400);
                },
                searchFunction() {
                    this.page = 1
                    this.onLoadPagination();
                },
                clearInput() {
                    this.search = ''
                    this.list = []
                    this.showClearSearch = false
                    this.onLoadPagination();
                },
                resetSearch() {
                    Object.assign(this.filterObj, {
                        status: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
                    })
                    this.onLoadPagination();
                },
                previewImage(event) {
                    const file = event.target.files[0];
                    if (file) {
                        this.previewUrl = URL.createObjectURL(file)
                    }
                },
                onPerPageChange(perPage) {
                    this.page = 1;
                    this.perPage = perPage;
                    this.onLoadPagination();
                },
                onPageChange(_p) {
                    this.page = _p;
                    this.onLoadPagination();
                },
                onPrePage() {
                    if (this.page > 1) {
                        this.page = this.page - 1;
                    }
                    this.onLoadPagination();
                },
                onNextPage() {
                    if (this.page < this.count) {
                        this.page = this.page + 1;
                    }
                    this.onLoadPagination();
                },
                async onLoadPagination() {
                    const that = this;
                    this.loading = true
                    let conditionSearch = '?page=' + this.page;
                    conditionSearch += '&perPage=' + this.perPage;
                    conditionSearch += '&showcount=' + this.showCount;
                    conditionSearch += '&pre_project_id={{ $model->id }}';
                    conditionSearch += '&s=' + this.search;
                    this.conditionSearch = conditionSearch;

                    await jQuery.ajax({
                        type: 'GET',
                        url: "{{ route('api.pre_projects.list_comment', $model->id) }}" +
                            conditionSearch,
                        success: function(data) {
                            that.loading = false

                            that.list = data.result.data;
                            that.count = data.result.last_page;
                            that.from = data.result.from;
                            that.to = data.result.to;
                            that.total = data.result.total;
                            let pageArr = [];
                            if (that.page - 2 > 0) {
                                pageArr.push(that.page - 2);
                            }
                            if (that.page - 1 > 0) {
                                pageArr.push(that.page - 1);
                            }
                            pageArr.push(that.page);
                            if (that.page + 1 <= that.count) {
                                pageArr.push(that.page + 1);
                            }
                            if (that.page + 2 <= that.count) {
                                pageArr.push(that.page + 2);
                            }
                            that.listPage = pageArr;

                        },
                        error: function(xhr, textStatus, error) {
                            that.loading = false
                            notifier.warning('Lỗi Hệ Thống!');
                        }
                    });
                },
                async createFormSubmit() {
                    if (this.createLoading) return;
                    let that = this;
                    this.createLoading = true
                    const form = $('#createForm');
                    const formData = new FormData(form[0]);
                    await jQuery.ajax({
                        type: 'POST',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,
                        url: "{{ route('view.pre_project.store') }}",
                        success: function(data) {
                            that.createLoading = false
                            let url = "{{ asset('') }}pre-project/" + data.result.id +
                                '/detail/'
                            notifier.success("{{ trans('label.success') }}")
                            window.location.href = url
                            $('.modal').modal('hide');
                            that.validateErrors = {}
                        },
                        error: function(data) {
                            that.createLoading = false
                            that.validateErrors = data.responseJSON.errors
                            customizeNotification(notifier.alert("{{ trans('label.failed') }}"));

                        }
                    });
                },
                addPreProjectComment() {
                    let that = this;
                    this.createLoading = true
                    const form = $('#addPreProjectCommentForm');
                    const formData = new FormData(form[0]);
                    jQuery.ajax({
                        type: 'POST',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,
                        url: "{{ route('view.pre_project_comment.store') }}",
                        success: function(data) {
                            $('.modal').modal('hide')
                            that.createLoading = false
                            resetForm(form[0])
                            that.onLoadPagination()
                            EventBus.$emit('reload_list_note')
                            notifier.success('label.success')
                        },
                        error: function(data) {
                            that.createLoading = false
                            that.validateErrors = data.responseJSON.errors
                            notifier.alert(data.responseJSON.message);
                        }
                    });
                },
                addPreProjectEmail() {
                    let that = this;
                    this.createLoading = true
                    const form = $('#addPreProjectEmailForm');
                    const formData = new FormData(form[0]);
                    jQuery.ajax({
                        type: 'POST',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,
                        url: "{{ route('view.pre_project_comment.store') }}",
                        success: function(data) {
                            $('.modal').modal('hide');
                            that.createLoading = false
                            notifier.success('label.success');
                            that.onLoadPagination();
                            resetForm(form[0])
                            EventBus.$emit('reload_list_email')
                        },
                        error: function(data) {
                            that.createLoading = false
                            that.validateErrors = data.responseJSON.errors
                            notifier.alert(data.responseJSON.message);
                        }
                    });
                },
                addPreProjectCall() {
                    let that = this;
                    this.createLoading = true
                    const form = $('#addPreProjectCallForm');
                    const formData = new FormData(form[0]);
                    jQuery.ajax({
                        type: 'POST',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,
                        url: "{{ route('view.pre_project_comment.store') }}",
                        success: function(data) {
                            $('.modal').modal('hide');

                            that.createLoading = false
                            notifier.success('label.success');
                            that.onLoadPagination();
                            resetForm(form[0])
                            EventBus.$emit('reload_list_call')
                        },
                        error: function(data) {
                            that.createLoading = false
                            that.validateErrors = data.responseJSON.errors
                            notifier.alert(data.responseJSON.message);
                        }
                    });
                },
                addPreProjectTask() {
                    let that = this;
                    this.createLoading = true
                    const form = $('#addPreProjectTaskForm');
                    const formData = new FormData(form[0]);
                    jQuery.ajax({
                        type: 'POST',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,
                        url: "{{ route('view.pre_project_comment.store') }}",
                        success: function(data) {
                            $('.modal').modal('hide');
                            that.createLoading = false
                            notifier.success('label.success');
                            EventBus.$emit('reload_list_task')
                            that.onLoadPagination();
                            resetForm(form[0])
                        },
                        error: function(data) {
                            that.createLoading = false
                            that.validateErrors = data.responseJSON.errors
                            notifier.alert(data.responseJSON.message);
                        }
                    });
                },
                addPreProjectMeeting() {

                    let that = this;
                    this.createLoading = true
                    const form = $('#addPreProjectMeetingForm');
                    const formData = new FormData(form[0]);
                    jQuery.ajax({
                        type: 'POST',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,
                        url: "{{ route('view.pre_project_comment.store') }}",
                        success: function(data) {
                            $('.modal').modal('hide');
                            that.createLoading = false
                            notifier.success('label.success');
                            that.onLoadPagination();
                            EventBus.$emit('reload_list_meeting')
                            resetForm(form[0])
                        },
                        error: function(data) {
                            that.createLoading = false
                            that.validateErrors = data.responseJSON.errors
                            notifier.alert(data.responseJSON.message);
                        }
                    });
                },
                addContactFormSubmit() {
                    let that = this;
                    this.createLoading = true
                    const form = $('#addContactForm');
                    const formData = new FormData(form[0]);
                    jQuery.ajax({
                        type: 'POST',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,
                        url: "{{ route('view.pre_project.add_contact', $model->id) }}",
                        success: function(data) {
                            notifier.success('label.success');
                            that.createLoading = false
                            setTimeout(() => {
                                location.reload();
                            }, reloadTimeout);
                            $('.modal').modal('hide');
                        },
                        error: function(data) {
                            that.createLoading = false
                            that.validateErrors = data.responseJSON.errors
                            notifier.alert(data.responseJSON.message);
                        }
                    });
                },
                updateFormSubmit() {
                    let that = this;
                    this.createLoading = true
                    const form = $('#updateForm');
                    const formData = new FormData(form[0]);
                    formData.append('_method', 'PUT');
                    jQuery.ajax({
                        type: 'POST',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,
                        url: "{{ route('view.pre_project.update', $model->id) }}",
                        success: function(data) {
                            notifier.success(data.message);
                            that.createLoading = false
                            setTimeout(() => {
                                location.reload();
                            }, reloadTimeout);
                            $('.modal').modal('hide');
                        },
                        error: function(data) {
                            that.createLoading = false
                            that.validateErrors = data.responseJSON.errors
                            notifier.alert(data.responseJSON.message);
                        }
                    });
                },
                updateManagerFormSubmit() {
                    let that = this;
                    this.createLoading = true
                    const form = $('#updateManagerForm');
                    const formData = new FormData(form[0]);
                    formData.append('_method', 'PUT');
                    jQuery.ajax({
                        type: 'POST',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,
                        url: "{{ route('view.pre_project.update_manager', $model->id) }}",
                        success: function(data) {
                            notifier.success(data.message);
                            that.createLoading = false
                            setTimeout(() => {
                                location.reload();
                            }, reloadTimeout);
                            $('.modal').modal('hide');
                        },
                        error: function(data) {
                            that.createLoading = false
                            that.validateErrors = data.responseJSON.errors
                            notifier.alert(data.responseJSON.message);
                        }
                    });
                },
                updateCustomerFormSubmit() {
                    let that = this;
                    this.createLoading = true
                    const form = $('#updateCustomerForm');
                    const formData = new FormData(form[0]);
                    formData.append('_method', 'PUT');
                    jQuery.ajax({
                        type: 'POST',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,
                        url: "{{ route('view.pre_project.update_customer', $model->id) }}",
                        success: function(data) {
                            notifier.success(data.message);
                            that.createLoading = false
                            setTimeout(() => {
                                location.reload();
                            }, reloadTimeout);
                            $('.modal').modal('hide');
                        },
                        error: function(data) {
                            that.createLoading = false
                            that.validateErrors = data.responseJSON.errors
                            notifier.alert(data.responseJSON.message);
                        }
                    });
                },
                async updateStatus(status) {
                    let that = this
                    if (that.updateObj.status == status.key3) return;
                    const result = await Swal.fire({
                        title: `ステータス<span class="text-bondi-blue">${that.updateObj.status_name}</span>が<span class="text-bondi-blue">${status.str_val1}</span>に変更されますが、よろしいでしょうか。`,
                        icon: 'info',
                        showCancelButton: true,
                        confirmButtonColor: '#dc3545',
                        cancelButtonColor: '#ffffff',
                        confirmButtonText: "{{ trans('label.save') }}",
                        cancelButtonText: "{{ trans('label.cancel') }}"
                    });
                    if (result.isConfirmed) {
                        that.modelStatusOrder = status.sort_order
                        jQuery.ajax({
                            type: 'PUT',
                            data: {
                                'status': status.key3
                            },
                            url: "{{ route('view.pre_project.update_status', $model->id) }}",
                            success: function(data) {
                                that.updateObj.status = status.key3
                                that.updateObj.status_name = status.str_val1
                                that.updateObj.status_color = status.str_val2
                                notifier.success(data.message);
                                EventBus.$emit('reload_list_activity')
                            },
                            error: function(data) {
                                notifier.alert(data.responseJSON.message);
                            }
                        });
                    }
                },
                deleteItem() {
                    Swal.fire({
                        title: '{{ trans('label.are_you_sure') }}',
                        text: '{{ trans('label.cant_revert') }}',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#dc3545',
                        cancelButtonColor: '#ffffff',
                        confirmButtonText: '{{ trans('label.yes_delete_it') }}',
                        cancelButtonText: '{{ trans('label.cancel') }}'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $('#formDelete').submit();
                        }
                    })
                },
            },
        });
    </script>



    @if ($model->init_password === 0)
        <script>
            notifier.warning(`{{ trans('label.please_change_password') }}`);
        </script>
    @endif

    @if ($errors->any())
        <script>
            let alertMessage = `
    @foreach ($errors->all() as $error)
    <br>
        {{ $error }}
    @endforeach
    `
            notifier.alert(alertMessage);
        </script>
    @endif

    @if (session('error'))
        <script>
            notifier.alert(`{{ session('error') }}`);
        </script>
    @endif

    @if (session('success'))
        <script>
            notifier.success(`{{ session('success') }}`);
        </script>
    @endif

@endsection
