<div class="card mb-4 shadow-nManager rounded-3">
    <div class="card-body pt-15">
        <div class="ps-0">
            <div class="accordion-item gino-accordion-item">
                <div class="accordion-header d-flex" id="headingManager">
                    <button class=" gino-accordion-item__button  text-black fw-bold" type="button"
                        data-bs-toggle="collapse" data-bs-target="#collapseManager" aria-expanded="false"
                        aria-controls="collapseManager">
                        {{ trans('pre_project.manager_card_title') }}
                    </button>
                    <a data-bs-toggle="modal" data-bs-target="#updateManagerModal"
                        class="btn btn-primary-light btn--edit">
                        {{ trans('label.edit') }}
                    </a>
                </div>
                <div id="collapseManager" class="accordion-collapse collapse show" aria-labelledby="headingManager"
                    data-bs-parent="#accordiManagerxample">
                    <div class="separator separator-dashed my-2"></div>
                    <div class="accordion-body">
                        {{-- customer_type_name  --}}
                        {{-- staff_id --}}
                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.staff_id') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            {{ @$model->staff->name }}
                            &nbsp;
                        </div>

                        {{-- sale_id --}}
                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.sale_id') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            {{ @$model->saler->name }}
                            &nbsp;
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade gino-modal" id="updateManagerModal" tabindex="-1" role="dialog"
    aria-labelledby="updateManagerModalLabel" aria-hidden="true">
    <div class="modal-dialog " role="document">
        <div class="modal-content custom-modal-content">
            <div class="modal-header border-0  bg-light p-3">
                <h6 class="modal-title" id="updateManagerModalLabel">
                    {{ trans('pre_project.manager_card_title') }}{{ trans('pre_project.update') }}</h6>
                <button type="button" class="btn-close btn-close-black " data-bs-dismiss="modal" aria-label="Close">
                </button>
            </div>
            <form @submit.prevent="updateManagerFormSubmit" ref="updateManagerForm" id="updateManagerForm"
                method="post" enctype="multipart/form-data">
                <div class="modal-body p-20">
                    <div class="row">
                        <div class="col-12 mb-3">
                            <label for="staff_id" class="form-label">{{ trans('pre_project.staff_id') }}</label>
                            <select
                                :class="['validate-select2', { 'validate-error--select2': validateErrors.staff_id },
                                    'form-control'
                                ]"
                                name="staff_id" id="update_staff_id" data-dropdown-parent="#updateManagerModal"
                                data-allow-clear="true" v-select2>
                                <option value=""></option>
                                @foreach ($staff as $item)
                                    <option value="{{ $item->company_staff_id }}"
                                        {{ $model->staff_id == $item->company_staff_id ? 'selected' : '' }}>
                                        {{ $item->company_staff_id . ' ' . $item->name }}
                                    </option>
                                @endforeach
                            </select>
                            <div class="validate-error--text text-danger" v-if="validateErrors.staff_id"
                                v-for="err in validateErrors.staff_id">
                                <small>
                                    (( err ))
                                </small>
                            </div>
                        </div>

                        <div class="col-12 mb-3">
                            <label for="sale_id" class="form-label">{{ trans('pre_project.sale_id') }}</label>
                            <select
                                :class="['validate-select2', { 'validate-error--select2': validateErrors.sale_id },
                                    'form-control'
                                ]"
                                name="sale_id" id="update_sale_id" data-dropdown-parent="#updateManagerModal"
                                data-allow-clear="true" v-select2>
                                <option value=""></option>
                                @foreach ($staff as $item)
                                    <option value="{{ $item->company_staff_id }}"
                                        {{ $model->sale_id == $item->company_staff_id ? 'selected' : '' }}>
                                        {{ $item->company_staff_id . ' ' . $item->name }}
                                    </option>
                                @endforeach
                            </select>
                            <div class="validate-error--text text-danger" v-if="validateErrors.sale_id"
                                v-for="err in validateErrors.sale_id">
                                <small>
                                    (( err ))
                                </small>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="modal-footer border-0 p-3 pt-0 gap-2 justify-content-end">
                    <div v-if="createLoading">
                        <div class="spinner-border">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </div>
                    <div class="btn btn-light" data-bs-dismiss="modal" aria-hidden="true">
                        {{ trans('label.cancel') }}
                    </div>
                    <button type="submit" class="btn btn-primary ">
                        {{ trans('label.save') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
