<div class="card mb-4 shadow-none rounded-3">
    <div class="card-body pt-15">
        <div class="ps-0">
            <div class="col-12 mb-3">
                <div class="logo-upload-control d-flex gap-2 text-break">
                    <img alt="avatar rounded-circle" width="72" height="72" src="{{ @$model->customer->logo_url }}">
                    <div>
                        <div class="text-left mb-1 fs-18 text-capitalize text-gray-7">
                            <span>{{ @$model->customer->name }}</span>
                        </div>
                        <div class="fs-14 text-gray-7 ">
                            {{ trans('pre_project.status') }}:
                            <a href="##" class="text-nowrap link text-decoration-none" data-bs-toggle="dropdown"
                                aria-haspopup="true" aria-expanded="true">
                                <span class="rounded-1 fs-14 p-1  d-inline-flex align-items-center"
                                    :style="{
                                        color: updateObj.status_color ?? '#85d6ff',
                                        backgroundColor: updateObj.status_color ? updateObj
                                            .status_color + '22' : '#85d6ff22'
                                    }">((updateObj.status_name))<i
                                        class="fa-solid fa-angle-down ms-1"></i></span>
                            </a>
                            <div class="dropdown-menu rounded-7" data-popper-placement="bottom-start">
                                <a class="dropdown-item" v-for="i in status" @click="updateStatus(i)">
                                    ((i.str_val1))
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <ul class="create-activity-btn-list mb-4">
                <li class="btn-list-item">
                    <div class="btn-list-item-icon-wrapper" data-bs-toggle="modal"
                        data-bs-target="#addPreProjectCommentModal">
                        <div class="btn-list-item-icon"><i class="fa-regular fa-pen-to-square"></i>
                        </div>
                    </div>
                    <span class="btn-list-item-text">
                        {{ trans('pre_project.tab_note') }}
                    </span>
                </li>
                <li class="btn-list-item">
                    <div class="btn-list-item-icon-wrapper" data-bs-toggle="modal"
                        data-bs-target="#addPreProjectEmailModal">
                        <div class="btn-list-item-icon">
                            <i class="fa-regular fa-envelope"></i>
                        </div>
                    </div>
                    <span class="btn-list-item-text">
                        {{ trans('pre_project.tab_email') }}
                    </span>
                </li>
                <li class="btn-list-item">
                    <div class="btn-list-item-icon-wrapper" data-bs-toggle="modal"
                        data-bs-target="#addPreProjectCallModal">
                        <div class="btn-list-item-icon">
                            <i class="fa-solid fa-mobile-screen-button"></i>
                        </div>
                    </div>
                    <span class="btn-list-item-text">
                        {{ trans('pre_project.tab_call') }}
                    </span>
                </li>
                <li class="btn-list-item">
                    <div class="btn-list-item-icon-wrapper" data-bs-toggle="modal"
                        data-bs-target="#addPreProjectTaskModal">
                        <div class="btn-list-item-icon">
                            <i class="fa-solid fa-list-check"></i>
                        </div>
                    </div>
                    <span class="btn-list-item-text">
                        {{ trans('pre_project.tab_task') }}
                    </span>
                </li>
                <li class="btn-list-item">
                    <div class="btn-list-item-icon-wrapper" data-bs-toggle="modal"
                        data-bs-target="#addPreProjectMeetingModal">
                        <div class="btn-list-item-icon">
                            <i class="fa-regular fa-calendar"></i>
                        </div>
                    </div>
                    <span class="btn-list-item-text">
                        {{ trans('pre_project.tab_meeting') }}
                    </span>
                </li>
            </ul>
            <div class="accordion-item gino-accordion-item">
                <div class="accordion-header d-flex" id="headingOne">
                    <button class=" gino-accordion-item__button  text-black fw-bold" type="button"
                        data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="false"
                        aria-controls="collapseOne">
                        {{ trans('label.detail') }}
                    </button>
                    <a data-bs-toggle="modal" data-bs-target="#updateModal" class="btn btn-primary-light btn--edit">
                        {{ trans('label.edit') }}
                    </a>
                </div>
                <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                    data-bs-parent="#accordionExample">
                    <div class="separator separator-dashed my-2"></div>
                    <div class="accordion-body">

                        {{-- id  --}}
                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.id') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            {{ @$model->id }}
                            &nbsp;
                        </div>



                        {{-- type_name  --}}
                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.type_name') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            {{ @$model->type_name }}
                            &nbsp;
                        </div>

                        {{-- customer_staff  --}}
                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.customer_staff') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            {{ @$model->contacts[0]->name }}
                            &nbsp;
                        </div>
                        {{-- customer_type_name  --}}
                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.customer_type_name') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            {{ @$model->customer_type_name }}
                            &nbsp;
                        </div>

                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.name') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            {!! @$model->name !!}
                            &nbsp;
                        </div>

                        {{-- priority --}}
                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.priority') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            @if ($model->priority)
                                <span class="priority-status-indicator">
                                    <span class="dot" style="background-color: {{ $model->priority_color }}"></span>
                                    {{ @$model->priority_name }}
                                </span>
                            @else
                                &nbsp;
                            @endif
                        </div>

                        {{-- success_percent --}}
                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.success_percent') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            {{ $model->success_percent ? "$model->success_percent%" : '' }}
                            &nbsp;
                        </div>

                        {{-- plan_close_on --}}
                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.plan_close_on') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            {{ $model->plan_close_on }}
                            &nbsp;
                        </div>
                        {{-- plan_money --}}
                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.plan_money') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            {{ $model->plan_money_formatted }}
                            &nbsp;
                        </div>

                        {{-- closed_on --}}
                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.closed_on') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            {{ @$model->closed_on }}
                            &nbsp;
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
