<div class="card mb-4 shadow-nCustomer rounded-3">
    <div class="card-body pt-15">
        <div class="ps-0">
            <div class="accordion-item gino-accordion-item">
                <div class="accordion-header d-flex" id="headingCustomer">
                    <button class=" gino-accordion-item__button  text-black fw-bold" type="button"
                        data-bs-toggle="collapse" data-bs-target="#collapseCustomer" aria-expanded="false"
                        aria-controls="collapseCustomer">
                        {{ trans('pre_project.customer_card_title') }}
                    </button>
                    <a data-bs-toggle="modal" data-bs-target="#updateCustomerModal"
                        class="btn btn-primary-light btn--edit">
                        {{ trans('label.edit') }}
                    </a>
                </div>
                <div id="collapseCustomer" class="accordion-collapse collapse show" aria-labelledby="headingCustomer"
                    data-bs-parent="#accordiCustomerxample">
                    <div class="separator separator-dashed my-2"></div>
                    <div class="accordion-body">

                        {{-- customer_name  --}}
                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.customer_name') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            @if ($model->customer_id)
                                <a href="{{ route('view.customer.detail', $model->customer_id) }}" class="link"
                                    style="text-underline-offset: 4px;"
                                    target="_blank">{{ @$model->customer->name }}</a>
                            @endif
                            &nbsp;
                        </div>

                        {{-- customer_address  --}}
                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.customer_address') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            {{ @$model->customer->address }}
                            &nbsp;
                        </div>

                        {{-- customer_phone  --}}
                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.customer_phone') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            <span>{{ trans('label.tel') }} {{ @$model->customer->formated_phone }}</span>
                            <span onclick="copyContent('{{ @$model->customer->formated_phone }}')"
                                class="text-bondi-blue copy-btn"></span>
                            &nbsp;
                        </div>

                        {{-- customer_url  --}}
                        <div class="fs-14 mt-3 text-black fw-bold">
                            {{ trans('pre_project.customer_url') }}:
                        </div>
                        <div class="fs-14 text-gray-6 ">
                            <span>{{ @$model->customer->url }}</span>
                            <span onclick="copyContent('{{ @$model->customer->url }}')"
                                class="text-bondi-blue copy-btn"></span>
                            &nbsp;
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade gino-modal" id="updateCustomerModal" tabindex="-1" role="dialog"
    aria-labelledby="updateCustomerModalLabel" aria-hidden="true">
    <div class="modal-dialog " role="document">
        <div class="modal-content custom-modal-content">
            <div class="modal-header border-0  bg-light p-3">
                <h6 class="modal-title" id="updateCustomerModalLabel">
                    {{ trans('pre_project.customer_card_title') }}{{ trans('pre_project.update') }}</h6>
                <button type="button" class="btn-close btn-close-black " data-bs-dismiss="modal" aria-label="Close">
                </button>
            </div>
            <form @submit.prevent="updateCustomerFormSubmit" ref="updateCustomerForm" id="updateCustomerForm"
                method="post" enctype="multipart/form-data">
                <div class="modal-body p-20">
                    <div class="row">
                        <div class="col-12 mb-3">
                            <label for="customer_id" class="form-label">{{ trans('pre_project.customer_id') }}</label>
                            <select
                                :class="['validate-select2', { 'validate-error--select2': validateErrors.customer_id },
                                    'form-control'
                                ]"
                                name="customer_id" v-model="selectedCustomerId"
                                data-dropdown-parent="#updateCustomerModal" data-allow-clear="true"
                                {{-- @change="filterCustomerStaff($event.target.value)" --}} v-select2>
                                <option value=""></option>
                                <option v-for="item in customers" :value="item.customer_id">
                                    (( item.customer_id +" "+ item.name))
                                </option>
                            </select>
                            <div class="validate-error--text text-danger" v-if="validateErrors.customer_id"
                                v-for="err in validateErrors.customer_id">
                                <small>
                                    (( err ))
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-0 p-3 pt-0 gap-2 justify-content-end">
                    <div v-if="createLoading">
                        <div class="spinner-border">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </div>
                    <div class="btn btn-light" data-bs-dismiss="modal" aria-hidden="true">
                        {{ trans('label.cancel') }}
                    </div>
                    <button type="submit" class="btn btn-primary ">
                        {{ trans('label.save') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
