<div class="card mb-4 shadow-none rounded-3">
    <div class="card-body pt-15">
        <div class="ps-0">

            <div class="accordion-item gino-accordion-item">
                <div class="accordion-header d-flex" id="headingContact">
                    <button class=" gino-accordion-item__button  text-black fw-bold" type="button"
                        data-bs-toggle="collapse" data-bs-target="#collapseContact" aria-expanded="false"
                        aria-controls="collapseContact">
                        {{ trans('pre_project.contact') }}
                    </button>
                    <a data-bs-toggle="modal" data-bs-target="#addContactModal" class="btn btn-primary-light btn--edit">
                        {{ trans('pre_project.new') }}
                    </a>
                </div>
                <div id="collapseContact" class="accordion-collapse collapse show" aria-labelledby="headingContact"
                    data-bs-parent="#accordionExample">
                    <div class="separator separator-dashed my-2"></div>
                    <div class="accordion-body">

                        @foreach ($contacts as $contact)
                            <div class="logo-upload-control d-flex gap-2 text-break mt-4">
                                <img alt="avatar rounded-circle" width="32" height="32"
                                    src="{{ @$contact->avatar_url }}">
                                <div>
                                    <div class="fs-14 text-gray-6 ">
                                        <span>{{ $contact->name }}</span>
                                    </div>
                                    <div class="fs-14 text-gray-6 ">
                                        <span>{{ $contact->email }}</span>
                                    </div>

                                    @if ($contact->phone)
                                        <div class="fs-14 text-gray-6 ">
                                            <i class="fa-solid fa-square-phone"></i>
                                            <span>{{ $contact->phone }}</span>
                                        </div>
                                    @endif

                                    @if ($contact->tel)
                                        <div class="fs-14 text-gray-6 ">
                                            <i class="fa-solid fa-mobile-screen-button"></i>
                                            <span>{{ $contact->tel }}</span>
                                        </div>
                                    @endif

                                </div>
                            </div>
                        @endforeach


                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade gino-modal" id="addContactModal" tabindex="-1" role="dialog" aria-labelledby="addContactModalLabel"
    aria-hidden="true">
    <div class="modal-dialog " role="document">
        <div class="modal-content custom-modal-content">
            <div class="modal-header border-0  bg-light p-3">
                <h6 class="modal-title" id="addContactModalLabel">
                    {{ trans('pre_project.contact') }}{{ trans('pre_project.new') }}</h6>
                <button type="button" class="btn-close btn-close-black " data-bs-dismiss="modal" aria-label="Close">
                </button>
            </div>
            <form @submit.prevent="addContactFormSubmit" ref="addContactForm" id="addContactForm" method="post"
                enctype="multipart/form-data">
                @csrf
                <div class="modal-body p-20">
                    <div class="row">
                        <div class="col-12 mb-3">
                            <label for="customer_staff_id"
                                class="form-label">{{ trans('pre_project.customer_staff_id') }}</label>
                            <select
                                :class="['validate-select2', { 'validate-error--select2': validateErrors.customer_staff_id },
                                    'form-control'
                                ]"
                                name="customer_staff_id" data-dropdown-parent="#addContactModal" data-allow-clear="true"
                                v-select2>
                                <option value=""></option>
                                <option v-for="item in customer_staffs" :value="item.customer_staff_id">
                                    (( item.customer_staff_id +" "+ item.name))
                                </option>
                            </select>
                            <div class="validate-error--text text-danger" v-if="validateErrors.customer_staff_id"
                                v-for="err in validateErrors.customer_staff_id">
                                <small>
                                    (( err ))
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-0 p-3 pt-0 gap-2 justify-content-end">
                    <div v-if="createLoading">
                        <div class="spinner-border">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </div>
                    <div class="btn btn-light" data-bs-dismiss="modal" aria-hidden="true">
                        {{ trans('label.cancel') }}
                    </div>
                    <button type="submit" class="btn btn-primary ">
                        {{ trans('label.save') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

