<form @submit.prevent="searchFunction" class="form-filter flex-wrap p-3">
    @csrf
    <div class="row p-0 flex-row" @click.stop>
        <div class="col-12 col-lg-4 flex-wrap d-flex  flex-column">
            <div class="form-group mb-3">
                <label class="mb-2">{{ trans('pre_project.id') }}</label>
                <input type="text" class="form-control" v-model="filterObj.id">
            </div>
            <div class="form-group mb-3">
                <label class="mb-2">{{ trans('pre_project.customer_name') }}</label>
                <input type="text" class="form-control" v-model="filterObj.customer_name">
            </div>
            <div class="form-group mb-3">
                <label class="mb-2">{{ trans('pre_project.customer_staff_name') }}</label>
                <input type="text" class="form-control" v-model="filterObj.customer_staff_name">
            </div>

            <div class="form-group mb-3">
                <label class="mb-2">{{ trans('pre_project.staff_name') }}</label>
                <input type="text" class="form-control" v-model="filterObj.staff_name">
            </div>
            <div class="form-group mb-3">
                <label class="mb-2">{{ trans('pre_project.saler_name') }}</label>
                <input type="text" class="form-control" v-model="filterObj.saler_name">
            </div>
        </div>
        <div class="col-12 col-lg-4  flex-wrap d-flex flex-column">

            <div class="form-group mb-3">
                <label class="mb-2">{{ trans('pre_project.created_at') }}</label>
                <div class=" gap-2">
                    <input type="date" class="form-control" v-model="filterObj.created_from">
                    <div class="align-self-center text-center"> ~ </div>
                    <input type="date" class="form-control" v-model="filterObj.created_to">
                </div>
            </div>
            <div class="form-group mb-3">
                <label class="mb-2">{{ trans('pre_project.updated_at') }}</label>
                <div class=" gap-2">
                    <input type="date" class="form-control" v-model="filterObj.updated_from">
                    <div class="align-self-center text-center"> ~ </div>
                    <input type="date" class="form-control" v-model="filterObj.updated_to">
                </div>
            </div>
            <div class="form-group mb-3">
                <label class="mb-2">{{ trans('pre_project.closed_on') }}</label>
                <div class=" gap-2">
                    <input type="date" class="form-control" v-model="filterObj.closed_from">
                    <div class="align-self-center text-center"> ~ </div>
                    <input type="date" class="form-control" v-model="filterObj.closed_to">
                </div>
            </div>


        </div>
        <div class="col-12 col-lg-4  flex-wrap d-flex flex-column">
            <div class="form-group ">
                <label class="mb-2">{{ trans('pre_project.customer_type') }}</label>
                @foreach ($customer_type as $key => $item)
                    <div style="margin-bottom:6px">
                        <input class="form-check-input gino-checkbox" type="checkbox" v-model="filterObj.customer_type"
                            id="customer_type_{{ $key }}" value="{{ $item->key3 }}">
                        <label class="form-check-label" for="customer_type_{{ $key }}">
                            {{ $item->str_val1 }}
                        </label>
                    </div>
                @endforeach
            </div>
            <div class="form-group ">
                <label class="mb-2">{{ trans('pre_project.type') }}</label>
                @foreach ($type as $key => $item)
                    <div style="margin-bottom:6px">
                        <input class="form-check-input gino-checkbox" type="checkbox" v-model="filterObj.type"
                            id="type_{{ $key }}" value="{{ $item->key3 }}">
                        <label class="form-check-label" for="type_{{ $key }}">
                            {{ $item->str_val1 }}
                        </label>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <div class="form-row text-end ">
        <div class="btn btn-light text-nowrap" @click="resetSearch">{{ trans('label.reset') }}</div>
        <button class="btn btn-primary text-nowrap" type="submit">{{ trans('label.search') }}</button>
    </div>
</form>
