<div class="position-relative table-wrapper " id="listView" role="listView">
    <div class="table-responsive gino-custom-table pb-0 rounded-3 border">
        <table class="table mb-0 text-nowrap bg-white ">
            <thead>
                <tr>
                    <th @click="sortSelect('select')" role='button' style="width: 1px" class=" col_checkbox px-4">
                        <input type="checkbox"
                            :class="[{ 'gino-checkbox--checked2': selectAll == 2 },
                                'gino-checkbox form-check-input'
                            ]"
                            v-model="selectAll" :checked="selectAll" @click.stop>
                        <i v-if="sortBy == 'select'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th> 

                    <th @click="sort('id')" role='button' v-if="showColumn('id')">
                        {{ trans('pre_project.id') }}
                        <i v-if="sortBy == 'id'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>
                    <th @click="sort('name')" v-if="showColumn('name')" role='button'>
                        {{ trans('pre_project.name') }}
                        <i v-if="sortBy == 'name'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>

                    <th @click="sort('type')" v-if="showColumn('type')" role='button'>
                        {{ trans('pre_project.type') }}
                        <i v-if="sortBy == 'type'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>


                    <th @click="sort('customer_id')" v-if="showColumn('customer_id')" role='button'>
                        {{ trans('pre_project.customer') }}
                        <i v-if="sortBy == 'customer_id'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>

                    <th @click="sort('customer_staff_name')" v-if="showColumn('contacts')" role='button'>
                        {{ trans('pre_project.customer_staff_name') }}
                        <i v-if="sortBy == '0'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>

                    <th @click="sort('customer_type_name')" v-if="showColumn('customer_type')" role='button'>
                        {{ trans('pre_project.customer_type_name') }}
                        <i v-if="sortBy == 'customer_type_name'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>

                    <th @click="sort('priority')" v-if="showColumn('priority')" role='button'>
                        {{ trans('pre_project.priority') }}
                        <i v-if="sortBy == 'priority'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>

                    <th @click="sort('plan_money')" v-if="showColumn('plan_money')" role='button'>
                        {{ trans('pre_project.plan_money') }}
                        <i v-if="sortBy == 'plan_money'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>
                    <th @click="sort('success_percent')" v-if="showColumn('success_percent')" role='button'>
                        {{ trans('pre_project.success_percent') }}
                        <i v-if="sortBy == 'success_percent'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>
                    <th @click="sort('plan_close_on')" v-if="showColumn('plan_close_on')" role='button'>
                        {{ trans('pre_project.plan_close_on') }}
                        <i v-if="sortBy == 'plan_close_on'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>
                    <th @click="sort('status')" v-if="showColumn('status')" role='button'>
                        {{ trans('pre_project.status') }}
                        <i v-if="sortBy == 'status'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>
                    <th @click="sort('sale_id')" v-if="showColumn('sale_id')" role='button'>
                        {{ trans('pre_project.saler') }}
                        <i v-if="sortBy == 'sale_id'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>
                    <th @click="sort('created_at')" v-if="showColumn('created_at')" role='button'>
                        {{ trans('pre_project.created_at') }}
                        <i v-if="sortBy == 'created_at'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>

                    <th @click="sort('updated_at')" v-if="showColumn('updated_at')" role='button'>
                        {{ trans('pre_project.updated_at') }}
                        <i v-if="sortBy == 'updated_at'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>
                    <th @click="sort('closed_on')" v-if="showColumn('closed_on')" role='button'>
                        {{ trans('pre_project.closed_on') }}
                        <i v-if="sortBy == 'closed_on'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>

                    <th style="width:1px">
                        <div>{{ trans('label.action') }}</div>
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr v-for="item in list" :key="item.id">
                    <td scope="col" class=" px-4">
                        <input type="checkbox" class="gino-checkbox form-check-input" v-model="selected"
                            :value="item.id">
                    </td>
                    <td class="text-center" v-if="showColumn('id')">
                        ((item.id))
                        {{-- <a :href="`{{ asset('pre_project') }}/` + item.id + `/detail`"
                            title="{{ trans('label.view') }}" class="text-primary">
                        </a> --}}
                    </td>
                    <td v-if="showColumn('name')" v-html="item.name"></td>
                    <td v-if="showColumn('type')">
                        <span class="rounded-1 fs-11 p-1 "
                            :style="{
                                color: item.type_color ?? '#85d6ff',
                                backgroundColor: item.type_color ? item
                                    .type_color + '22' : '#85d6ff22'
                            }">
                            (( item.type_name ))
                        </span>
                    </td>
                    <td v-if="showColumn('customer_id')">(( item.customer?.name ))
                    </td>
                    <td v-if="showColumn('contacts')">
                        ((item.contacts[0]?.name))
                    </td>
                    <td v-if="showColumn('customer_type')">(( item.customer_type_name ))
                    </td>
                    <td v-if="showColumn('priority')">
                        <span class="priority-status-indicator" v-if="item.priority">
                            <span class="dot"
                                :style="{
                                    backgroundColor: item.priority_color
                                }"></span>
                            (( item.priority_name ))
                        </span>
                    </td>

                    <td v-if="showColumn('plan_money')">(( item.plan_money_formatted ))</td>
                    <td v-if="showColumn('success_percent')">
                        <span v-if="item.success_percent">(( item.success_percent ))%</span>
                    </td>
                    <td v-if="showColumn('plan_close_on')">
                        <span v-if="item.success_percent">(( item.plan_close_on ))</span>
                    </td>
                    <td v-if="showColumn('status')">
                        <div class="status-progress class">
                            <span :class="[{ 'completed': item.status_order >= stt.sort_order }, 'progress-item']"
                                v-for="stt in status" :key="stt.id"></span>
                        </div>
                        <span class="rounded-1 fs-11 p-1 ">
                            (( item.status_name ))
                        </span>
                    </td>
                    <td v-if="showColumn('sale_id')">
                        <div class="align-items-center">
                            <img :src="item.saler?.avatar_url" v-if="item.saler?.avatar_url" class="rounded-circle"
                                width="24" height="24" :alt="item.saler?.name" style="object-fit: cover">
                            (( item.saler?.name ))
                        </div>
                    </td>
                    <td v-if="showColumn('created_at')">(( item.created_at ))</td>
                    <td v-if="showColumn('updated_at')">(( item.updated_at ))</td>
                    <td v-if="showColumn('closed_on')">(( item.closed_on ))</td>
                    <td>
                        <div class="hstack gap-2 me-2">
                            <a :href="`{{ asset('pre-project') }}/` + item.id + `/detail`"
                                class="  action-btn rounded  p-1" title="{{ trans('label.view') }}">
                                @include('icons.eye')
                            </a>
                            <a href="##" @click="copyItem(item)" class="action-btn rounded p-1"
                                data-bs-toggle="modal" data-bs-target="#exampleModal">
                                @include('icons.copy')</a>
                            <form :action="`{{ asset('pre-project') }}/` + item.id" :id="'formDelete_' + ((item.id))"
                                method="post">
                                @method('DELETE')
                                @csrf
                                <a href="##" @click="deleteItem(item.id)" class="  action-btn rounded  p-1">
                                    @include('icons.trash')</a>
                            </form>
                        </div>
                    </td>
                </tr>
                <tr v-if="loading">
                    <td colspan="100%" class=" text-center">
                        <div class="spinner-border">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </td>
                </tr>
                <tr v-if="list.length < 1 && !loading">
                    <td colspan="100%" class="text-center">{{ trans('label.no_record') }}</td>
                </tr>

            </tbody>
        </table>
    </div>
</div>
@include('includes.pagination')
