<div class="position-relative table-wrapper " id="listView" role="listView">
    <div class="table-responsive gino-custom-table pb-0 rounded-3 border">
        <table class="table mb-0 text-nowrap bg-white ">
            <thead>
                <tr>
                    <th @click="sortSelect('select')" role='button' style="width: 1px" class=" col_checkbox px-4">
                        <input type="checkbox"
                            :class="[{ 'gino-checkbox--checked2': selectAll == 2 },
                                'gino-checkbox form-check-input'
                            ]"
                            v-model="selectAll" :checked="selectAll" @click.stop>
                        <i v-if="sortBy == 'select'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>

                    <template v-for="(col,key) in columns">
                        <th @click="sort(col.key3)" role='button' v-if="showColumn(col.key3)" :key="key">
                            {{--     (( col.key3 )) --}}
                            (( col.str_val1 ))
                            <i v-if="sortBy == col.key3"
                                v-bind:class="sortDirection == 'desc' ? 
                            'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                        </th>
                    </template>

                    <th style="width:1px">
                        <div>{{ trans('label.action') }}</div>
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr v-for="item in list" :key="item.id">
                    <td scope="col" class=" px-4">
                        <input type="checkbox" class="gino-checkbox form-check-input" v-model="selected"
                            :value="item.id">
                    </td>

                    <template v-for="(col,key) in columns">
                        {{-- col type --}}
                        <template v-if="col.key3 == 'type'">
                            <td v-if="showColumn('type')">
                                <span class="rounded-1 fs-11 p-1 "
                                    :style="{
                                        color: item.type_color ?? '#85d6ff',
                                        backgroundColor: item.type_color ? item
                                            .type_color + '22' : '#85d6ff22'
                                    }">
                                    (( item.type_name ))
                                </span>
                            </td>
                        </template>
                        {{-- col priority --}}
                        <template v-else-if="col.key3 == 'priority'">
                            <td v-if="showColumn('priority')">
                                <span class="priority-status-indicator" v-if="item.priority">
                                    <span class="dot"
                                        :style="{
                                            backgroundColor: item.priority_color
                                        }"></span>
                                    (( item.priority_name ))
                                </span>
                            </td>
                        </template>
                        {{-- col status --}}
                        <template v-else-if="col.key3 == 'status'">
                            <td v-if="showColumn('status')">
                                <div class="status-progress class">
                                    <span
                                        :class="[{ 'completed': item.status_order >= stt.sort_order }, 'progress-item']"
                                        :style="[item.status_order >= stt.sort_order ? { backgroundColor: stt.str_val2 } : {}]"
                                        v-for="stt in status" :key="stt.id"></span>
                                </div>
                                <span class="rounded-1 fs-11 p-1 ">
                                    (( item.status_name ))
                                </span>
                            </td>
                        </template>
                        {{-- col customer_id --}}
                        <template v-else-if="col.key3 == 'customer_id'">
                            <td v-if="showColumn('customer_id')">
                                <span>
                                    (( item.customer?.name ))
                                </span>
                            </td>
                        </template>
                        {{-- col name --}}
                        <template v-else-if="col.key3 == 'name'">
                            <td v-if="showColumn('name')">
                                <span v-html="item.name"></span>
                            </td>
                        </template>
                        {{-- col note --}}
                        <template v-else-if="col.key3 == 'note'">
                            <td v-if="showColumn('note')">
                                <span v-html="item.note"></span>
                            </td>
                        </template>
                        {{-- col staff_id --}}
                        <template v-else-if="col.key3 == 'staff_id'">
                            <td v-if="showColumn('staff_id')">
                                <span>
                                    (( item.staff?.name ))
                                </span>
                            </td>
                        </template>
                        {{-- col sale_id --}}
                        <template v-else-if="col.key3 == 'sale_id'">
                            <td v-if="showColumn('sale_id')">
                                <span>
                                    (( item.saler?.name ))
                                </span>
                            </td>
                        </template>
                        {{-- col created_by_id --}}
                        <template v-else-if="col.key3 == 'created_by_id'">
                            <td v-if="showColumn('created_by_id')">
                                <span>
                                    (( item.creator?.name ))
                                </span>
                            </td>
                        </template>
                        {{-- col updated_by_id --}}
                        <template v-else-if="col.key3 == 'updated_by_id'">
                            <td v-if="showColumn('updated_by_id')">
                                <span>
                                    (( item.updater?.name ))
                                </span>
                            </td>
                        </template>
                        {{-- col contacts --}}
                        <template v-else-if="col.key3 == 'contacts'">
                            <td v-if="showColumn('contacts')">
                                <span>
                                    (( item.contacts?.[0]?.name ))
                                </span>
                            </td>
                        </template>
                        {{-- col plan_money --}}
                        <template v-else-if="col.key3 == 'plan_money'">
                            <td v-if="showColumn('plan_money')">(( item.plan_money_formatted ))</td>
                        </template>
                        {{-- các col còn lại --}}
                        <template v-else>
                            <td :class="{ 'text-center': col.key3 == 'id' }" v-if="showColumn(col.key3)">
                                {{-- nếu lấy tên từ general purpose  --}}
                                <span v-if="item?.[`${col.key3}_name`]"> (( item?.[`${col.key3}_name`] ))</span>
                                {{-- các col bình thưởng  --}}
                                <span v-else> (( item[col.key3] ))</span><template
                                    v-if="item.success_percent && col.key3 == 'success_percent'">%</template>
                            </td>
                        </template>
                    </template>
                    {{--   
                    <td v-if="showColumn('plan_close_on')">
                        <span v-if="item.success_percent">(( item.plan_close_on ))</span>
                    </td>
                    <td v-if="showColumn('status')">
                        <div class="status-progress class">
                            <span :class="[{ 'completed': item.status_order >= stt.sort_order }, 'progress-item']"
                                v-for="stt in status" :key="stt.id"></span>
                        </div>
                        <span class="rounded-1 fs-11 p-1 ">
                            (( item.status_name ))
                        </span>
                    </td>
                    <td v-if="showColumn('sale_id')">
                        <div class="align-items-center">
                            <img :src="item.saler?.avatar_url" v-if="item.saler?.avatar_url" class="rounded-circle"
                                width="24" height="24" :alt="item.saler?.name" style="object-fit: cover">
                            (( item.saler?.name ))
                        </div>
                    </td>
                    <td v-if="showColumn('created_at')">(( item.created_at ))</td>
                    <td v-if="showColumn('updated_at')">(( item.updated_at ))</td>
                    <td v-if="showColumn('closed_on')">(( item.closed_on ))</td> --}}
                    <td>
                        <div class="hstack gap-2 me-2">
                            <a :href="`{{ asset('pre-project') }}/` + item.id + `/detail`"
                                class="  action-btn rounded  p-1" title="{{ trans('label.view') }}">
                                @include('icons.eye')
                            </a>
                            <a href="##" @click="copyItem(item)" class="action-btn rounded p-1"
                                data-bs-toggle="modal" data-bs-target="#exampleModal">
                                @include('icons.copy')</a>
                            <form :action="`{{ asset('pre-project') }}/` + item.id" :id="'formDelete_' + ((item.id))"
                                method="post">
                                @method('DELETE')
                                @csrf
                                <a href="##" @click="deleteItem(item.id)" class="  action-btn rounded  p-1">
                                    @include('icons.trash')</a>
                            </form>
                        </div>
                    </td>
                </tr>
                <tr v-if="loading">
                    <td colspan="100%" class=" text-center">
                        <div class="spinner-border">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </td>
                </tr>
                <tr v-if="list.length < 1 && !loading">
                    <td colspan="100%" class="text-center">{{ trans('label.no_record') }}</td>
                </tr>

            </tbody>
        </table>
    </div>
</div>
@include('includes.pagination')
