<template id="grid-view">
    <div class="position-relative table-wrapper ">
        <div class="d-flex gap-4 overflow-x-auto pb-3 kanban">
            <div v-for="item in status" class="d-flex flex-column flex-nowrap kanban-item"
                style="min-width:320px;min-height:400px;">
                <div class="header border-secondary p-2  text-white fw-bold rounded-top-3 d-flex"
                    :style="{ backgroundColor: item?.str_val2 ?? '#85d6ff' }">

                    <div class="flex-0 overflow-hidden text-truncate">
                        (( item?.str_val1 ))
                    </div>

                    <div class="flex-1 text-nowrap">
                        &nbsp / (( groupedList[item?.key3]?.length ))
                    </div>
                </div>
                <draggable v-model="groupedList[item?.key3]" @end="onDragEnd" :data_status="item?.key3" type="transition"
                    group="items" animation="200"
                    class="draggable-list fs-13 h-100 d-flex flex-column bg-white gap-3 p-2 pb-3 overflow-y-auto rounded-bottom-3"
                    style="background-color:#f6f7fb;">
                    <div v-for="item in groupedList[item?.key3]" :key="item.id"
                        class="bg-white draggable-item rounded-1 border">
                        <div class="p-12 ">
                            <div class="mb-2 text-gray-6 d-flex justify-content-between">{{-- <strong>{{ trans('pre_project.id') }} :</strong> --}}
                                <a :href="`{{ asset('pre-project') }}/` + item.id + `/detail`">
                                    <strong>#(( item.id ))</strong>
                                </a>
                                <a href="javascript:void(0);" data-bs-toggle="dropdown" aria-haspopup="true"
                                    aria-expanded="true" data-bs-offset="5,5">
                                    <i class="bi bi-three-dots"></i>
                                </a>
                                <div class="dropdown-menu dropdown-menu-end border-0 shadow rounded-1 py-2" @click.stop>
                                    <a :href="`{{ asset('pre-project') }}/` + item.id + `/detail`"
                                        class="dropdown-item d-flex gap-3" title="{{ trans('label.view') }}">
                                        @include('icons.eye') {{ trans('label.detail') }}
                                    </a>
                                    <a href="##" class="dropdown-item d-flex gap-3"
                                        @click="EventBus.$emit('copy_item',item)" title="{{ trans('label.copy') }}">
                                        @include('icons.copy') {{ trans('label.detail') }}
                                    </a>
                                    <form class="p-0 m-0" :action="`{{ asset('pre-project') }}/` + item.id"
                                        :id="'formDelete_' + ((item.id))" method="post">
                                        @method('DELETE')
                                        @csrf
                                        <a href="##" @click="deleteItem(item.id)"
                                            class="dropdown-item d-flex gap-3">
                                            @include('icons.trash') {{ trans('label.delete') }}
                                        </a>
                                    </form>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div>
                                    <strong>{{ trans('pre_project.customer') }} :</strong>
                                    <span>(( item.customer?.name ))</span>
                                </div>
                                <div>
                                    <strong>{{ trans('pre_project.customer_type') }} :</strong>
                                    <span> (( item.customer_type_name )) </span>
                                </div>
                                <div>
                                    <span class="text-bondi-blue"> (( item.name ))</span>
                                </div>
                            </div>
                            <div class="d-flex justify-content-spacebetween align-items-center">
                                <div class="flex-1">
                                    <span class="badge bg-primary-subtle text-blue fs-11 p-1">
                                        (( item.type_name ))</span>
                                </div>
                                <div class="flex-0 ms-auto avatar-group d-flex flex-nowrap">
                                    <div class="avatar-group-item" v-if="item?.saler?.avatar_url"
                                        :title="'{{ trans('pre_project.saler') }}' + item?.saler?.name">
                                        <img :src="item?.saler?.avatar_url" width="24" height="24"
                                            alt="">
                                    </div>
                                    <div class="avatar-group-item" v-if="item?.staff?.avatar_url"
                                        :title="'{{ trans('pre_project.staff') }}' + item?.staff?.name">
                                        <img :src="item?.staff?.avatar_url" width="24" height="24"
                                            alt="">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="p-12 d-flex border-top border-dashed justify-content-between gap-2">
                            <small class="text-muted text-nowrap">

                                <i class="ri-time-line align-bottom mr-1"></i>((item.updated_at_formatted))</small>
                            <small
                                class="text-end d-flex text-muted gap-1 align-items-center text-truncate overflow-hidden">
                                <span v-if="item.count_notes>0">
                                    <i class="fa-regular fa-pen-to-square"></i>
                                    {{-- <i class="ri-question-answer-line align-bottom"></i> --}}((item.count_notes))
                                </span>
                                <span v-if="item.count_emails>0">
                                    <i class="fa-regular fa-envelope"></i>
                                    {{-- <i class="ri-mail-unread-line align-bottom"></i> --}}((item.count_emails))
                                </span>
                                <span v-if="item.count_calls>0">
                                    <i class="fa-solid fa-mobile-screen-button"></i>
                                    {{-- <i class="ri-phone-line align-bottom"></i> --}}((item.count_calls))
                                </span>
                                <span v-if="item.count_tasks>0">
                                    <i class="fa-solid fa-list-check"></i>
                                    {{--  <i class="ri-task-line align-bottom"></i> --}}((item.count_tasks))
                                </span>
                                <span v-if="item.count_meetings>0">
                                    <i class="fa-regular fa-calendar"></i>
                                    {{--  <i class="ri-group-line align-bottom"></i> --}}((item.count_meetings))
                                </span>
                            </small>
                        </div>
                    </div>
                </draggable>
            </div>
        </div>
    </div>
</template>


<script>
    Vue.component('grid-view', {
        template: "#grid-view",
        components: {
            draggable: window['vuedraggable']
        },
        delimiters: ["((", "))"],
        props: {
            list: {
                type: Array,
                required: true
            },
            status: {
                type: Array,
                required: true
            },
        },
        data() {
            return {}
        },
        computed: {
            groupedList() {
                let grouped = {};
                this.status.forEach(item => {
                    // Vue.set(grouped, item.key3, this.getItemsByStatus(item.key3));
                    grouped[item.key3] = this.getItemsByStatus(item.key3);
                });
                return grouped;
            }
        },
        mounted() {},
        methods: {
            getItemsByStatus(status) {
                return this.list.filter(item => item.status == status)
            },
            onDragEnd(event) {
                if (event.from !== event.to) {
                    const item = event.item._underlying_vm_;
                    const targetStatus = event.to.__vue__.$attrs.data_status
                    this.updateStatus(item, targetStatus)
                    /*  console.log(item);
                     console.log(targetStatus); */
                    const foundItem = this.list.find(it => it.id === item.id);
                    foundItem.status = targetStatus

                }
            },
            updateStatus(item, status) {
                let that = this;
                this.createLoading = true
                jQuery.ajax({
                    type: 'PUT',
                    data: {
                        'status': status,
                        'item': item,
                    },
                    url: "{{ route('view.pre_project.update_status') }}/" + item.id,
                    success: function(data) {},
                    error: function(data) {}
                });
            },
            deleteItem(id) {
                Swal.fire({
                    title: '{{ trans('label.are_you_sure') }}',
                    text: '{{ trans('label.cant_revert') }}',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#dc3545',
                    cancelButtonColor: '#ffffff',
                    confirmButtonText: '{{ trans('label.yes_delete_it') }}',
                    cancelButtonText: '{{ trans('label.cancel') }}'
                }).then((result) => {
                    if (result.isConfirmed) {
                        jQuery('#formDelete_' + id).submit();
                    }
                })

            },
        },
    });
</script>
