<template id="calendar_view">
    <div class="bg-white mb-3 p-3 pb-0 d-flex flex-wrap">
        <div class="calendar-wrapper w-100">
            <div class="mb-0" id='pre-project-calendar'></div>
        </div>

        <div class="col-12 status-list d-flex justify-content-center gap-3 align-items-center p-3 border-top">
            <div v-for="item in status">
                <span class="priority-status-indicator">
                    <span class="dot" :style="{ backgroundColor: item?.str_val2 ?? '#85d6ff' }"></span>
                    (( item?.str_val1 ))
                </span>
            </div>
        </div>
    </div>
</template>

<script>
    Vue.component('calendar_view', {
        template: "#calendar_view",
        delimiters: ["((", "))"],
        props: {
            list: {
                type: Array,
                required: true
            },
            status: {
                type: Array,
                required: true
            },
        },
        data() {
            return {
                sortBy: 'event_id',
                page: 1,
                perPage: "{{ $default_records_per_page }}",
                loading: false,
                apiUrl: "{{ route('api.pre_projects.listEvent') }}",
                selectedObject: {},
            };
        },
        mounted() {
            this.renderCalendar();
        },
        methods: {
            async fetchEvents(start, end) {
                try {
                    const response = await $.get(this.apiUrl, {
                        start,
                        end
                    });
                    const events = response.result.map(event => ({
                        id: event.id,
                        title: event.title,
                        start: event.start,
                        end: event.end,
                        url: event.url,
                        note: event.note ?? "",
                        rendering: 'background',
                        color: event.status_color,
                        isHTML: event.isHTML,
                    }));
                    /*  console.log('Formatted Events:', events); */
                    return events;
                } catch (error) {
                    /*     console.error('Error fetching events:', error); */
                    return [];
                }
            },
            renderCalendar() {
                var calendarEl = document.getElementById('pre-project-calendar');
                this.calendar = new FullCalendar.Calendar(calendarEl, {
                    initialView: 'dayGridMonth',
                    events: async (fetchInfo, successCallback, failureCallback) => {
                        const {
                            startStr,
                            endStr
                        } = fetchInfo;
                        try {
                            const events = await this.fetchEvents(startStr, endStr);
                            successCallback(events);
                        } catch (error) {
                            failureCallback(error);
                        }
                    },
                    eventContent: function(arg) {
                        let divEl = document.createElement('div');

                        divEl.innerHTML = arg.event.title
                        let arrayOfDomNodes = [divEl]
                        return {
                            domNodes: arrayOfDomNodes
                        }
                    },
                    eventClick: this.handleEventClick,
                    headerToolbar: {
                        left: 'prev,next today',
                        center: 'title',
                        right: 'dayGridDay,dayGridWeek,dayGridMonth'
                    },
                    height: '110vh',
                    eventSources: [],
                    stickyHeaderDates: true,
                    editable: true,
                    locale: 'ja',
                    firstDay: 1,
                    handleWindowResize: true,
                    weekends: true,
                    fixedWeekCount: false,
                    dayMaxEvents: true,
                    buttonText: {
                        today: '今日',
                        month: '月',
                        week: '週',
                        day: '日',
                        list: '一覧'
                    },
                    views: {
                        timeGridWeek: {
                            titleFormat: function(date) {
                                const startMonth = date.start.month + 1;
                                const endMonth = date.end.month + 1;
                                if (startMonth === endMonth) {
                                    return startMonth + '月';
                                } else {
                                    return startMonth + '月～' + endMonth + '月';
                                }
                            },
                            dayHeaderFormat: function(date) {
                                const day = date.date.day;
                                const weekNum = date.date.marker.getDay();
                                const week = ['(日)', '(月)', '(火)', '(水)', '(木)', '(金)', '(土)'][
                                    weekNum
                                ];

                                return day + ' ' + week;
                            }
                        }
                    },
                    headerToolbar: {
                        left: 'prev,next today',
                        center: 'title',
                        right: 'dayGridDay,dayGridWeek,dayGridMonth'
                    },
                    dayCellContent: function(e) {
                        e.dayNumberText = e.dayNumberText.replace('日', '');
                    },
                    validRange: function() {
                        return {
                            start: '2021-03-17'
                        };
                    },
                    initialDate: '{{ now() }}',
                    navLinks: true,
                    editable: true,
                    eventOrder: "id",

                });
                this.calendar.render();
            },
            handleEventClick(info) {
                if (info.event.url) {
                    info.jsEvent.preventDefault();
                }
                Swal.fire({
                    title: info.event.title,
                    html: `
                    <p><strong>{{ trans('pre_project.created_at') }}:</strong> ${info.event.start.toLocaleString()}</p>
                    ${info.event.end ? `<p><strong>End:</strong> ${info.event.end.toLocaleString()}</p>` : ''}
                    <p><strong>{{ trans('pre_project.note') }}:</strong> ${info.event.extendedProps.note}</p>
                `,
                    icon: 'info',
                    showCancelButton: true,
                    confirmButtonText: `{{ trans('label.detail') }}`,
                    cancelButtonText: `{{ trans('label.close') }}`,
                }).then((result) => {
                    if (result.isConfirmed && info.event.url) {
                        window.open(info.event.url, "_blank");
                    }
                });
            }
        },
    });
</script>
