@extends('layouts.auth')

@section('title', 'Đăng Nhập')

@section('content')
    <div class="row bg-white">
        <div class="col-md-6 col-lg-6 col-xl-7 d-none d-md-flex bg-primary-transparent-3">
            <div class="row w-100 mx-auto text-center">
                <div class="col-md-12 col-lg-12 col-xl-12 my-auto mx-auto w-100">
                    <img src="{{ asset('assets/images/media/pngs/5.png') }}"
                        class="my-auto ht-xl-80p wd-md-100p wd-xl-80p mx-auto" alt="logo">
                </div>
            </div>
        </div>
        <div class="col-md-6 col-lg-6 col-xl-5 bg-white py-4">
            <div class="login d-flex align-items-center py-2">
                <div class="container p-0">
                    <div class="row">
                        <div class="col-md-10 col-lg-10 col-xl-9 mx-auto">
                            <div class="card-sigin">
                                <div class="mb-5 d-flex">
                                    <a href="/" class="header-logo"><img
                                            src="{{ asset('assets/images/brand-logos/desktop-logo.png') }}"
                                            class="desktop-logo ht-40" alt="logo">
                                        <img src="{{ asset('assets/images/brand-logos/desktop-white.png') }}"
                                            class="desktop-white ht-40" alt="logo">
                                    </a>
                                </div>
                                <div class="card-sigin">
                                    <div class="main-signup-header">
                                        <h3>Welcome back!</h3>
                                        <h6 class="fw-medium mb-4 fs-17">Please sign in to continue.</h6>
                                        @if ($errors->any())
                                            @foreach ($errors->all() as $error)
                                                <div class="alert alert-danger" role="alert">
                                                    {!! $error !!}
                                                </div>
                                            @endforeach
                                        @endif
                                        <form action="" method="post" autocomplete="on" enctype="multipart/form-data">
                                            @csrf
                                            <div class="form-group mb-3">
                                                <label class="form-label">Tài Khoản</label>
                                                <input class="form-control" name="username" type="text" required>
                                            </div>
                                            <div class="form-group mb-3">
                                                <label class="form-label">Mật Khẩu</label>
                                                <input class="form-control" name="password" type="password" required>
                                            </div>
                                            <button type="submit" class="btn btn-primary btn-block w-100">
                                                Đăng Nhập
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@section('script-footer')

    <script type="text/javascript">
        var options = {
            durations: {
                alert: 0,
                warning: 0,
                success: 2000,
            },
            icons: {
                enabled: false
            }
        }
        var notifier = new AWN(options);
    </script>

    @if ($errors->any())
        <script>
            let alertMessage = `
    @foreach ($errors->all() as $error)
    <br>
        {{ $error }}
    @endforeach
    `
            notifier.alert(alertMessage);
        </script>
    @endif

    @if (session('error'))
        <script>
            notifier.alert(`{{ session('error') }}`);
        </script>
    @endif

    @if (session('success'))
        <script>
            notifier.success(`{{ session('success') }}`);
        </script>
    @endif

    @if (session('status'))
        <script>
            notifier.success(`{{ session('status') }}`);
        </script>
    @endif
@endsection
