<!DOCTYPE html>
<html lang="en">
@php
    $keywords = "Kiet Nguyen TV- Kiet Studio Sân chơi thử thách mở ra không chỉ dành riêng cho CEO Anh Kiệt mà sẽ là sân chơi chung cho bất cứ ai có cùng đam mê thử thách bản thân có thể đăng ký tham gia. Tất nhiên, người tham gia thử thách thành công đều sẽ có những phần thưởng hấp ";
@endphp

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/reset.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/font.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/button.css" />
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/styles.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/home.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/about-us.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/contact.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/creative-category.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/creative-detail.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/value-sharing-category.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/value-sharing-detail.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/feature-film.css" />
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/film-maker-category.css" />
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/film-maker.css" />
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/film-maker.css" />
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/media.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/breakpoints.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/term.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/css/custome.css">
    <link rel="icon" type="image/x-icon" href="{{ asset('/assets') }}/images/favico.png">

    <script src="{{ asset('/assets') }}/media/js/slider_banner/jquery.min.js"></script>
    <script src="{{ asset('/assets') }}/media/js/slider_banner/jquery.bxslider.min.js"></script>
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/js/slider_banner/jquery.bxslider.min.css">

    <title>{{ $title ?  $title : 'Kiet Nguyen TV' }}</title>

    <!-- Meta SEO -->
    <meta name="description" content="{{ $description ?? 'Kiet Nguyen TV – Kênh mang đến nhiều thể loại vui nhộn rất hay cho người Việt ở nước Mỹ. Đặc biệt là các Phim do chính kênh sản xuất với nhiều chủ đề xoay quanh cuộc sống ở Mỹ, ở các nước ngoài. Kênh đón nhận nhiều bạn ở Việt Nam hoặc người Việt tham gia khám phá, đóng phim cùng đều có thể đăng ký tham gia. Tất nhiên, người tham gia thành công đều sẽ có những phần thưởng hấp dẫn đến từ CEO Anh Kiệt. ' }}" />
    <meta name="keywords" content="{{ $keywords ?? 'nghệ sĩ, tác phẩm, triển lãm, nghệ thuật' }}" />
    <meta name="robots" content="index, follow" />
    <link rel="canonical" href="{{ $canonicalUrl ?? url()->current() }}" />

    <!-- Open Graph Meta (Facebook) -->
    <meta property="og:title" content="{{ $ogTitle ?? $title }}" />
    <meta property="og:description" content="{{ $ogDescription ?? $description }}" />
    <meta property="og:image" content="{{ $ogImage ?? asset('images/share_img.png') }}" />
    <meta property="og:url" content="{{ $ogUrl ?? url()->current() }}" />
    <meta property="og:type" content="{{ $ogType ?? 'website' }}" />

    <!-- Twitter Card Meta -->
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:title" content="{{ $twitterTitle ?? $title }}" />
    <meta name="twitter:description" content="{{ $twitterDescription ?? $description }}" />
    <meta name="twitter:image" content="{{ $twitterImage ?? $ogImage }}" />

    <!-- Structured Data (Schema.org) -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "Person",
        "name": "{{ $artistName ?? 'NGUYEN ANH KIET' }}",
        "url": "{{ url()->current() }}",
        "image": "{{ $schemaImage ?? asset('images/share_img.png') }}",
        "jobTitle": "Nghệ sĩ",
        "description": "{{ $schemaDescription ?? '17 year-experience in Copywriting / Creative /Advertising.
        Creative Director & Screenwriter of 100 Branded Short Films / Advertising Films / MV
        and the most well-known PHO series.' }}",
        "worksFor": {
            "@type": "Organization",
            "name": "{{ $studioName ?? 'Kiet Nguyen TV' }}"
        },
        "sameAs": [
            "{{ 'https://www.facebook.com/kietnjvlog' }}",
            "{{ 'https://www.youtube.com/@kietnjvlog' }}"
        ]
    }
    </script>


</head>

<body>


    <div class="container">

        @include('includes.fe_header')
        @yield('content')

        @include('includes.fe_footer')
    </div>

    @include('includes.fe_side_menu')

    <script src="{{ asset('vueJs/vue.min.js') }}"></script>
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/js/carousel/slick.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/media/js/carousel/slick-theme.css">
    <script src="{{ asset('/assets') }}/media/js/carousel/slick.js"></script>
    <script>
        $(document).ready(function() {
            $('.menu-btn').on('click', function($e) {
                $e.stopPropagation();
                $('.menu-left').toggleClass('hidden');
            });
            $('.close-menu').on('click', function() {
                $('.menu-left').addClass('hidden');
            });
            $('.menu').on('click', function($e) {
                $e.stopPropagation();
            });
            $(document).on('click', function(e) {
                $('.menu-left').addClass('hidden');

            });


            /* filmaker category menu */
            $(".film-maker-mobile-category .item-menu-btn").on("click", function($e) {
                $(this).toggleClass('active')
                $(".film-maker-mobile-category-menu").slideToggle("fast");
            })
        });

        $(window).scroll(function() {
            if ($(this).scrollTop() > 90) {
                $('.header').addClass('fixed-header').removeClass('hidden-header');
            } else {
                $('.header').removeClass('fixed-header').addClass('hidden-header');
            }
        });
        $(document).ready(function() {
            $('.menu-item').on('click', function(e) {
                e.stopPropagation();
                e.preventDefault();
                var target = $(this).data('target');
                var $currentMenu = $(this).closest('.menu-level');

                $currentMenu.removeClass('active').addClass('prev');
                $(target).css('display', 'block');

                setTimeout(function() {
                    $(target).addClass('active');
                    $currentMenu.css('display', 'none').removeClass('prev');
                }, 50);

            });

            $('.back-btn').on('click', function() {
                var $currentMenu = $(this).closest('.menu-level');
                var $prevMenu = $currentMenu.data('parent-menu');

                $currentMenu.removeClass('active');
                $prevMenu.css('display', 'block').addClass('prev active');

                setTimeout(function() {
                    $currentMenu.css('display', 'none');
                    $prevMenu.removeClass('prev');
                }, 150);
            });

            $('.menu-item').each(function() {
                var target = $(this).data('target');
                var $parentMenu = $(this).closest('.menu-level');
                $(target).data('parent-menu', $parentMenu);
            });
        });
    </script>
    <script>
        $('.js-toggle-search').click(function(e) {
            e.stopPropagation();
            $('.header-search-box').fadeToggle(50);
        });
        $('body').click(function(e) {
            if (!$(e.target).closest('.header-search-box, .js-toggle-search').length) {
                $('.header-search-box').fadeOut(50);
            }
        });
    </script>

    @yield('script')
    <script>
        // Detect if the user is on macOS
        if (navigator.platform.toUpperCase().indexOf('MAC') >= 0 && window.innerWidth > 1024) {
            $('.container').addClass('mac-zoom');
            $('.menu-left').addClass('zoom-mac');
        }
    </script>
</body>


</html>
