<header class="header">
    <div class="menu-btn">
        <img src="{{ asset('/assets') }}/media/images/menu_icon.png" />
    </div>
    <div class="logo">
        <a href="{{ asset('/') }}">
            <img src="{{ asset('/assets') }}/media/images/logo.png" />
        </a>
    </div>
    <div class="menu-pc">
        <a class="item-menu-parent  {{ request()->is('/') ? 'active-menu' : '' }}" href="/"><span class="lable-menu">{{ __('label.home') }}</span></a>
        <a class="item-menu-parent {{ request()->is('about-us') ? 'active-menu' : '' }}" href="/about-us"><span class="lable-menu">{{ __('label.aboutus') }}</span></a>
        <div class="item-menu-parent {{ request()->is('advertising/*') ? 'active-menu' : '' }}">
            <span class="lable-menu">{{ __('label.service') }}</span>
            <div class="group-menu-chilren">
                @foreach($services_menu as $category)
                <a class="link-menu-children" href="{{ route('frontend.advertising.category', $category->slug) }}">
                    {{ $category->name }}
                </a>
                @endforeach
            </div>
        </div>

        <div class="item-menu-parent {{ request()->is('process/*') ? 'active-menu' : '' }}">
            <span class="lable-menu">{{ __('label.procedure') }}</span>
            <div class="group-menu-chilren">
                @foreach($processs as $process)
                <a class="link-menu-children" href="{{ route('frontend.process.detail', $process->link) }}">
                    {{ $process->name }}
                </a>
                @endforeach
            </div>
        </div>

        <div class="item-menu-parent {{ request()->is('filmmaking/*') ? 'active-menu' : '' }}">
            <span class="lable-menu">{{ __('label.filmmaking') }}</span>
            <div class="group-menu-chilren">
                @foreach($filmmakings as $filmmaking)
                <a class="link-menu-children" href="{{ route('frontend.filmmaking.detail', $filmmaking->link) }}">
                    {{ $filmmaking->name }}
                </a>
                @endforeach
            </div>
        </div>

        <a class="item-menu-parent {{ request()->is('quote') ? 'active-menu' : '' }}" href="/quote"><span class="lable-menu">{{ __('label.quote') }}</span></a>
        <a class="item-menu-parent {{ request()->is('contact') ? 'active-menu' : '' }}" href="/contact"><span class="lable-menu">{{ __('label.contact') }}</span></a>
    </div>
    <div class="search">

        <a href="{{ route('change.language', ['locale' => 'en']) }}" class="language_header {{ App::getLocale() == 'en' ? 'language_header_active' : '' }}">EN</a>
        <a href="{{ route('change.language', ['locale' => 'vi']) }}" class="language_header {{ App::getLocale() == 'vi' ? 'language_header_active' : '' }}">VI</a>
        <img src="{{ asset('/assets') }}/media/images/search.png" class="js-toggle-search" />
        <!-- <img src="{{ asset('/assets') }}/media/images/calendar.png" class="mobile-d-none" /> -->
    </div>
    <div class="header-search-box">
        <form action="{{ route('frontend.film.search') }}">
            <div class="search-box">
                <input type="text" class="search" name="search"
                    value="{{ isset($_GET['search']) ? $_GET['search'] : '' }}" placeholder="{{ __('label.search') }}" />
                <button type="submit" class="search-icon search-submit-btn">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"
                        fill="none">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M8.1999 14.6302C11.8616 14.6302 14.8299 11.6618 14.8299 8.0002C14.8299 4.33855 11.8616 1.3702 8.1999 1.3702C4.53825 1.3702 1.5699 4.33855 1.5699 8.0002C1.5699 11.6618 4.53825 14.6302 8.1999 14.6302ZM8.1999 15.8002C12.5077 15.8002 15.9999 12.308 15.9999 8.0002C15.9999 3.69237 12.5077 0.200195 8.1999 0.200195C3.89208 0.200195 0.399902 3.69237 0.399902 8.0002C0.399902 12.308 3.89208 15.8002 8.1999 15.8002Z"
                            fill="#B6B6B6" />
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M15.6336 15.4339C15.4051 15.6623 15.0347 15.6623 14.8062 15.4339L13.2462 13.8739C13.0178 13.6454 13.0178 13.275 13.2462 13.0465C13.4747 12.8181 13.8451 12.8181 14.0736 13.0465L15.6336 14.6065C15.862 14.835 15.862 15.2054 15.6336 15.4339Z"
                            fill="#B6B6B6" />
                    </svg>
                </button>
            </div>
        </form>
    </div>
</header>