@extends('layouts.fe_master')

@php
    $title = "Kiet Nguyen TV - " .  $category->title;
    $description =  $category->title;
    $ogTitle = $title;
    $ogDescription = $description;
    $ogImage = url('/assets/images/media/media-1.jpg');
    $twitterTitle = $title;
    $twitterDescription = $description;
    $artistName = "Kiet Nguyen TV";
    $schemaDescription = $description;
@endphp

@section('content')
    <div class="header-padding"></div>
    <div class="main value-sharing-category-content" id="App">
        <div class="value-sharing-category-top">
            <h1 class="value-sharing-category-title">
                {{ $category->title }}
            </h1>
            <div class="value-sharing-category-heading">
                <p class="value-sharing-category-description">
                    <span>{!! $category->description !!}</span>
                </p>
                <div class="value-sharing-category-action-bar d-flex">
                    <div class="search-box">
                        <input type="text" class="search" v-model="searchObj.s" @keyup="search()" placeholder="Search" />
                        <div class="search-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"
                                fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M8.1999 14.6302C11.8616 14.6302 14.8299 11.6618 14.8299 8.0002C14.8299 4.33855 11.8616 1.3702 8.1999 1.3702C4.53825 1.3702 1.5699 4.33855 1.5699 8.0002C1.5699 11.6618 4.53825 14.6302 8.1999 14.6302ZM8.1999 15.8002C12.5077 15.8002 15.9999 12.308 15.9999 8.0002C15.9999 3.69237 12.5077 0.200195 8.1999 0.200195C3.89208 0.200195 0.399902 3.69237 0.399902 8.0002C0.399902 12.308 3.89208 15.8002 8.1999 15.8002Z"
                                    fill="#B6B6B6" />
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M15.6336 15.4339C15.4051 15.6623 15.0347 15.6623 14.8062 15.4339L13.2462 13.8739C13.0178 13.6454 13.0178 13.275 13.2462 13.0465C13.4747 12.8181 13.8451 12.8181 14.0736 13.0465L15.6336 14.6065C15.862 14.835 15.862 15.2054 15.6336 15.4339Z"
                                    fill="#B6B6B6" />
                            </svg>
                        </div>
                    </div>
                 {{--    <div class="search-box">
                        <input type="text" class="search" placeholder="Search" />
                        <div class="search-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"
                                fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M8.1999 14.6302C11.8616 14.6302 14.8299 11.6618 14.8299 8.0002C14.8299 4.33855 11.8616 1.3702 8.1999 1.3702C4.53825 1.3702 1.5699 4.33855 1.5699 8.0002C1.5699 11.6618 4.53825 14.6302 8.1999 14.6302ZM8.1999 15.8002C12.5077 15.8002 15.9999 12.308 15.9999 8.0002C15.9999 3.69237 12.5077 0.200195 8.1999 0.200195C3.89208 0.200195 0.399902 3.69237 0.399902 8.0002C0.399902 12.308 3.89208 15.8002 8.1999 15.8002Z"
                                    fill="#B6B6B6" />
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M15.6336 15.4339C15.4051 15.6623 15.0347 15.6623 14.8062 15.4339L13.2462 13.8739C13.0178 13.6454 13.0178 13.275 13.2462 13.0465C13.4747 12.8181 13.8451 12.8181 14.0736 13.0465L15.6336 14.6065C15.862 14.835 15.862 15.2054 15.6336 15.4339Z"
                                    fill="#B6B6B6" />
                            </svg>
                        </div>
                    </div> --}}
                </div>
            </div>

        </div>


        <div class="value-sharing-category-cards">
            <template v-for="item in list">
                <div class="card">
                    <figure class="card-figure card-figure-custome">
                        <a class="card-figure-link" :href="`{{ route('frontend.value-sharing.detail') }}/${item.id}`">
                            <div class="card-figure-container">
                                <img :src="item.img_url" :alt="item.name" />
                            </div>
                        </a>
                        <div class="tag" v-if="item.tag">
                            ((item.tag))
                        </div>
                    </figure>
                    <div>
                        <span class="date">Oct25,2024</span>
                        <a :href="`{{ route('frontend.value-sharing.detail') }}/${item.id}`">
                            <h3 class="title">
                                ((item.name))
                            </h3>
                        </a>
                    </div>
                </div>
            </template>
        </div>
        <a class="btn btn-w100 readmore-pb" v-if="showLoadMore && !loading" @click="loadMore()">Read More</a>
        <!-- <div class="pt32"></div> -->
    </div>

@endsection

@section('script')
    <script src="https://cdn.jsdelivr.net/npm/lodash@4.17.21/lodash.min.js"></script>

    <script>
        new Vue({
            el: '#App',
            data: {
                listPost: [],
                last_page: 1,
                current_page: 1,
                loading: false,
                searchObj: {
                    page: 1,
                    category_id: "{{ $category->id }}",
                },
                showSort: false,
                showFilter: false,
            },
            delimiters: ['((', '))'],
            computed: {
                list: function() {
                    return this.listPost;
                },
                showLoadMore: function() {
                    return this.current_page != this.last_page;
                }
            },
            mounted() {
                this.loadMore();
                document.addEventListener('click', (event) => {
                    this.closeDropdown();
                });
            },
            created() {
                this.debouncedLoad = _.debounce(() => {
                    this.load();
                }, 400);
            },
            methods: {
                search() {
                    this.listPost = [];
                    this.debouncedLoad();
                },
                getList(paginate = 0) {
                    return jQuery.ajax({
                        type: 'GET',
                        data: this.searchObj,
                        url: "{{ route('frontend.post.getList') }}",
                    });
                },
                async load() {
                    this.searchObj.page = 1;
                    let result = await this.getList();
                    if (result.success) {
                        this.current_page = result.result.current_page;
                        this.last_page = result.result.last_page;
                        this.listPost = [...result?.result?.data];
                    }
                    this.searchObj.page = 2;
                },
                async loadMore() {
                    if (this.loading) return;
                    this.loading = true;
                    let result = await this.getList();
                    if (result.success) {
                        this.searchObj.page++;
                        this.current_page = result.result.current_page;
                        this.last_page = result.result.last_page;
                        this.listPost = [...this.listPost, ...result?.result?.data];
                    }
                    this.loading = false;
                }

            }
        })
    </script>
@endsection
