@extends('layouts.fe_master')

@php
    $title = "Kiet Nguyen TV - CREATIVE";
    $description = $category->description;
    $ogTitle = $title;
    $ogDescription = $description;
    $ogImage = url('/assets/images/media/media-1.jpg');
    $twitterTitle = $title;
    $twitterDescription = $description;
    $artistName = "Kiet Nguyen TV";
    $schemaDescription = $description;
@endphp

@section('content')
    <div id="App">
        <div class="header-padding"></div>
        {{--  <div class="banner">
        <img src="{{ $page->banner_url }}" class="img" alt="home banner" />
        <div class="play-btn">
            <img src="{{ asset('/assets') }}/media/images/svg/play-btn.svg" />
        </div>
    </div> --}}
        <!-- main -->
        <div class="main creative-category-content">
            <h1 class="creative-category-title">
                {!! nl2br($category->title) !!}
            </h1>
            <p class="creative-category-description">
                {!! $category->description !!}
            </p>
            <div class="creative-category-action-bar d-flex">
                <div class="filter-wrapper">
                    <div class="btn btn-filter" @click.stop="toggleDropdown('sort')">
                        Sort
                        <div class="dropdown" v-if="showSort">
                            <div :class="[{ 'active': searchObj.order_by == 'newest' }, 'item']" @click="sort('newest')">
                                Mới Nhất
                            </div>
                            <div :class="[{ 'active': searchObj.order_by == 'oldest' }, 'item']" @click="sort('oldest')">
                                Cũ Nhất
                            </div>
                        </div>
                    </div>
                    <div class="btn  btn-filter filter-btn" @click.stop="toggleDropdown('filter')">
                        Fillter
                        <div class="dropdown" v-if="showFilter">
                            <template v-for="(item,key) in brands">
                                <div class="checkItem" @click.stop>
                                    <input type="checkbox" :id="`brand_${key}`" :value="item.id" @click="search()"
                                        v-model="searchObj.brand_ids" />
                                    <label :for="`brand_${key}`"> ((item.name))</label>
                                </div>
                            </template>
                        </div>
                    </div>
                </div>
                <div class="search-box">
                    <input type="text" class="search input_box" v-model="searchObj.s" @keyup="search()" placeholder="Search" />
                    <div class="search-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"
                            fill="none">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M8.1999 14.6302C11.8616 14.6302 14.8299 11.6618 14.8299 8.0002C14.8299 4.33855 11.8616 1.3702 8.1999 1.3702C4.53825 1.3702 1.5699 4.33855 1.5699 8.0002C1.5699 11.6618 4.53825 14.6302 8.1999 14.6302ZM8.1999 15.8002C12.5077 15.8002 15.9999 12.308 15.9999 8.0002C15.9999 3.69237 12.5077 0.200195 8.1999 0.200195C3.89208 0.200195 0.399902 3.69237 0.399902 8.0002C0.399902 12.308 3.89208 15.8002 8.1999 15.8002Z"
                                fill="#B6B6B6" />
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M15.6336 15.4339C15.4051 15.6623 15.0347 15.6623 14.8062 15.4339L13.2462 13.8739C13.0178 13.6454 13.0178 13.275 13.2462 13.0465C13.4747 12.8181 13.8451 12.8181 14.0736 13.0465L15.6336 14.6065C15.862 14.835 15.862 15.2054 15.6336 15.4339Z"
                                fill="#B6B6B6" />
                        </svg>
                    </div>
                </div>
            </div>

            <div class="creative-category-cards">
                <template v-for="item in list">
                    <div class="card" :style="{ backgroundImage: `url('${item.img_url}')` }">
                        <h3 class="title">((item.name))</h3>
                        <a :href="`{{ route('frontend.creative.detail') }}/${item.id}`" class="view-work-link">
                            <span class="view-work">View Work <svg xmlns="http://www.w3.org/2000/svg" width="21"
                                    height="15" viewBox="0 0 21 15" fill="none">
                                    <path
                                        d="M20.3634 8.11336C20.7539 7.72283 20.7539 7.08967 20.3634 6.69914L13.9994 0.335181C13.6089 -0.0553433 12.9757 -0.0553433 12.5852 0.335181C12.1947 0.725706 12.1947 1.35887 12.5852 1.74939L18.242 7.40625L12.5852 13.0631C12.1947 13.4536 12.1947 14.0868 12.5852 14.4773C12.9757 14.8678 13.6089 14.8678 13.9994 14.4773L20.3634 8.11336ZM0.65625 8.40625L19.6563 8.40625L19.6562 6.40625L0.65625 6.40625L0.65625 8.40625Z"
                                        fill="white" />
                                </svg></span>
                        </a>
                    </div>
                </template>
                {{--    @foreach ($posts as $item)
                @endforeach --}}
            </div>
            <a class="btn btn-w100 readmore-pb" v-if="showLoadMore" @click="loadMore()">Read More</a>
        </div>
        <!-- end main -->
    </div>

@endsection

@section('script')
    <script src="https://cdn.jsdelivr.net/npm/lodash@4.17.21/lodash.min.js"></script>

    <script>
        new Vue({
            el: '#App',
            data: {
                listPost: [],
                last_page: 1,
                current_page: 1,
                loading: false,
                searchObj: {
                    page: 1,
                    category_id: "{{ $category->id }}",
                    order_by: "newest",
                    brand_ids: @json($brands->pluck('id')),
                },
                showSort: false,
                showFilter: false,
                brands: @json($brands),
            },
            delimiters: ['((', '))'],
            computed: {
                list: function() {
                    return this.listPost;
                },
                showLoadMore: function() {
                    return this.current_page != this.last_page;
                }
            },
            mounted() {
                this.loadMore();
                document.addEventListener('click', (event) => {
                    this.closeDropdown();
                });
            },
            created() {
                this.debouncedLoad = _.debounce(() => {
                    this.load();
                }, 400);
            },
            methods: {
                closeDropdown() {
                    this.showSort = false;
                    this.showFilter = false;
                },
                toggleDropdown(type) {
                    if (type == 'sort') {
                        this.showSort = !this.showSort
                    }
                    if (type == 'filter') {
                        this.showFilter = !this.showFilter
                    }
                },
                sort(type) {
                    this.listPost = [];
                    this.searchObj.order_by = type;
                    this.load();
                },
                search() {
                    this.listPost = [];
                    this.debouncedLoad();
                },
                getList(paginate = 0) {
                    return jQuery.ajax({
                        type: 'GET',
                        data: this.searchObj,
                        url: "{{ route('frontend.post.getList') }}",
                    });
                },
                async load() {
                    this.searchObj.page = 1;
                    let result = await this.getList();
                    if (result.success) {
                        this.current_page = result.result.current_page;
                        this.last_page = result.result.last_page;
                        this.listPost = [...result?.result?.data];
                    }
                    this.searchObj.page = 2;
                },
                async loadMore() {
                    if (this.loading) return;
                    this.loading = true;
                    let result = await this.getList();
                    if (result.success) {
                        this.searchObj.page++;
                        this.current_page = result.result.current_page;
                        this.last_page = result.result.last_page;
                        this.listPost = [...this.listPost, ...result?.result?.data];
                    }
                    this.loading = false;
                }

            }
        })

        $(document).ready(function() {
            // Kiểm tra nếu đang trên thiết bị di động
            var isMobile = /iPhone|iPad|iPod|Android/i.test(navigator.userAgent);

            if (isMobile) {
                $('.input_box').on('focus', function() {
                    $('.search-box').addClass("focus_abs");
                    // Thực hiện hành động khi input được focus
                    console.log('Input is focused');
                    // Bạn có thể thêm mã xử lý khác ở đây
                });

                $('.input_box').on('blur', function() {
                    // Thực hiện hành động khi input mất focus
                    $('.search-box').removeClass("focus_abs");
                    console.log('Input is out of focus');
                    // Bạn có thể thêm mã xử lý khác ở đây
                });
            }
        });
    </script>
@endsection
