@extends('layouts.fe_master')

@php
    $title = "Kiet Nguyen TV - " . $post->name;
    $description = $post->text;
    $ogTitle = $title;
    $ogDescription = $description;
    $ogImage = url($post->banner_url);
    $twitterTitle = $title;
    $twitterDescription = $description;
    $artistName = "Kiet Nguyen TV";
    $schemaDescription = $description;
@endphp

@section('content')
    <div class="header-padding"></div>

    <div class="creative-detail-banner">
        <img src="{{ $post->banner_url }}" class="img" alt="home banner" />
        <div class="text">
            <h1>{{ $post->name }}</h1>
            <span>{{ $post->text }}</span>
        </div>
    </div>
    <!-- main -->
    <div class="main">
        <div class="film-maker-category">
            @if ($post->video_id)
                <div class="creative-detail-video" style="min-height: 350px">
                    <iframe width="100%" height="100%" style="min-height: 70.65vh"
                        src="https://www.youtube.com/embed/{{ $post->video_id }}?si=hVXs0_bgiAQoD1NY"
                        title="YouTube video player" frameborder="0"
                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                        referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                    {{-- <img src="./media/images/pages/creative/creative-detail-video.png" class="img" alt="home banner" />
                <div class="play-btn">
                    <img src="./media/images/svg/play-btn.svg" />
                </div> --}}
                </div>
            @endif

            {!! $post->content !!}

            <div class="btn">
                <span> Back to Creative Gallery </span>
                <span class="icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"
                        fill="none">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M16.5201 0.480197C17.0724 0.48021 17.5201 0.927936 17.5201 1.48022L17.5198 10.4802C17.5198 11.0325 17.0721 11.4802 16.5198 11.4802C15.9675 11.4802 15.5198 11.0325 15.5198 10.4802L15.52 3.89439L2.18695 17.2268C1.79641 17.6173 1.16325 17.6173 0.772735 17.2268C0.38222 16.8362 0.382235 16.2031 0.772769 15.8126L14.1058 2.48014L7.52004 2.47998C6.96776 2.47997 6.52005 2.03224 6.52007 1.47996C6.52008 0.927672 6.96781 0.479967 7.52009 0.47998L16.5201 0.480197Z"
                            fill="black" />
                    </svg>
                </span>
            </div>

        </div>

        <div class="pt32"></div>
    </div>
    <!-- end main -->


    @include('frontend.film.video_overlay')
@endsection
