@extends('layouts.fe_master')

@php
$title = 'Kiet Nguyen TV- Kiet Studio';
$description = "Kiet Nguyen TV- Kiet Studio – Kênh mang đến nhiều thể loại vui nhộn rất hay cho người Việt ở nước Mỹ. Đặc biệt là các Phim do chính kênh sản xuất với nhiều chủ đề xoay quanh cuộc sống ở Mỹ, ở các nước ngoài. Kênh đón nhận nhiều bạn ở Việt Nam hoặc người Việt tham gia khám phá, đóng phim cùng đều có thể đăng ký tham gia. Tất nhiên, người tham gia thành công đều sẽ có những phần thưởng hấp dẫn đến từ CEO Anh Kiệt. ";
$ogTitle = $title;
$ogDescription = $description;
$ogImage = url('/assets/images/share_img.png');
$twitterTitle = $title;
$twitterDescription = $description;
$artistName = 'Kiet Nguyen TV';
$schemaDescription = $description;
@endphp

@section('content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />

<div class="header-padding"></div>
<div class="banner-home" style="background-image: url({{ $page->banner_url }});">
    <div class="content-banner">
        <div class="flex-content">
            <div class="fs-about-left">
                {!! $page->title !!}
            </div>
            <!-- <div class="left-banner">
                <span class="slogan-banner">A Production House in Vietnam</span>
                <span class="title-banner">No.1 in KANLAMPHIM</span>
                <span class="description-banner">Chúng tôi nỗ lực mang lại hình ảnh và video chuyên nghiệp giúp doanh nghiệp và thương hiệu định vị mạnh mẽ.</span>
                <form class="input-subriceber-button">
                    <input type="email" name="email" placeholder="Enter your email" required="" class="bdt-input">
                    <button type="submit">
                        Gửi
                    </button>
                </form>
            </div> -->
            <div class="right-banner">
                <video muted loop controls>
                    <source src="{{ asset('/assets') }}/video/chuyen_tinh_kiet_trang.mp4" type="video/mp4">
                    Your browser does not support the video tag.
                </video>
            </div>
        </div>
    </div>
</div>
<!-- @if ($page->banner_link)
        <div class="banner-video">
            <video autoplay muted loop controls >
                <source src="{{ asset('/assets') }}/images/trailer_NAIL_2.mp4" type="video/mp4">
                Your browser does not support the video tag.
            </video>
        </div>
    @else
        <div class="banner">
            <img src="{{ $page->banner_url }}" class="img" alt="home banner" />
            {{-- <div class="play-btn">
            <img src="{{ asset('/assets') }}/media/images/svg/play-btn.svg" />
        </div> --}}
        </div>
    @endif -->
<!-- main -->
<div class="main">

    <section class="fs-about-section">
        <div class="fs-about-wrapper">
            <div class="left-banner">
                {!! $page->about_description !!}
                <form class="input-subriceber-button">
                    <input type="email" name="email" placeholder="{{ __('label.enter_email') }}" required="" class="bdt-input">
                    <button type="submit">
                        {{ __('label.send') }}
                    </button>
                </form>
            </div>
            <div class="fs-about-right">
                <img src="{{ asset('/assets') }}/media/images/about-us.png" alt="Hậu trường ekip làm phim" />
            </div>
        </div>
    </section>


    <div class="our-services">
        <div class="section-title our-service-title">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="23" viewBox="0 0 18 23" fill="none">
                <path
                    d="M17.5079 16.0587C17.8984 15.6681 17.8984 15.035 17.5079 14.6445L11.1439 8.28049C10.7534 7.88997 10.1202 7.88997 9.72971 8.28049C9.33919 8.67102 9.33919 9.30418 9.72971 9.69471L15.3866 15.3516L9.72971 21.0084C9.33919 21.3989 9.33919 22.0321 9.72971 22.4226C10.1202 22.8132 10.7534 22.8132 11.1439 22.4226L17.5079 16.0587ZM0.800781 0.351562V10.3516H2.80078V0.351562H0.800781ZM6.80078 16.3516H16.8008V14.3516H6.80078V16.3516ZM0.800781 10.3516C0.800781 13.6653 3.48707 16.3516 6.80078 16.3516V14.3516C4.59164 14.3516 2.80078 12.5607 2.80078 10.3516H0.800781Z"
                    fill="black" />
            </svg>
            <h3>
                {{ __('label.how_to_choose') }}
            </h3>
        </div>
        <div class="description-title">
            <span>“{{ __('label.slogan_how_to_choose') }}”</span>
        </div>

        <div class="why-us-section">
            <div class="why-us-list">
                <div class="why-us-item">
                    <h3>🎥 {{ __('label.titile_how_to_choose_1') }}</h3>
                    <p>{{ __('label.des_how_to_choose_1') }}</p>
                </div>
                <div class="why-us-item">
                    <h3>🎬 {{ __('label.titile_how_to_choose_2') }}</h3>
                    <p>{{ __('label.des_how_to_choose_2') }}</p>
                </div>
                <div class="why-us-item">
                    <h3>💖 {{ __('label.titile_how_to_choose_3') }}</h3>
                    <p>{{ __('label.des_how_to_choose_3') }}</p>
                </div>
            </div>
        </div>
    </div>

    @include('frontend.home.comp.service')

    @include('frontend.home.comp.client', [
    'clients' => $page->client_data->sortBy('order'),
    'client_title' => $page->client_title,
    ])



    <div class="highlight">
        <div class="section-title highlight-title">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="23" viewBox="0 0 18 23" fill="none">
                <path
                    d="M17.5079 16.0587C17.8984 15.6681 17.8984 15.035 17.5079 14.6445L11.1439 8.28049C10.7534 7.88997 10.1202 7.88997 9.72971 8.28049C9.33919 8.67102 9.33919 9.30418 9.72971 9.69471L15.3866 15.3516L9.72971 21.0084C9.33919 21.3989 9.33919 22.0321 9.72971 22.4226C10.1202 22.8132 10.7534 22.8132 11.1439 22.4226L17.5079 16.0587ZM0.800781 0.351562V10.3516H2.80078V0.351562H0.800781ZM6.80078 16.3516H16.8008V14.3516H6.80078V16.3516ZM0.800781 10.3516C0.800781 13.6653 3.48707 16.3516 6.80078 16.3516V14.3516C4.59164 14.3516 2.80078 12.5607 2.80078 10.3516H0.800781Z"
                    fill="black" />
            </svg>
            <h3>
                {{ __('label.product') }}
            </h3>
        </div>
        <div class="description-title">
            <span>“{{ __('label.slogan_product') }}”</span>
        </div>
        <div class="highlight-content">
            @foreach ($highlighted as $item)
            <article class="js-open-video-overlay card" data-film='@json($item)'>
                <div class="card-header position-relative">
                    <a href="##">
                        <img src="{{ $item->img_url }}" alt="{{ $item->title }}" />
                    </a>
                    <div class="play-btn-custome">
                        <img src="{{ asset('/assets') }}/media/images/svg/play-btn.svg" />
                    </div>
                </div>
                <div class="card-body">
                    <a href="##" class="card-title">
                        {!! $item->name !!}
                    </a>
                </div>
            </article>
            @endforeach
        </div>
    </div>


    <!-- @include('frontend.home.comp.award', [
    'awards' => $page->award_data->sortBy('order'),
    'award_title' => $page->award_title,
    ]) -->



    <div class="news-blog">
        <div class="section-title news-blog-title">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="23" viewBox="0 0 18 23" fill="none">
                <path
                    d="M17.5079 16.0587C17.8984 15.6681 17.8984 15.035 17.5079 14.6445L11.1439 8.28049C10.7534 7.88997 10.1202 7.88997 9.72971 8.28049C9.33919 8.67102 9.33919 9.30418 9.72971 9.69471L15.3866 15.3516L9.72971 21.0084C9.33919 21.3989 9.33919 22.0321 9.72971 22.4226C10.1202 22.8132 10.7534 22.8132 11.1439 22.4226L17.5079 16.0587ZM0.800781 0.351562V10.3516H2.80078V0.351562H0.800781ZM6.80078 16.3516H16.8008V14.3516H6.80078V16.3516ZM0.800781 10.3516C0.800781 13.6653 3.48707 16.3516 6.80078 16.3516V14.3516C4.59164 14.3516 2.80078 12.5607 2.80078 10.3516H0.800781Z"
                    fill="black" />
            </svg>
            <h3>
                {{ __('label.article') }}
            </h3>
        </div>
        <div class="description-title">
            <span>“{{ __('label.slogan_article') }}”</span>
        </div>
        <div class="news-blog-content">
            @foreach ($articles as $item)
            <article class="card">
                <a class="card-header" href="{{ route('frontend.articles.detail', $item->id) }}">
                    <img src="{{ asset($item->img_url) }}" alt="news-blog-1">
                </a>
                <div class="card-body">
                    <a class="card-title" href="{{ route('frontend.articles.detail', $item->id) }}">
                        {!! $item->name !!}
                    </a>
                    <div class="card-body-icon">
                        <a href="{{ route('frontend.articles.detail', $item->id) }}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="20"
                                viewBox="0 0 64 32" fill="none">
                                <path d="M1 15.6581H62" stroke="black" stroke-width="2" stroke-linecap="round" />
                                <path d="M47.5303 1.18835L62 15.6584L47.5303 30.1281" stroke="black"
                                    stroke-width="2" stroke-linecap="round" />
                            </svg>
                        </a>
                    </div>
                </div>
            </article>
            @endforeach
        </div>
    </div>


    <div class="our-project">
        <div class=" section-title our-project-title ">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="23" viewBox="0 0 18 23" fill="none">
                <path
                    d="M17.5079 16.0587C17.8984 15.6681 17.8984 15.035 17.5079 14.6445L11.1439 8.28049C10.7534 7.88997 10.1202 7.88997 9.72971 8.28049C9.33919 8.67102 9.33919 9.30418 9.72971 9.69471L15.3866 15.3516L9.72971 21.0084C9.33919 21.3989 9.33919 22.0321 9.72971 22.4226C10.1202 22.8132 10.7534 22.8132 11.1439 22.4226L17.5079 16.0587ZM0.800781 0.351562V10.3516H2.80078V0.351562H0.800781ZM6.80078 16.3516H16.8008V14.3516H6.80078V16.3516ZM0.800781 10.3516C0.800781 13.6653 3.48707 16.3516 6.80078 16.3516V14.3516C4.59164 14.3516 2.80078 12.5607 2.80078 10.3516H0.800781Z"
                    fill="black" />
            </svg>
            <h3>
                {{ __('label.backstage') }}
            </h3>
        </div>
        <div class="description-title">
            <span>“{{ __('label.slogan_backstage') }}”</span>
        </div>

        <div class="our-project-content">
            @foreach ($works as $item)
            <article class="js-open-video-overlay card" data-film='@json($item)'>
                <div class="card-header">
                    <a href="##">
                        <img src="{{ $item->img_url }}" alt="{{ $item->title }}">
                    </a>
                </div>
                <div class="card-body">
                    <a href="##" class="card-title">
                        {!! $item->name !!}
                    </a>
                </div>
            </article>
            @endforeach
        </div>
    </div>
</div>
@include('frontend.film.video_overlay')
<!-- end main -->
@endsection

@section('script')
<script>
    /* our service accordion */
    $(document).ready(function() {
        function handleAccordion() {
            if (window.innerWidth > 800) {
                $('.accordion-heading').off('click');
            } else {
                $('.accordion-heading').off('click').on('click', function() {
                    let currentAcc = $(this).parent('.accordion').hasClass('open');
                    $('.accordion-panel').not($(this)).parent('.accordion').removeClass('open');
                    $('.accordion-panel').not($(this).next('.accordion-panel')).slideUp('fast');

                    currentAcc ? $(this).parent('.accordion').removeClass('open') : $(this)
                        .parent('.accordion')
                        .addClass('open')
                    $(this).next('.accordion-panel').slideToggle('fast');
                });
            }
        }

        handleAccordion();
        window.addEventListener('resize', handleAccordion);
    });

    /* end our service accordion */
</script>
@endsection