<div class="watch-video-overlay">
    <div class="overlay-close-btn">
        <svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 50 50" fill="none">
            <path d="M2.125 2.66821L47.125 47.6682" stroke="white" stroke-width="4" stroke-linecap="round" />
            <path d="M47.125 2.66823L2.125 47.6682" stroke="white" stroke-width="4" stroke-linecap="round" />
        </svg>
    </div>
    <div class="overlay-container">
        <div class="overlay-content">
            <div class="video">
                <div class="video-frame" style="width:100%">
                </div>
            </div>
            <div class="video-detail">
                <div>
                    <div>
                        <h2 class="title name" id="js-name">Cho con một vé về
                            tuổi thơ - Generali Vietnam</h2>
                    </div>
                    <div>
                        <span class="date" id="js-date">Jun14,2023</span>
                    </div>
                </div>
                <div class="detail-list">
                    <div class="list-item">
                        <div>Category:</div>
                        <div id="js-category_name">Branded Short Filma</div>
                    </div>
                    <div class="list-item">
                        <div>Client:</div>
                        <div id="js-brand_name">Generali</div>
                    </div>
                    <div class="list-item">
                        <div>Director:</div>
                        <div id="js-director">Chung Chí Công</div>
                    </div>
                    <div class="list-item">
                        <div>Scope of Work:</div>
                        <div id="js-work_scope">Production Studio</div>
                    </div>
                    <div class="list-item">
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="33" viewBox="0 0 40 33"
                                fill="none">
                                <path
                                    d="M31.1145 18.1797C31.1145 21.2014 28.6621 23.6538 25.6404 23.6538C22.6187 23.6538 20.1663 21.2014 20.1663 18.1797C20.1663 15.158 22.6187 12.7057 25.6404 12.7057C28.6621 12.7057 31.1145 15.158 31.1145 18.1797ZM25.6404 14.8953C23.8303 14.8953 22.3559 16.3696 22.3559 18.1797C22.3559 19.9898 23.8303 21.4642 25.6404 21.4642C27.4505 21.4642 28.9248 19.9898 28.9248 18.1797C28.9248 16.3696 27.4505 14.8953 25.6404 14.8953Z"
                                    fill="white" />
                                <path
                                    d="M15.6391 16.6762C16.9091 17.2455 17.7995 18.5155 17.7995 20.0044C17.7995 22.0189 16.1646 23.6538 14.1501 23.6538C12.6758 23.6538 11.4058 22.778 10.8219 21.5226L12.7488 20.4132C12.9239 21.0117 13.4786 21.4642 14.1501 21.4642C14.953 21.4642 15.6099 20.8073 15.6099 20.0044C15.6099 19.2016 14.953 18.5447 14.1501 18.5447H11.7707L14.1939 14.8953H11.435V12.7057H18.2666L15.6391 16.6762Z"
                                    fill="white" />
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M0.785156 11.1157C0.785156 5.24155 5.56682 0.479614 11.4653 0.479614H28.4236C34.3221 0.479614 39.1038 5.24155 39.1038 11.1157V21.7757C39.1038 27.6499 34.3221 32.4118 28.4236 32.4118H11.4653C5.56682 32.4118 0.785156 27.6499 0.785156 21.7757V11.1157ZM11.4653 2.70744C6.80231 2.70744 3.02221 6.47194 3.02221 11.1157V21.7757C3.02221 26.4195 6.80231 30.184 11.4653 30.184H28.4236C33.0866 30.184 36.8667 26.4195 36.8667 21.7757V11.1157C36.8667 6.47194 33.0866 2.70744 28.4236 2.70744H11.4653Z"
                                    fill="white" />
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M10.821 6.63796C10.821 6.26005 11.2279 5.9537 11.7298 5.9537H28.6153C29.1172 5.9537 29.5241 6.26005 29.5241 6.63796C29.5241 7.01587 29.1172 7.32222 28.6153 7.32222H11.7298C11.2279 7.32222 10.821 7.01587 10.821 6.63796Z"
                                    fill="white" />
                            </svg>
                        </div>
                        <div>
                            Copyright © All Rights Reserved
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="video-content">
            <div id="js-content"></div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $(".js-open-video-overlay").on("click", function($e) {
            let filmData = $(this).data('film')
            if (filmData?.link) {
                // let videoId = filmData.link.split('v=')[1].split('&')[0];
                const embedUrl = embedVideo(filmData.link, filmData.link_type);
                $('.video-frame').html(embedUrl)

                let fields = [
                    'name',
                    'date',
                    'category_name',
                    'brand_name',
                    'director',
                    'work_scope',
                    'content',
                ]

                fields.map(item => {
                    let data = filmData?.[item]
                    if (data && data != 'null') {
                        $('#js-' + item).html(data).parent().show();
                    } else {
                        $('#js-' + item).parent().hide();
                    }
                })

                $(".watch-video-overlay").toggle('fast')
            }
        })
        $(".overlay-close-btn").on("click", function($e) {
            $('.video-frame').html("")
            $(".watch-video-overlay").toggle('fast')
        })
    });

    function embedVideo(link, type) {
        let videoId;
        let embedUrl;
        if (type == '2') {
            // Extract the Vimeo video ID from the URL
            console.log('link');
            console.log(link);
            videoId = link.split('com/')[1];
            console.log('videoId');
            console.log(videoId);
            
            videoId = videoId.includes('?') ? videoId.split('?')[0] : videoId;
            // Create the Vimeo embed URL
            embedUrl = `
            <iframe width="100%" height="100%" src="https://player.vimeo.com/video/${videoId}?autoplay=1&muted=1"
                title="Vimeo video player" frameborder="0"
                allow="autoplay; fullscreen; picture-in-picture"
                referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
            `;
        } else {
            // Extract the YouTube video ID from the URL
            videoId = link.split('v=')[1].split('&')[0];
            console.log(link);
            
            // Create the YouTube embed URL
            embedUrl = `
            <iframe width="100%" height="100%" src="https://www.youtube.com/embed/${videoId}?autoplay=1&muted=1"
                title="YouTube video player" frameborder="0"
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
            `;
        }

        // Return the embed code
        return embedUrl;
    }
</script>
