@extends('layouts.fe_master')

@php
    $title = "Kiet Nguyen TV - ADVERTISING TVC";
    $description =  $category->name;
    $ogTitle = $title;
    $ogDescription = $description;
    $ogImage = url($category->banner_url);
    $twitterTitle = $title;
    $twitterDescription = $description;
    $artistName = "Kiet Nguyen TV";
    $schemaDescription = $description;
@endphp

@section('content')
    <div class="header-padding"></div>
    <!-- main -->
    <div class="main">
        <div class="film-maker-category">

            @include('frontend.film.advertising.header')

            @if ($category->banner_url)
                <div class="film-maker-category-content">
                    <article class="card card-col-4">
                        <div class="card-header">
                            <img src="{{ $category->banner_url }}" alt="film-maker-category-1" />
                        </div>
                        <div class="card-body">
                            <div class="card-title">
                                <h1>{{ $category->name }}</h1>
                            </div>
                        </div>
                    </article>
                </div>
            @endif

            <div class="film-maker-category-grid">
                <div class="film-maker-category-grid-content">
                    @foreach ($films as $key => $item)
                        <article class="js-open-video-overlay card card-col-4" data-film='@json($item)'>
                            <div class="card-header">
                                <a href="##">
                                    <img src="{{ $item->img_url }}" />
                                </a>
                            </div>
                            <div class="card-body">
                                <div class="card-date"> {{ $item->release_date }}</div>
                                <a href="##" class="card-title">
                                    {!! $item->name !!}
                                </a>
                            </div>
                        </article>
                    @endforeach
                </div>
                
               {{--  <div class="film-maker-category-grid-btn mobile-d-none">
                    <p>Strategy Expland</p>
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"
                        fill="none">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M16.5202 0.345675C17.0725 0.345689 17.5202 0.793415 17.5202 1.3457L17.52 10.3457C17.52 10.898 17.0722 11.3457 16.5199 11.3457C15.9677 11.3457 15.52 10.8979 15.52 10.3457L15.5201 3.75986L2.18707 17.0923C1.79654 17.4828 1.16337 17.4828 0.772857 17.0922C0.382342 16.7017 0.382357 16.0686 0.772891 15.678L14.106 2.34562L7.52016 2.34546C6.96788 2.34545 6.52017 1.89772 6.52019 1.34543C6.5202 0.79315 6.96793 0.345446 7.52021 0.345459L16.5202 0.345675Z"
                            fill="black" />
                    </svg>
                </div> --}}
            </div>

        </div>

    </div>
    <!-- end main -->


    @include('frontend.film.video_overlay')
@endsection
