@extends('layouts.fe_master')

@php
    $title = "Kiet Nguyen TV - ADVERTISING BRANDED SHORT FILM";
    $description =  $category->name;
    $ogTitle = $title;
    $ogDescription = $description;
    $ogImage = url($category->banner_url);
    $twitterTitle = $title;
    $twitterDescription = $description;
    $artistName = "Kiet Nguyen TV";
    $schemaDescription = $description;
@endphp

@section('content')
    <div class="header-padding"></div>
    <!-- main -->
    <div class="main">
        <div class="film-maker-category">

            @include('frontend.film.advertising.header')

            @if ($category->banner_url)
                <div class="film-maker-category-content">
                    <article class="card card-col-4">
                        <div class="card-header">
                            <img src="{{ $category->banner_url }}" class="mobile-d-none" alt="film-maker-category-1" />
                            <img src="{{ $category->mobile_banner_url }}" class="mobile-d-block d-none"
                                alt="film-maker-category-1" />
                        </div>
                        <div class="card-body">
                            <div class="card-title">
                                <h1>{{ $category->name }}</h1>
                            </div>
                        </div>
                    </article>
                </div>
            @endif

            @foreach ($brandFilms as $key => $films)
                @if ($key && $key == 'Generali Vietnam')
                    <div class="film-maker-category-grid">

                        <div class="section-title film-maker-category-grid-title">
                            <h3>{{ $key }}</h3>
                        </div>
                        <div class="film-maker-category-grid-content">
                            @foreach ($films as $key => $item)
                                <article class="js-open-video-overlay card card-col-4"
                                    data-film='@json($item)'>
                                    <div class="card-header position-relative">
                                        <a href="##">
                                            <img src="{{ $item->img_url }}" />
                                        </a>
                                        <div class="play-btn-custome-detail">
                                            <img src="{{ asset('/assets') }}/media/images/svg/play-btn.svg" />
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="card-date"> {{ $item->release_date }}</div>
                                        <a href="##" class="card-title">
                                            {!! $item->name !!}
                                        </a>
                                    </div>
                                </article>
                            @endforeach
                        </div>


                    </div>
                @endif
            @endforeach

            @foreach ($brandFilms as $key => $films)
                @if ($key && $key == 'Ensure Gold Vietnam')
                    <div class="film-maker-category-grid">

                        <div class="section-title film-maker-category-grid-title">
                            <h3>{{ $key }}</h3>
                        </div>
                        <div class="film-maker-category-grid-content">
                            @foreach ($films as $key => $item)
                                <article class="js-open-video-overlay card card-col-4"
                                    data-film='@json($item)'>
                                    <div class="card-header position-relative">
                                        <a href="##">
                                            <img src="{{ $item->img_url }}" />
                                        </a>
                                        <div class="play-btn-custome-detail">
                                            <img src="{{ asset('/assets') }}/media/images/svg/play-btn.svg" />
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="card-date"> {{ $item->release_date }}</div>
                                        <a href="##" class="card-title">
                                            {!! $item->name !!}
                                        </a>
                                    </div>
                                </article>
                            @endforeach
                        </div>


                    </div>
                @endif
            @endforeach

            @foreach ($brandFilms as $key => $films)
                @if ($key && $key == 'Eco Park')
                    <div class="film-maker-category-grid">

                        <div class="section-title film-maker-category-grid-title">
                            <h3>{{ $key }}</h3>
                        </div>
                        <div class="film-maker-category-grid-content">
                            @foreach ($films as $key => $item)
                                <article class="js-open-video-overlay card card-col-4"
                                    data-film='@json($item)'>
                                    <div class="card-header position-relative">
                                        <a href="##">
                                            <img src="{{ $item->img_url }}" />
                                        </a>
                                        <div class="play-btn-custome-detail">
                                            <img src="{{ asset('/assets') }}/media/images/svg/play-btn.svg" />
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="card-date"> {{ $item->release_date }}</div>
                                        <a href="##" class="card-title">
                                            {!! $item->name !!}
                                        </a>
                                    </div>
                                </article>
                            @endforeach
                        </div>


                    </div>
                @endif
            @endforeach

            @foreach ($brandFilms as $key => $films)
                @if (!$key)
                    <div class="film-maker-category-grid">

                        <div class="section-title film-maker-category-grid-title">
                            <h3>More Product</h3>
                        </div>
                        <div class="film-maker-category-grid-content">
                            @foreach ($films as $key => $item)
                                <article class="js-open-video-overlay card card-col-4"
                                    data-film='@json($item)'>
                                    <div class="card-header position-relative">
                                        <a href="##">
                                            <img src="{{ $item->img_url }}" />
                                        </a>
                                        <div class="play-btn-custome-detail">
                                            <img src="{{ asset('/assets') }}/media/images/svg/play-btn.svg" />
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="card-date"> {{ $item->release_date }}</div>
                                        <a href="##" class="card-title">
                                            {!! $item->name !!}
                                        </a>
                                    </div>
                                </article>
                            @endforeach
                        </div>


                    </div>
                @endif
            @endforeach

        </div>

    </div>
    <!-- end main -->


    @include('frontend.film.video_overlay')
@endsection
