@extends('layouts.fe_master')

@php
    $title = "Kiet Nguyen TV - FEATURES FILM";
    $description =  $film->content;
    $ogTitle = $title;
    $ogDescription = $description;
    $ogImage = url($film->feature_banner_url);
    $twitterTitle = $title;
    $twitterDescription = $description;
    $artistName = "Kiet Nguyen TV";
    $schemaDescription = $description;
@endphp

@section('content')
<div class="header-padding"></div>
<div class="main">
    <div class="feature-film">
        <div class="film-maker-mobile-category d-none mobile-d-flex">
            <div class="item item-menu-btn item-head">
                <h2>Features Film</h2>
                <span>
                    Category
                    <svg xmlns="http://www.w3.org/2000/svg" width="8" height="6" viewBox="0 0 8 6"
                        fill="none">
                        <path d="M0.605469 0.871094L3.80268 4.06817L6.99976 0.871094" stroke="black"
                            stroke-opacity="0.3" stroke-width="1.5" />
                    </svg>
                </span>
            </div>

            <div class="film-maker-mobile-category-menu">
                @foreach ($films as $item)
                    <div href="##" class="item">
                        <a href="/feature-film/{{ $item->id }}">{!! $item->name !!}</a>
                    </div>
                @endforeach
            </div>

        </div>
        <div class="feature-film-title mobile-d-none">
            <h2>Features Film</h2>
            <div class="tags">
                @foreach ($films as $item)
                <a href="/feature-film/{{ $item->id }}" class="tag {{ $item->id == $film->id ? 'active' : '' }}">
                    {!! $item->name !!}
                </a>
                @endforeach
            </div>
        </div>
        <div class="feature-film-content">
            <div class="feature-film-banner">
                <article class="card card-col-4 js-open-video-overlay" data-film='@json($film)'>
                    <div class="card-header">
                        <img src="{{ asset($film->feature_banner_url) }}" class=""
                            alt="{{ $film->name }}" />
                    </div>
                    <div class="card-body">
                        <div class="play-btn">
                            <img src="{{ asset('/') }}assets/media/images/svg/play-btn.svg" />
                        </div>
                    </div>
                </article>
            </div>

            <div class="feature-film-content-title">
                <h2>{!! $film->name !!}</h2>
                <ul class="feature-film-content-title-list">
                    <li class="list-item item-mobile-order-1">
                        <strong>Director</strong>
                        <span>{{ $film->director }}</span>
                    </li>
                    <li class="list-item item-mobile-order-4">
                        <strong>Scope of Work</strong>
                        <span>{{ $film->work_scope }}</span>
                    </li>
                    <li class="list-item item-mobile-order-3 d-none mobile-d-flex">
                        <strong>Writers</strong>
                        <span>{{ $film->writer }}</span>
                    </li>
                    <li class="list-item item-mobile-order-5">
                        <strong>Starring</strong>
                        <span>{{ $film->starring }}</span>
                    </li>
                    <li class="list-item item-mobile-order-2">
                        <strong>Release</strong>
                        <span>{{ $film->release_date }}</span>
                    </li>
                </ul>
            </div>

            <div class="feature-film-content-description">
                <h3 class="heading-3"> Description</h3>
                <p>
                    {!! $film->content !!}
                </p>
                {{-- <p class="description-content">
                        Ha, a young Vietnamese woman, comes to Higashikawa, a small town in Japan to find her
                        father. She meets Akira, a Japanese photographer, and finds out that her father has passed
                        away years ago. They gradually form an unlikely bond through the language of 35mm film
                        photography. She asks Akira to take her to her father’s favorite places in town not knowing
                        that he’s hiding a secret from her. What will become of their accidental romance?
                    </p> --}}
            </div>

            <div class="feature-film-content-film-award">
                <h3 class="heading-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="23" viewBox="0 0 18 23"
                        fill="none">
                        <path
                            d="M17.2071 16.2071C17.5976 15.8166 17.5976 15.1834 17.2071 14.7929L10.8431 8.42893C10.4526 8.03841 9.81946 8.03841 9.42893 8.42893C9.03841 8.81946 9.03841 9.45262 9.42893 9.84315L15.0858 15.5L9.42893 21.1569C9.03841 21.5474 9.03841 22.1805 9.42893 22.5711C9.81946 22.9616 10.4526 22.9616 10.8431 22.5711L17.2071 16.2071ZM0.5 0.5L0.5 10.5H2.5L2.5 0.5L0.5 0.5ZM6.5 16.5H16.5V14.5L6.5 14.5V16.5ZM0.5 10.5C0.5 13.8137 3.18629 16.5 6.5 16.5V14.5C4.29086 14.5 2.5 12.7091 2.5 10.5H0.5Z"
                            fill="black" />
                    </svg>
                    Film Award
                </h3>
                <div class="row">
                    <div class="col col-1">
                        <img src="{{ asset($film->film_award_1) }}" alt="film_award_1">
                    </div>
                    <div class="col col-2">
                        <div class="text-spotlight">
                            <img src="{{ asset($film->film_award_2) }}" alt="film_award_2">
                            {{-- <span>
                                    Spotlight Award 2018
                                </span> --}}
                        </div>
                        {{-- <div class="text-spotlight-content">
                                <span>
                                    Vietnam’s Phuong Anh Dao wins the Best Actress
                                    title at the fifth
                                    Hanoi International Film Festival (HANIFF)
                                    in the Vietnamese capital
                                    on October 31, 2018.
                                    Photo: Tuoi Tre
                                </span>
                            </div> --}}
                    </div>
                    <div class="col col-3 description-film">
                        {!! $film->film_award_3 !!}
                        {{-- <div>
                                <strong>
                                    Best Leading Actress
                                </strong>
                                <span>
                                    Hanoi International Film Festival 2018
                                </span>
                            </div>
                            <div>
                                <strong>Spotlight Award</strong>
                                <span>Viet Film Fest 2018</span>
                            </div> --}}
                    </div>
                </div>
            </div>

            <div class="feature-film-content-film-trailer-stream">
                <div class="col col-1">
                    <h3>Trailer & Streaming Film</h3>
                    <div class="icon-wrapper">
                        <a href="{{ asset($film->vimeo) }}">
                            <img src="{{ asset('/') }}assets/media/images/pages/feature-film/social-media-dark-1.png"
                                class="social-media social-media-1" alt="social-media-1" />
                        </a>
                        <a href="{{ asset($film->youtube) }}">
                            <img src="{{ asset('/') }}assets/media/images/pages/feature-film/social-media-dark-2.png"
                                class="social-media social-media-2" alt="social-media-2" />
                        </a>
                        <a href="{{ asset($film->netflix) }}">
                            <img src="{{ asset('/') }}assets/media/images/pages/feature-film/social-media-dark-3.png"
                                class="social-media social-media-3" alt="social-media-3" />
                        </a>
                    </div>
                </div>
                <div class="col col-2">
                    <h3>OST Album Playist</h3>
                    <div class="icon-wrapper">
                        <span>Playing Now on Spotify!</span>
                        <a href="{{ $film->spotify }}">
                            <img src="{{ asset('/') }}assets/media/images/pages/feature-film/spotify-dark.png"
                                style="width: 40px; object-fit:contain" alt="" class="icon-spotify"
                                width="40" height="40">
                        </a>
                        <a href="{{ asset($film->tiktok) }}">
                            <img src="{{ asset('/') }}assets/media/images/pages/feature-film/tiktok-dark.png"
                                style="width: 40px; object-fit:contain" alt="" class="icon-tiktok"
                                width="40" height="40">
                        </a>
                    </div>
                </div>
            </div>

            <div class="feature-film-content-comunication">
                <h3 class="heading-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="23" viewBox="0 0 18 23"
                        fill="none">
                        <path
                            d="M17.2071 16.2071C17.5976 15.8166 17.5976 15.1834 17.2071 14.7929L10.8431 8.42893C10.4526 8.03841 9.81946 8.03841 9.42893 8.42893C9.03841 8.81946 9.03841 9.45262 9.42893 9.84315L15.0858 15.5L9.42893 21.1569C9.03841 21.5474 9.03841 22.1805 9.42893 22.5711C9.81946 22.9616 10.4526 22.9616 10.8431 22.5711L17.2071 16.2071ZM0.5 0.5L0.5 10.5H2.5L2.5 0.5L0.5 0.5ZM6.5 16.5H16.5V14.5L6.5 14.5V16.5ZM0.5 10.5C0.5 13.8137 3.18629 16.5 6.5 16.5V14.5C4.29086 14.5 2.5 12.7091 2.5 10.5H0.5Z"
                            fill="black" />
                    </svg>
                    Communication
                </h3>
                <div class="comunication-content">
                    <div class="img-wrapper">
                        <img src="{{ asset($film->communication_1) }}" class="comunication-img" alt="comunication-1" />
                    </div>
                    <div class="img-wrapper">
                        <img src="{{ asset($film->communication_2) }}" class="comunication-img" alt="comunication-2" />
                    </div>
                    <div class="img-wrapper">
                        <img src="{{ asset($film->communication_3) }}" class="comunication-img" alt="comunication-3" />
                    </div>
                </div>
            </div>

            <div class="feature-film-content-facebook-fanpage">
                <h3 class="heading-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="23" viewBox="0 0 18 23"
                        fill="none">
                        <path
                            d="M17.2071 16.2071C17.5976 15.8166 17.5976 15.1834 17.2071 14.7929L10.8431 8.42893C10.4526 8.03841 9.81946 8.03841 9.42893 8.42893C9.03841 8.81946 9.03841 9.45262 9.42893 9.84315L15.0858 15.5L9.42893 21.1569C9.03841 21.5474 9.03841 22.1805 9.42893 22.5711C9.81946 22.9616 10.4526 22.9616 10.8431 22.5711L17.2071 16.2071ZM0.5 0.5L0.5 10.5H2.5L2.5 0.5L0.5 0.5ZM6.5 16.5H16.5V14.5L6.5 14.5V16.5ZM0.5 10.5C0.5 13.8137 3.18629 16.5 6.5 16.5V14.5C4.29086 14.5 2.5 12.7091 2.5 10.5H0.5Z"
                            fill="black" />
                    </svg>
                    Facebook Fanpage
                </h3>
                <div class="fanpage-content">
                    <div class="col col-1">
                        <a href="{{ $film->facebook_fanpage_link }}">
                            <img src="{{ asset($film->facebook_fanpage_image) }}" class="fanpage-img"
                                alt="fanpage-3" /></a>
                    </div>
                </div>
            </div>
            {{--
                <div class="feature-film-btn scroll-back-btn d-none mobile-d-flex">
                    <p>Scroll Back</p>
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"
                        fill="none">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M16.5202 0.345675C17.0725 0.345689 17.5202 0.793415 17.5202 1.3457L17.52 10.3457C17.52 10.898 17.0722 11.3457 16.5199 11.3457C15.9677 11.3457 15.52 10.8979 15.52 10.3457L15.5201 3.75986L2.18707 17.0923C1.79654 17.4828 1.16337 17.4828 0.772857 17.0922C0.382342 16.7017 0.382357 16.0686 0.772891 15.678L14.106 2.34562L7.52016 2.34546C6.96788 2.34545 6.52017 1.89772 6.52019 1.34543C6.5202 0.79315 6.96793 0.345446 7.52021 0.345459L16.5202 0.345675Z"
                            fill="black"></path>
                    </svg>
                </div> --}}

            {{-- <a href="" class="feature-film-btn mobile-d-none">
                    <p>Trời Sáng Rồi, Ta Ngủ Đi Thôi</p>
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"
                        fill="none">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M16.5202 0.345675C17.0725 0.345689 17.5202 0.793415 17.5202 1.3457L17.52 10.3457C17.52 10.898 17.0722 11.3457 16.5199 11.3457C15.9677 11.3457 15.52 10.8979 15.52 10.3457L15.5201 3.75986L2.18707 17.0923C1.79654 17.4828 1.16337 17.4828 0.772857 17.0922C0.382342 16.7017 0.382357 16.0686 0.772891 15.678L14.106 2.34562L7.52016 2.34546C6.96788 2.34545 6.52017 1.89772 6.52019 1.34543C6.5202 0.79315 6.96793 0.345446 7.52021 0.345459L16.5202 0.345675Z"
                            fill="black"></path>
                    </svg>
                </a> --}}

        </div>
    </div>
</div>
@include('frontend.film.video_overlay')
@endsection