@extends('layouts.master')

@section('title', 'term')

@section('content')
    <div class="container-fluid fixed-screen-container" id="App">
        <form action="{{ route('view.term.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Page Header -->
            <div class="d-flex flex-wrap justify-content-between gap-4 my-4 page-header-breadcrumb">
                <div class="my-auto d-flex align-items-start">
                    <h4 class="mb-0">Chỉnh Sửa Trang Terms & Conditions</h4>

                </div>
                {{--  <div class="d-flex align-items-center">
                    <h4 class="d-inline-flex gap-2 me-3 align-items-center">
                        <a href="{{ route('view.term.detail', ['lang' => 'vi']) }}"
                            class="{{ $page->lang == 'vi' ? 'fw-bold' : '' }} link">
                            Tiếng Việt
                        </a>/
                        <a href="{{ route('view.term.detail', ['lang' => 'en']) }}"
                            class="{{ $page->lang == 'en' ? 'fw-bold' : '' }} link">
                            Tiếng Anh
                        </a>
                    </h4>
                </div> --}}
                <button class="btn btn-primary btn-submit" type="submit">Lưu</button>
            </div>
            <!-- End Page Header -->
            <div class="card bg-white position-relative table-wrapper p-3">
                {{--   <h4 class="mb-2 text-capitalize">Banner</h4>
                <div class="separator mb-3"></div> --}}
                <div class="row">
                    <div class="col-sm-12 mb-3">
                        <label for="title" class="form-label text-capitalize">title</label>
                        <input type="text" :class="[{ 'validate-error--input': validateErrors.title }, 'form-control']"
                            v-model="createObj.title" name="title" />

                        <div class="validate-error--text text-danger" v-if="validateErrors.title"
                            v-for="err in validateErrors.title">
                            <small>
                                (( err ))
                            </small>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-3">
                        <label for="version" class="form-label text-capitalize">Version</label>
                        <input type="text" :class="[{ 'validate-error--input': validateErrors.version }, 'form-control']"
                            v-model="createObj.version" name="version" />

                        <div class="validate-error--text text-danger" v-if="validateErrors.version"
                            v-for="err in validateErrors.version">
                            <small>
                                (( err ))
                            </small>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-3">
                        <label for="date" class="form-label text-capitalize">Ngày</label>
                        <input type="text" :class="[{ 'validate-error--input': validateErrors.date }, 'form-control']"
                            v-model="createObj.date" name="date" />

                        <div class="validate-error--text text-danger" v-if="validateErrors.date"
                            v-for="err in validateErrors.date">
                            <small>
                                (( err ))
                            </small>
                        </div>
                    </div>

                    <div class="col-md-12 mb-3">
                        <div class="mb-3">
                            <label for="content" class="mb-2 text-capitalize">
                                Tiêu đề trang
                            </label>
                            <ckeditor v-model="createObj.content" name="content">
                            </ckeditor>
                        </div>
                    </div>
                </div>
            </div>


        </form>
        <!-- Button to trigger File Manager -->


    </div>

@endsection

@section('script-footer')

    <!-- Chartjs Chart JS -->
    <!-- <script src="{{ asset('assets/js/index.js') }}"></script> -->

    <script src="{{ asset('assets/js/prism-custom.js') }}"></script>

    <script src="{{ asset('assets/js/custom-switcher.min.js') }}"></script>
    <!-- Custom JS -->
    <script src="{{ asset('assets/js/custom.js') }}"></script>
    <script src="{{ asset('assets/js/csrf.js') }}"></script>

    <script>
        $(document).ready(function() {
            $('.lfm').filemanager('image');
        });
    </script>

    <script type="text/javascript">
        var options = {
            maxNotifications: 5,
            durations: {
                alert: 0,
                warning: 0,
                success: 0,
            },
            labels: {
                alert: '',
                warning: '',
                success: '',
            },
            icons: {
                enabled: false
            },
        }
        var notifier = new AWN(options);
    </script>


    <script>
        const EventBus = new Vue()

        new Vue({
            el: '#App',
            data: {
                sortDirection: 'desc',
                sortBy: '',
                count: 0, //total page
                page: 1, //pagination: curent page
                perPage: 10, // pagination: records per page
                total: 0, //pagination: total records
                pageRange: 3, // pagination:controls nearby page display. currenpage counted
                from: 1,
                to: 10,
                list: [],
                conditionSearch: '',
                search: '',
                airport_date_to: '',
                airport_date_from: '',
                return_date_to: '',
                return_date_from: '',
                filterObj: {},
                showClearSearch: false,
                putMethod: false,
                selectedObject: {},
                createObj: @json($page),
                listPage: [],
                showCount: 10,
                selected: [],
                previewUrl: "{{ asset('assets/images/multi-user.jpg') }}",
                validateErrors: {},
                createLoading: false,
                viewType: 'list',
                loading: false,
                loadCustomerStaff: false,

            },
            created() {

            },
            delimiters: ["((", "))"],
            mounted() {
                console.log(this.createObj);

            },
            computed: {

            },
            methods: {

            },
        });
    </script>

    @if ($errors->any())
        <script>
            let alertMessage = `
            @foreach ($errors->all() as $error)
            <br>
                {{ $error }}
            @endforeach
            `
            notifier.alert(alertMessage);
        </script>
    @endif

    @if (session('error'))
        <script>
            notifier.alert(`{{ session('error') }}`);
        </script>
    @endif

    @if (session('success'))
        <script>
            notifier.success(`{{ session('success') }}`);
        </script>
    @endif

@endsection
