<template id="award_template">
    <div>
        <div class="card bg-white position-relative table-wrapper p-3 ">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="mb-0 text-capitalize fs-18 d-flex align-items-center gap-2">
                    <span>
                        Tiêu Đề:
                    </span>
                    <input type="text" name="award_title" value="{{ $award_title }}"
                        class="form-control-sm d-inline-block  border">
                </h3>
                <div class="btn bg-white text-black border mb-2 rounded-2" @click="addItem">
                    + Thêm
                </div>
            </div>
            <div class="separator mb-3"></div>
            <template v-for="(item, key) in awards" :key="key">
                <div class="mb-2 d-flex align-items-center gap-3">
                    <strong>#(( key*1 + 1))</strong>

                    <div class="action-btn rounded-2" @click="deleteItem(item,key)">
                        @include('icons.trash')
                    </div>
                </div>
                <div class="row border py-3 mx-0 rounded-3 mb-4">
                    <div class="col-md-6 mb-3">
                        <div class="mb-3">
                            <label for="banner" class="mb-2 text-capitalize">hình ảnh</label>
                            <image-selector v-model="item.img_url"
                                :name="`award_data[${key}][img_url]`"></image-selector>
                        </div>
                        <div>
                            <label class="mb-2 text-capitalize">Thứ tự</label>
                            <input :name="`award_data[${key}][order]`" class="form-control" type="number"
                                v-model="item.order" />
                        </div>
                    </div>
                    <div class="col-md-6 d-flex">
                        <img :src="((item.img_url))" alt="" class="m-auto">
                    </div>
                    <div class="col-md-12">
                        <label class="mb-2 text-capitalize">Nội dung</label>
                        <ckeditor v-model="item.content" :name="`award_data[${key}][content]`"></ckeditor>
                    </div>
                </div>
            </template>
        </div>
    </div>
</template>

<script>
    Vue.component('award_template', {
        template: "#award_template",
        delimiters: ["((", "))"],
        data() {
            return {
                selectedImage: 'dsa',
                awards: [{}],
                createObj: [],
            }
        },
        mounted() {
            let awrd = @json($awards);
            if (@json($awards)) {
                this.awards = JSON.parse(JSON.stringify(awrd));
            } else {
                this.awards = JSON.parse(JSON.stringify([{}]));
            }
            console.log(this.awards);
        },
        methods: {
            openFileManager() {
                window.open('/laravel-filemanager?type=image', 'FileManager', 'width=900,height=600');
                window.SetUrl = this.setImageUrl;
            },
            setImageUrl(url) {
                this.$emit('input', url);
            },
            addItem() {
                this.awards.push({})
            },
            async deleteItem(item, key) {
                const result = await Swal.fire({
                    title: "Xóa item này?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#dc3545',
                    cancelButtonColor: '#ffffff',
                    confirmButtonText: "Xóa",
                    cancelButtonText: "Hủy"
                });
                if (result.isConfirmed) {
                    this.awards.splice(key, 1)
                }
            }
        }

    })
</script>
