@extends('layouts.master')

@section('title', 'home')

@section('content')
<div class="container-fluid fixed-screen-container" id="App">
    <form action="{{ route('view.setting.edit') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <!-- Page Header -->
        <div class="d-flex flex-wrap justify-content-between gap-4 my-4 page-header-breadcrumb">
            <div class="my-auto">
                <h4 class="mb-0">Thiết Lập Pages</h4>
            </div>

            <div class=" text-end">
                <button type="submit" class="btn text-black bg-white border rounded-3 text-nowrap">
                    Cập nhật
                </button>
            </div>

        </div>
        <!-- End Page Header -->
        <ul class="nav nav-custom nav-tabs bg-white p-2 d-sm-flex d-block mb-3 column-gap-3 rounded-3" role="tablist">
            <li class="nav-item m-0">
                <a class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab_space" aria-current="page"
                    href="#tab_space"> Kích thước / Khoảng cách
                </a>
            </li>
        </ul>

        <div class="tab-content tab-content-custom rounded-3 mt-1 bg-transparent p-0 collapse-all-content">
            <div class="tab-pane active border-0 p-0" id="tab_space" role="tab_space">
                <div class="card bg-white position-relative table-wrapper p-3 ">
                    <div class="row">


                        <div class="col-sm-12 mb-3">
                            <label for="space_in_div" class="form-label">Khoảng trắng bên trong khối</label>
                            <input type="text" :class="[{ 'validate-error--input': validateErrors.space_in_div }, 'form-control']"
                                value="{{ $page->space_in_div }}" name="space_in_div" rows="2" />

                            <div class="validate-error--text text-danger" v-if="validateErrors.space_in_div"
                                v-for="err in validateErrors.space_in_div">
                                <small>
                                    (( err ))
                                </small>
                            </div>
                        </div>

                        <div class="col-sm-12 mb-3">
                            <label for="space_out_div" class="form-label">Khoảng cách bên ngoài khối</label>
                            <input type="text" :class="[{ 'validate-error--input': validateErrors.space_out_div }, 'form-control']"
                                value="{{ $page->space_out_div }}" name="space_out_div" rows="2" />

                            <div class="validate-error--text text-danger" v-if="validateErrors.space_out_div"
                                v-for="err in validateErrors.space_out_div">
                                <small>
                                    (( err ))
                                </small>
                            </div>
                        </div>

                        <div class="col-sm-12 mb-3">
                            <label for="font_size_title" class="form-label">Font size cho tiêu đề</label>
                            <input type="text" :class="[{ 'validate-error--input': validateErrors.font_size_title }, 'form-control']"
                                value="{{ $page->font_size_title }}" name="font_size_title" rows="2" />

                            <div class="validate-error--text text-danger" v-if="validateErrors.font_size_title"
                                v-for="err in validateErrors.font_size_title">
                                <small>
                                    (( err ))
                                </small>
                            </div>
                        </div>

                        <div class="col-sm-12 mb-3">
                            <label for="font_size_description" class="form-label">Font size cho nội dung</label>
                            <input type="text" :class="[{ 'validate-error--input': validateErrors.font_size_description }, 'form-control']"
                                value="{{ $page->font_size_description }}" name="font_size_description" rows="2" />

                            <div class="validate-error--text text-danger" v-if="validateErrors.font_size_description"
                                v-for="err in validateErrors.font_size_description">
                                <small>
                                    (( err ))
                                </small>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </form>
    <!-- Button to trigger File Manager -->


</div>

@endsection

@section('script-footer')

<!-- Chartjs Chart JS -->
<!-- <script src="{{ asset('assets/js/index.js') }}"></script> -->

<script src="{{ asset('assets/js/prism-custom.js') }}"></script>

<script src="{{ asset('assets/js/custom-switcher.min.js') }}"></script>
<!-- Custom JS -->
<script src="{{ asset('assets/js/custom.js') }}"></script>
<script src="{{ asset('assets/js/csrf.js') }}"></script>

<script>
    $(document).ready(function() {
        $('.lfm').filemanager('image');
    });
</script>

<script type="text/javascript">
    var options = {
        maxNotifications: 5,
        durations: {
            alert: 0,
            warning: 0,
            success: 0,
        },
        labels: {
            alert: '',
            warning: '',
            success: '',
        },
        icons: {
            enabled: false
        },
    }
    var notifier = new AWN(options);
</script>

<script>
    const EventBus = new Vue()

    new Vue({
        el: '#App',
        data: {
            sortDirection: 'desc',
            sortBy: '',
            count: 0, //total page
            page: 1, //pagination: curent page
            perPage: 10, // pagination: records per page
            total: 0, //pagination: total records
            pageRange: 3, // pagination:controls nearby page display. currenpage counted
            from: 1,
            to: 10,
            list: [],
            conditionSearch: '',
            search: '',
            airport_date_to: '',
            airport_date_from: '',
            return_date_to: '',
            return_date_from: '',
            filterObj: {},
            showClearSearch: false,
            putMethod: false,
            selectedObject: {},
            createObj: {},
            listPage: [],
            showCount: 10,
            selected: [],
            previewUrl: "{{ asset('assets/images/multi-user.jpg') }}",
            validateErrors: {},
            createLoading: false,
            viewType: 'list',
            loading: false,
            loadCustomerStaff: false,

        },
        created() {

        },
        delimiters: ["((", "))"],
        mounted() {
            const that = this;
        },
        computed: {

        },
        methods: {

        },
    });
</script>

@if ($errors->any())
<script>
    let alertMessage = `
            @foreach ($errors->all() as $error)
            <br>
                {{ $error }}
            @endforeach
            `
    notifier.alert(alertMessage);
</script>
@endif

@if (session('error'))
<script>
    notifier.alert(`{{ session('error') }}`);
</script>
@endif

@if (session('success'))
<script>
    notifier.success(`{{ session('success') }}`);
</script>
@endif

@endsection