@extends('layouts.master')

@section('title', 'home')

@section('content')
    <div class="container-fluid fixed-screen-container" id="App">

        <!-- Page Header -->
        <div class="d-flex flex-wrap justify-content-between gap-4 my-4 page-header-breadcrumb">
            <div class="my-auto">
                <h4 class="mb-0">{{ trans('home.home') }}</h4>
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item"><a href="{{ asset('/admin') }}">{{ trans('common.homepage') }}</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <a href="{{ route('view.home.index') }}">
                                {{ trans('home.home') }}
                            </a>
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="text-end flex-wrap d-flex align-self-start justify-content-end gap-2">
                <a href="javascript:void(0);" class="btn text-black bg-white border rounded-3 text-nowrap"
                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                    <i class="fe fe-download button_icon"></i>{{ trans('label.export') }}
                </a>
                <div class="dropdown-menu rounded-7" data-popper-placement="bottom-start">
                    <a class="dropdown-item" href="javascript:void(0);"><i class="fe fe-share me-2"></i> PDF</a>
                    <a class="dropdown-item" href="javascript:void(0);"><i class="fe fe-share me-2"></i> DOC</a>
                </div>
                <a class="btn text-black bg-white border rounded-3 text-nowrap" data-bs-toggle="modal"
                    @click="resetCreateObj" data-bs-target="#exampleModal">
                    <i class="fe fe-plus button_icon"></i>{{ trans('home.new') }}
                </a>
                {{-- view type --}}
                {{--   <div class=" gino-nav">
                    <div class="gino-nav__item-wrapper">
                        <a :class="[{ 'active': viewType == 'list' },
                            'gino-nav__item text-black text-nowrap'
                        ]"
                            @click="setViewType('list')">
                            <i class="bi bi-list-columns-reverse"></i>
                            {{ trans('label.list') }}
                        </a>
                    </div>
                    <div class="gino-nav__item-wrapper">
                        <a :class="[{ 'active': viewType == 'grid' },
                            'gino-nav__item text-black text-nowrap'
                        ]"
                            @click="setViewType('grid')">
                            <i class="bi bi-kanban"></i>
                            {{ trans('label.grid') }}
                        </a>
                    </div>
                    <div class="gino-nav__item-wrapper">
                        <a :class="[{ 'active': viewType == 'calendar' },
                            'gino-nav__item text-black text-nowrap'
                        ]"
                            @click="setViewType('calendar')">
                            <i class="bi bi-calendar3"></i>
                            {{ trans('label.calendar') }}
                        </a>
                    </div>
                </div> --}}
            </div>
        </div>
        <!-- End Page Header -->



        <div class="text-end flex-wrap d-flex justify-content-end gap-2 mb-4">
            <div class="input-group rounded-3 has-clear-btn-input-group">
                <span class="input-group-text bg-white border-end-0" style="border-color: #ced4da"><i class="ri-search-line"
                        style="color: #878a99"></i></span>
                <input type="text" class="form-control border-start-0  ps-0 pe-3 rounded-end-1 " v-model="search"
                    @keyup="handleSearch" style="z-index:1;border-color: #ced4da;"
                    placeholder="{{ trans('label.search') }}">
                <i class="bi bi-x fs-22 position-absolute clearSearchButton" @click="clearInput" v-if="showClearSearch"></i>
            </div>
            {{-- filter status --}}
            <div>
                <a href="javascript:void(0);" class="btn rounded-3 text-black bg-white border text-nowrap"
                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                    <i class="bi bi-signpost button_icon"></i>{{ trans('label.status') }}
                </a>
                <div class="dropdown-menu dropdown-menu-end rounded-1 border-0 shadow" style="min-width: 300px;"
                    data-popper-placement="bottom-start">
                    @include('admin.home.index.filter_status')
                </div>
            </div>
            {{-- end status --}}
            {{-- search --}}
            <div>
                <a href="javascript:void(0);" class="btn rounded-3 text-black bg-white border text-nowrap"
                    data-bs-toggle="dropdown">
                    <i class="bi bi-funnel button_icon"></i>{{ trans('label.filters') }}
                </a>
                <div class="dropdown-menu dropdown-menu-end rounded-1 border-0 shadow mx-2">
                    @include('admin.home.index.search')
                </div>
            </div>

            {{-- item chi hien thi khi xem table list --}}
            <div v-if="viewType=='list'" class="d-flex gap-2 flex-wrap">
                <a class="btn text-black bg-white border rounded-3 text-nowrap" @click="bulkDelete()">
                    <i class="bi bi-trash-fill"></i> {{ trans('label.bulk_delete') }}
                </a>
            </div>
        </div>

        <div v-if="viewType == 'list'">

            @include('admin.home.index.list')
        </div>

        @include('admin.home.index.add_modal')
    </div>

@endsection

@section('script-footer')

    <!-- Chartjs Chart JS -->
    <!-- <script src="{{ asset('assets/js/index.js') }}"></script> -->

    <script src="{{ asset('assets/js/prism-custom.js') }}"></script>

    <script src="{{ asset('assets/js/custom-switcher.min.js') }}"></script>
    <!-- Custom JS -->
    <script src="{{ asset('assets/js/custom.js') }}"></script>
    <script src="{{ asset('assets/js/csrf.js') }}"></script>
    <script src="//cdn.jsdelivr.net/npm/sortablejs@1.8.4/Sortable.min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/Vue.Draggable/2.20.0/vuedraggable.umd.min.js"></script>
    <link href='https://cdn.jsdelivr.net/npm/fullcalendar@5.8.0/main.min.css' rel='stylesheet' />
    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@5.8.0/main.min.js'></script>

    <script type="text/javascript">
        var options = {
            maxNotifications: 5,
            durations: {
                alert: 0,
                warning: 0,
                success: 0,
            },
            labels: {
                alert: '',
                warning: '',
                success: '',
            },
            icons: {
                enabled: false
            },
        }
        var notifier = new AWN(options);
    </script>

    <script>
        const EventBus = new Vue()

        new Vue({
            el: '#App',
            data: {
                sortDirection: 'desc',
                sortBy: '',
                count: 0, //total page
                page: 1, //pagination: curent page
                perPage: 10, // pagination: records per page
                total: 0, //pagination: total records
                pageRange: 3, // pagination:controls nearby page display. currenpage counted
                from: 1,
                to: 10,
                list: [],
                conditionSearch: '',
                search: '',
                airport_date_to: '',
                airport_date_from: '',
                return_date_to: '',
                return_date_from: '',
                filterObj: {},
                showClearSearch: false,
                putMethod: false,
                selectedObject: {},
                createObj: {},
                listPage: [],
                showCount: 10,
                selected: [],
                previewUrl: "{{ asset('assets/images/multi-user.jpg') }}",
                validateErrors: {},
                createLoading: false,
                viewType: 'list',
                loading: false,
                customers: @json(@$customers),
                loadCustomerStaff: false,
                status: @json(@$status),

                staff: @json(@$staff),
                sale: @json(@$staff),
                columns: @json(@$columns),
            },
            created() {
                EventBus.$on('reload_list', (msg = null) => {
                    if (msg) console.log(msg);
                    this.list = []
                    this.onLoadPagination()
                });
                EventBus.$on('copy_item', (item) => {
                    $("#exampleModal").modal('show')
                    this.copyItem(item)
                });
            },
            delimiters: ["((", "))"],
            mounted() {
                const that = this;
                if (this.viewType == 'grid') this.perPage = 0
                this.resetFilterObj()
                this.onLoadPagination();
            },
            computed: {
                selectAll: {
                    get: function() {
                        if (!this.list || this.selected.length == 0) return 0
                        if (this.selected.length == this.list.length) return 1
                        if (this.selected.length != this.list.length) return 2
                    },
                    set: function(value) {
                        this.selected = value ? this.list.map((row) => row.id) : [];
                    }
                },

                filteredCustomerStaff() {
                    this.loadCustomerStaff = true
                    let customer_staffs = this.customers.find(customer => customer.customer_id ==
                        this.createObj.customer_id)?.customer_staffs;

                    setTimeout(() => {
                        this.loadCustomerStaff = false
                    }, 10);
                    return customer_staffs ?? {};
                }
            },
            methods: {
                showColumn(key) {
                    if (!this.columns) return true;
                    let col = this.columns.find(column => column.key3 === key)
                    if (!col) return true;
                    return col?.num_val1
                },
                sortSelect: function(s) {
                    if (s === this.sortBy) {
                        this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                    }
                    this.sortBy = s;
                    this.list.sort((p1, p2) => {
                        let modifier = 1;
                        if (this.sortDirection === 'asc') modifier = -1;
                        let indexA = this.selected.indexOf(p1.id);
                        let indexB = this.selected.indexOf(p2.id);
                        // Nếu id không có trong selected thì cho nó giá trị lớn để nó được đẩy về sau
                        if (indexA === -1) indexA = Infinity;
                        if (indexB === -1) indexB = Infinity;

                        return (indexA - indexB) * modifier;
                    });
                },
                sortTime: function(s) {
                    if (s === this.sortBy) {
                        this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                    }
                    this.sortBy = s;
                    this.list = this.list.sort((p1, p2) => {
                        let modifier = this.sortDirection === 'asc' ? 1 : -1;

                        const time1 = p1[this.sortBy].split(':').map(num => parseInt(num));
                        const time2 = p2[this.sortBy].split(':').map(num => parseInt(num));

                        if (time1[0] < time2[0]) return -1 * modifier;
                        if (time1[0] > time2[0]) return 1 * modifier;
                        if (time1[1] < time2[1]) return -1 * modifier;
                        if (time1[1] > time2[1]) return 1 * modifier;
                        return 0;
                    });
                },
                sort: function(s) {
                    if (s === this.sortBy) {
                        this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                    }
                    this.sortBy = s;
                    this.list = this.list.sort((p1, p2) => {
                        let modifier = 1;
                        if (this.sortDirection === 'desc') modifier = -1;

                        if (p1[this.sortBy] == undefined && p2[this.sortBy] != undefined) return -1 *
                            modifier;
                        if (p1[this.sortBy] != undefined && p2[this.sortBy] == undefined) return 1 *
                            modifier;
                        if (p1[this.sortBy] == undefined && p2[this.sortBy] == undefined) return 0;

                        if (p1[this.sortBy].length == 0 && p2[this.sortBy].length > 0) return -1 *
                            modifier;
                        if (p1[this.sortBy].length > 0 && p2[this.sortBy].length == 0) return 1 *
                            modifier;
                        if (p1[this.sortBy].length == 0 && p2[this.sortBy].length == 0) return 0;

                        if (!Number.isNaN(parseInt(p1[this.sortBy])) && !Number.isNaN(parseInt(p2[this
                                .sortBy]))) {
                            if (p1[this.sortBy].indexOf && p2[this.sortBy].indexOf && p1[this.sortBy]
                                .indexOf("-") == -1 && p2[this.sortBy].indexOf("-") == -1) {
                                return (p1[this.sortBy] - p2[this.sortBy]) * modifier;
                            }
                        }

                        if (p1[this.sortBy] < p2[this.sortBy]) return -1 * modifier;
                        if (p1[this.sortBy] > p2[this.sortBy]) return 1 * modifier;
                        return 0;
                    });
                },
                setViewType(type) {
                    if (type !== this.viewType) {
                        this.viewType = type;
                        if (this.viewType == 'grid') {
                            this.perPage = 0
                            this.page = 1
                        } else {
                            this.perPage = 10
                            this.page = 1
                        }
                        this.onLoadPagination();
                    }
                },
                onPerPageChange(perPage) {
                    this.page = 1;
                    this.perPage = perPage;
                    this.onLoadPagination();
                },
                onPageChange(_p) {
                    this.page = _p;
                    this.onLoadPagination();
                },
                onPrePage() {
                    if (this.page > 1) {
                        this.page = this.page - 1;
                    }
                    this.onLoadPagination();
                },
                onNextPage() {
                    if (this.page < this.count) {
                        this.page = this.page + 1;
                    }
                    this.onLoadPagination();
                },
                async onLoadPagination() {
                    const that = this;
                    that.selected = [];
                    that.loading = true
                    that.list = [];
                    let conditionSearch = '?page=' + that.page;
                    conditionSearch += '&perPage=' + that.perPage;
                    conditionSearch += '&showcount=' + that.showCount;
                    conditionSearch += '&s=' + that.search;
                    that.conditionSearch = conditionSearch;

                    await jQuery.ajax({
                        type: 'GET',
                        data: that.filterObj,
                        url: "{{ route('api.homes.list') }}" + that.conditionSearch,
                        success: function(data) {
                            that.list = data?.result?.data;
                            that.count = data.result.last_page;
                            that.from = data.result.from;
                            that.to = data.result.to;
                            that.total = data.result.total;

                            let pageArr = [];
                            if (that.page - 2 > 0) {
                                pageArr.push(that.page - 2);
                            }
                            if (that.page - 1 > 0) {
                                pageArr.push(that.page - 1);
                            }
                            pageArr.push(that.page);
                            if (that.page + 1 <= that.count) {
                                pageArr.push(that.page + 1);
                            }
                            if (that.page + 2 <= that.count) {
                                pageArr.push(that.page + 2);
                            }
                            that.listPage = pageArr;
                            that.loading = false
                        },
                        error: function(xhr, textStatus, error) {
                            notifier.warning('Lỗi Hệ Thống!');
                            that.loading = false
                        }
                    });
                },
                async createFormSubmit() {
                    if (this.createLoading) return;
                    let that = this;
                    this.createLoading = true
                    const form = $('#createForm');
                    const formData = new FormData(form[0]);
                    await jQuery.ajax({
                        type: 'POST',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,
                        url: "{{ route('view.home.store') }}",
                        success: function(data) {
                            that.createLoading = false
                            let element = notifier.success(data.message);
                            customizeNotification(element, notifier);
                            that.previewUrl = "{{ asset('assets/images/multi-user.jpg') }}";
                            resetForm(form[0])
                            $('.modal').modal('hide');
                            that.onLoadPagination();
                            that.validateErrors = {}
                        },
                        error: function(data) {
                            that.createLoading = false
                            that.validateErrors = data.responseJSON.errors
                            customizeNotification(notifier.alert("{{ trans('label.failed') }}"),
                                notifier);

                        }
                    });
                },
                async bulkDelete() {
                    let that = this;

                    if (that.selected.length <= 0) {
                        notifier.alert("{{ trans('label.choosing_item') }}")
                        return;
                    }

                    const result = await Swal.fire({
                        title: "{{ trans('label.are_you_sure') }}",
                        html: "{{ trans('label.cant_revert') }}" + "{!! '<br>' !!}" +
                            that.selected,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#dc3545',
                        cancelButtonColor: '#ffffff',
                        confirmButtonText: "{{ trans('label.yes_delete_it') }}",
                        cancelButtonText: "{{ trans('label.cancel') }}"
                    });
                    if (result.isConfirmed) {
                        that.createLoading = true
                        await jQuery.ajax({
                            type: 'DELETE',
                            data: {
                                _method: 'DELETE',
                                ids: that.selected
                            },
                            url: "{{ route('view.home.bulk_delete') }}",
                            success: function(data) {
                                notifier.success("{{ trans('label.delete_success') }}");
                                that.onLoadPagination();
                            },
                            error: function(data) {
                                notifier.alert(data.responseJSON.message);
                                /* notifier.alert(data.responseJSON.message); */
                            }
                        });
                        that.createLoading = false
                    }
                },
                deleteItem(id) {
                    Swal.fire({
                        title: '{{ trans('label.are_you_sure') }}',
                        text: '{{ trans('label.cant_revert') }}',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#dc3545',
                        cancelButtonColor: '#ffffff',
                        confirmButtonText: '{{ trans('label.yes_delete_it') }}',
                        cancelButtonText: '{{ trans('label.cancel') }}'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            jQuery('#formDelete_' + id).submit();
                        }
                    })

                },
                handleSearch() {
                    this.loading = true
                    /*       this.list = [] */
                    if (this.search !== '') this.showClearSearch = true
                    else this.showClearSearch = false;

                    if (this.searchTimeout) clearTimeout(this.searchTimeout)
                    this.searchTimeout = setTimeout(() => {
                        this.searchFunction();
                    }, 400);
                },
                searchFunction() {
                    this.page = 1
                    this.onLoadPagination();
                },
                resetCreateObj() {
                    this.createObj = {
                        customer_type: @json(@$customer_type[0]->key3),
                        type: @json(@$type[0]->key3),
                    }
                    $('#customer_id').val("").trigger('change')
                    $('#customer_id').val(this.createObj.customer_id).trigger('change')
                    $('#customer_staff_id').val(this.createObj.customer_staff_id).trigger('change')
                    $('#staff_id').val(this.createObj.staff_id).trigger('change')
                    $('#sale_id').val(this.createObj.sale_id).trigger('change')
                },
                copyItem(item) {
                    this.createObj = {
                        ...item
                    }
                    $('#customer_id').val("").trigger('change')
                    $('#customer_id').val(this.createObj.customer_id).trigger('change')
                    $('#customer_staff_id').val(this.createObj.customer_staff_id).trigger('change')
                    $('#staff_id').val(this.createObj.staff_id).trigger('change')
                    $('#sale_id').val(this.createObj.sale_id).trigger('change')
                },
                clearInput() {
                    this.search = ''
                    this.showClearSearch = false
                    this.searchFunction();
                },
                resetFilterObj() {
                    this.filterObj = {}
                },
                resetSearch() {
                    this.resetFilterObj()
                    this.searchFunction()
                },
                deleteItem(id) {
                    Swal.fire({
                        title: '{{ trans('label.are_you_sure') }}',
                        text: '{{ trans('label.cant_revert') }}',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#dc3545',
                        cancelButtonColor: '#ffffff',
                        confirmButtonText: '{{ trans('label.yes_delete_it') }}',
                        cancelButtonText: '{{ trans('label.cancel') }}'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            jQuery('#formDelete_' + id).submit();
                        }
                    })

                },
                previewImage(event) {
                    const file = event.target.files[0];
                    if (file) {
                        this.previewUrl = URL.createObjectURL(file)
                    }
                },
            },
        });
    </script>

    @if ($errors->any())
        <script>
            let alertMessage = `
            @foreach ($errors->all() as $error)
            <br>
                {{ $error }}
            @endforeach
            `
            notifier.alert(alertMessage);
        </script>
    @endif

    @if (session('error'))
        <script>
            notifier.alert(`{{ session('error') }}`);
        </script>
    @endif

    @if (session('success'))
        <script>
            notifier.success(`{{ session('success') }}`);
        </script>
    @endif

@endsection
