@extends('layouts.master')

@section('title', 'film')

@section('content')
    <div id="App">
        <form action="{{ route('view.film.update', $model->id) }}" method="post" class="container-fluid"
            enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <!-- Page Header -->
            <div class="d-md-flex d-block align-items-center justify-content-between my-4 page-header-breadcrumb">
                <div class="my-auto">
                    <h4 class="mb-0">Film</h4>
                    <nav>
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="{{ asset('/admin') }}">Admin</a>
                            </li>
                            <li class="breadcrumb-item " aria-current="page">
                                <a href="{{ asset('/admin/film') }}">
                                    Film
                                </a>
                            </li>
                            <li class="breadcrumb-item disable" aria-current="page">
                                <span>
                                    Chi Tiết
                                </span>
                            </li>
                        </ol>
                    </nav>
                </div>

                <div class=" text-end">
                    <button type="submit" class="btn text-black bg-white border rounded-3 text-nowrap">
                        Cập nhật
                    </button>
                </div>
            </div>


            <ul class="nav nav-custom nav-tabs bg-white p-2 d-sm-flex d-block mb-3 column-gap-3 rounded-3" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" aria-current="page"
                        href="#tab1">Thông tin Film
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="tab" data-bs-target="#tab2" aria-current="page" href="#tab2">Thông
                        tin Feature Film
                    </a>
                </li>
            </ul>


            <!-- End Page Header -->
            <div class="tab-content tab-content-custom rounded-3 mt-1 bg-transparent p-0 collapse-all-content">
                <div class="tab-pane  p-0 border-0 active" id="tab1" role="tab1">
                    @include('admin.film.detail.tab1')
                </div>
                <div class="tab-pane  p-0 border-0" id="tab2" role="tab2">
                    @include('admin.film.detail.tab2')
                </div>
            </div>


            <!-- End Page Header -->

        </form>
    </div>
@endsection

@section('script-footer')

    <!-- Chartjs Chart JS -->
    <!-- <script src="{{ asset('assets/js/index.js') }}"></script> -->

    <script src="{{ asset('assets/js/prism-custom.js') }}"></script>

    <script src="{{ asset('assets/js/custom-switcher.min.js') }}"></script>
    <!-- Custom JS -->
    <script src="{{ asset('assets/js/custom.js') }}"></script>
    <script src="{{ asset('assets/js/csrf.js') }}"></script>



    <script type="text/javascript">
        var options = {
            durations: {
                alert: 0,
                warning: 0,
                success: 1000,
            },
            icons: {
                enabled: false
            }
        }
        var notifier = new AWN(options);
    </script>
    <script>
        new Vue({
            el: '#App',
            data: {
                sortDirection: 'desc',
                sortBy: 'id',
                count: 0, //total page
                page: 1, //pagination: curent page
                perPage: 10, // pagination: records per page
                total: 0, //pagination: total records
                pageRange: 3, // pagination:controls nearby page display. currenpage counted
                from: 1,
                to: 10,
                list: [],
                conditionSearch: '',
                search: '',
                previewUrl: "{{ $model->logo_url }}",
                modalUrl: "{{ route('view.user.store') }}",
                putMethod: false,
                createObj: {},
                createObjEn: {},
                selectedObject: {},
                listPage: [],
                showCount: 10,
                validateErrors: {},
                createLoading: false,
                viewType: 'list',
                loading: false,
            },
            delimiters: ["((", "))"],
            mounted() {
                const that = this;
                this.createObj = @json($model);
                this.createObjEn = @json($modelEn);

            },
            computed: {},

            methods: {

            },
        });
    </script>


    @if ($model->init_password === 0)
        <script>
            notifier.warning(`{{ trans('label.please_change_password') }}`);
        </script>
    @endif

    @if ($errors->any())
        <script>
            let alertMessage = `
    @foreach ($errors->all() as $error)
    <br>
        {{ $error }}
    @endforeach
    `
            notifier.alert(alertMessage);
        </script>
    @endif

    @if (session('error'))
        <script>
            notifier.alert(`{{ session('error') }}`);
        </script>
    @endif

    @if (session('success'))
        <script>
            notifier.success(`{{ session('success') }}`);
        </script>
    @endif

@endsection
