<form action="{{ route('view.creator.update', $model->id) }}" method="post" class=" m-0 p-0" enctype="multipart/form-data">
    @csrf
    @method('PUT')
    <div class=" text-end mb-3">
        <button type="submit" class="btn text-black bg-white border rounded-3 text-nowrap">
            Cập nhật
        </button>
    </div>
    <div class="card bg-white position-relative table-wrapper p-3 ">
        <div class="row">
            <div class="col-sm-12 mb-3">
                <label for="name" class="form-label text-capitalize">Tên creator</label>
                <input type="text" :class="[{ 'validate-error--input': validateErrors.name }, 'form-control']"
                    v-model="createObj.name" name="name" />

                <div class="validate-error--text text-danger" v-if="validateErrors.name"
                    v-for="err in validateErrors.name">
                    <small>
                        (( err ))
                    </small>
                </div>
            </div>

            <div class="col-sm-12 mb-3">
                <label for="position" class="form-label text-capitalize">Chức vụ</label>
                <input type="text" :class="[{ 'validate-error--input': validateErrors.position }, 'form-control']"
                    v-model="createObj.position" name="position" />

                <div class="validate-error--text text-danger" v-if="validateErrors.position"
                    v-for="err in validateErrors.position">
                    <small>
                        (( err ))
                    </small>
                </div>
            </div>

            <div class="col-sm-12 mb-3">
                <label for="position_desc" class="form-label text-capitalize">chi tiết Chức vụ</label>
                <input type="text"
                    :class="[{ 'validate-error--input': validateErrors.position_desc }, 'form-control']"
                    v-model="createObj.position_desc" name="position_desc" />

                <div class="validate-error--text text-danger" v-if="validateErrors.position_desc"
                    v-for="err in validateErrors.position_desc">
                    <small>
                        (( err ))
                    </small>
                </div>
            </div>

            <div class="col-md-6 mb-3">
                <label for="banner" class="mb-2 text-capitalize">hình ảnh</label>
                <image-selector v-model="createObj.image_url" name="image_url"></image-selector>
            </div>

            <div class="col-md-6 d-flex">
                <img :src="((createObj.image_url))" alt="" class="m-auto">
            </div>


            <div class="col-12 mb-3">
                <label for="description" class="form-label text-capitalize">Mô tả</label>
                <ckeditor
                    :textareaClass="[{ 'validate-error--input': validateErrors.description },
                        'form-control'
                    ]"
                    v-model="createObj.description" name="description"></ckeditor>
                <div class="validate-error--text text-danger" v-if="validateErrors.description"
                    v-for="err in validateErrors.description">
                    <small> (( err )) </small>
                </div>
            </div>
        </div>
    </div>

</form>
