@extends('layouts.master')

@section('title', 'category')

@section('content')
<div id="App">
    <form action="{{ route('view.category.update', $model->id) }}" method="post" class="container-fluid"
        enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <!-- Page Header -->
        <div class="d-md-flex d-block align-items-center justify-content-between my-4 page-header-breadcrumb">
            <div class="my-auto">
                <h4 class="mb-0">Category</h4>
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item"><a href="{{ asset('/admin') }}">Admin</a>
                        </li>
                        <li class="breadcrumb-item " aria-current="page">
                            <a href="{{ asset('/admin/category') }}">
                                Category
                            </a>
                        </li>
                        <li class="breadcrumb-item disable" aria-current="page">
                            <span>
                                Chi Tiết
                            </span>
                        </li>
                    </ol>
                </nav>
            </div>

            <div class=" text-end">
                <button type="submit" class="btn text-black bg-white border rounded-3 text-nowrap">
                    Cập nhật
                </button>
            </div>
        </div>
        <!-- End Page Header -->
        <div class="card bg-white position-relative table-wrapper p-3 ">
            <div class="row">
                <div class="col-sm-12 mb-3">
                    <label for="name" class="form-label">Tên category</label>
                    <input type="text"
                        class="form-control"
                        v-model="createObj.name" name="name_vi" @change="generateSlug()" />
                </div>
                <div class="col-sm-12 mb-3">
                    <label for="name" class="form-label">Tên Tiếng Anh</label>
                    <input type="text"
                        class="form-control" v-model="createObjEn.name" name="name_en" />
                </div>
                <div class="col-sm-12 mb-3">
                    <label for="slug" class="form-label">Slug</label>
                    <input type="text"
                        :class="[{ 'validate-error--input': validateErrors.slug }, 'form-control']"
                        v-model="createObj.slug" name="slug" />

                    <div class="validate-error--text text-danger" v-if="validateErrors.slug"
                        v-for="err in validateErrors.slug">
                        <small>
                            (( err ))
                        </small>
                    </div>
                </div>

                <div class="col-md-6 mb-3">
                    <label for="banner" class="mb-2 text-capitalize">hình ảnh</label>
                    <image-selector v-model="createObj.banner_url" name="banner_url"></image-selector>
                </div>

                <div class="col-md-6 d-flex  banner-img-holder mb-3">
                    <img :src="((createObj.banner_url))" alt="" class="m-auto">
                </div>

                <div class="col-md-6 mb-3">
                    <label for="banner" class="mb-2 text-capitalize">hình ảnh trên mobile</label>
                    <image-selector v-model="createObj.mobile_banner_url" name="mobile_banner_url"></image-selector>
                </div>

                <div class="col-md-6 d-flex  banner-img-holder mb-3">
                    <img :src="((createObj.mobile_banner_url))" alt="" class="m-auto">
                </div>


                <div class="col-12 mb-3">
                    <label for="Nôi" class="form-label">Nội dung</label>
                    <ckeditor class="form-control"
                        v-model="createObj.description" name="description_vi"></ckeditor>
                </div>

                <div class="col-12 mb-3">
                    <label for="Nôi" class="form-label">Nội dung Tiếng Anh</label>
                    <ckeditor class="form-control"
                        v-model="createObjEn.description" name="description_en"></ckeditor>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@section('script-footer')

<!-- Chartjs Chart JS -->
<!-- <script src="{{ asset('assets/js/index.js') }}"></script> -->

<script src="{{ asset('assets/js/prism-custom.js') }}"></script>

<script src="{{ asset('assets/js/custom-switcher.min.js') }}"></script>
<!-- Custom JS -->
<script src="{{ asset('assets/js/custom.js') }}"></script>
<script src="{{ asset('assets/js/csrf.js') }}"></script>



<script type="text/javascript">
    var options = {
        durations: {
            alert: 0,
            warning: 0,
            success: 1000,
        },
        icons: {
            enabled: false
        }
    }
    var notifier = new AWN(options);
</script>
<script>
    new Vue({
        el: '#App',
        data: {
            sortDirection: 'desc',
            sortBy: 'id',
            count: 0, //total page
            page: 1, //pagination: curent page
            perPage: 10, // pagination: records per page
            total: 0, //pagination: total records
            pageRange: 3, // pagination:controls nearby page display. currenpage counted
            from: 1,
            to: 10,
            list: [],
            conditionSearch: '',
            search: '',
            previewUrl: "{{ $model->logo_url }}",
            modalUrl: "{{ route('view.user.store') }}",
            putMethod: false,
            createObj: {},
            createObjEn: {},
            selectedObject: {},
            listPage: [],
            showCount: 10,
            validateErrors: {},
            createLoading: false,
            viewType: 'list',
            loading: false,
        },
        delimiters: ["((", "))"],
        mounted() {
            const that = this;
            this.createObj = @json($model);
            this.createObjEn = @json($categoryEn);
        },
        computed: {},

        methods: {

        },
    });
</script>


@if ($model->init_password === 0)
<script>
    notifier.warning(`{{ trans('label.please_change_password') }}`);
</script>
@endif

@if ($errors->any())
<script>
    let alertMessage = `
    @foreach ($errors->all() as $error)
    <br>
        {{ $error }}
    @endforeach
    `
    notifier.alert(alertMessage);
</script>
@endif

@if (session('error'))
<script>
    notifier.alert(`{{ session('error') }}`);
</script>
@endif

@if (session('success'))
<script>
    notifier.success(`{{ session('success') }}`);
</script>
@endif

@endsection