@extends('layouts.master')

@section('title', 'artist')

@section('content')
    <div class="container-fluid fixed-screen-container" id="App">

        <!-- Page Header -->
        <div class="d-flex flex-wrap justify-content-between gap-4 my-4 page-header-breadcrumb">
            <div class="my-auto">
                <h4 class="mb-0 text-capitalize">artist</h4>
                <nav>
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item"><a href="{{ asset('/admin') }}">Admin</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <a href="{{ asset('/admin/artist') }}">
                                Artist
                            </a>
                        </li>
                    </ol>
                </nav>
            </div>
            <div class=" text-end d-flex gap-2 align-self-end">
                <a class="btn text-black bg-white border rounded-3 text-nowrap" data-bs-toggle="modal"
                    @click="resetCreateObj" data-bs-target="#exampleModal">
                    <i class="fe fe-plus button_icon"></i>Thêm
                </a>

            </div>
        </div>
        <!-- End Page Header -->

        <div class="text-end d-flex flex-wrap justify-content-end gap-2 mb-2">
            <div class="input-group rounded-3 has-clear-btn-input-group">
                <span class="input-group-text bg-white border-end-0" style="border-color: #ced4da"><i class="ri-search-line"
                        style="color: #878a99"></i></span>
                <input type="text" class="form-control border-start-0  ps-0 pe-3 rounded-end-1 " v-model="search"
                    @keyup="handleSearch" style="border-color: #ced4da;" placeholder="Search Tên">
                <i class="bi bi-x fs-22 position-absolute clearSearchButton" @click="clearInput" v-if="showClearSearch"></i>
            </div>
            <a class="btn text-black bg-white border rounded-3 text-nowrap" @click="bulkDelete()">
                <i class="bi bi-trash-fill"></i> Xóa Item đã chọn
            </a>
            {{-- search --}}
            {{--  <div>
                <a href="javascript:void(0);" class="btn rounded-3 text-black bg-white border  text-nowrap"
                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                    <i class="bi bi-funnel button_icon"></i>{{ trans('label.filters') }}
                </a>
                <div class="dropdown-menu rounded-7" style="min-width: 300px" data-popper-placement="bottom-start">
                    @include('admin.artist.components.search')
                </div>
            </div> --}}
        </div>

        <div class="indexpage-list-wrapper">
            @include('admin.artist.components.list')
        </div>
        @include('admin.artist.components.add_modal')
    </div>

@endsection

@section('script-footer')

    <!-- Chartjs Chart JS -->
    <!-- <script src="{{ asset('assets/js/index.js') }}"></script> -->

    <script src="{{ asset('assets/js/prism-custom.js') }}"></script>

    <script src="{{ asset('assets/js/custom-switcher.min.js') }}"></script>
    <!-- Custom JS -->
    <script src="{{ asset('assets/js/custom.js') }}"></script>
    <script src="{{ asset('assets/js/csrf.js') }}"></script>


    <!-- Lodash -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/lodash.js/4.17.21/lodash.min.js"
        integrity="sha512-WFN04846sdKMIP5LKNphMaWzU7YpMyCU245etK3g/2ARYbPK9Ub18eG+ljU96qKRCWh+quCY7yefSmlkQw1ANQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    <script>
        $(document).ready(function() {
            $('.lfm').filemanager('image');
        });
    </script>
    <script type="text/javascript">
        var options = {
            durations: {
                alert: 5000,
                warning: 0,
                success: 1000,
            },
            icons: {
                enabled: false
            }
        }
        var notifier = new AWN(options);

        new Vue({
            el: '#App',
            data: {
                sortDirection: 'desc',
                sortBy: '',
                count: 0, //total page
                page: 1, //pagination: curent page
                perPage: 10, // pagination: records per page
                total: 0, //pagination: total records
                pageRange: 3, // pagination:controls nearby page display. currenpage counted
                from: 1,
                to: 10,
                list: [],
                conditionSearch: '',
                search: '',
                valid_from: '',
                valid_to: '',
                status: [1, 2, 3],
                showClearSearch: false,
                modalUrl: "{{ route('view.artist.store') }}",
                putMethod: false,
                selectedObject: {},
                listPage: [],
                showCount: 10,
                selected: [],
                previewUrl: "{{ asset('assets/images/multi-user.jpg') }}",
                validateErrors: {},
                createLoading: false,
                viewType: 'list',
                createObj: {
                    name: '',
                    slug: '',
                },
                loading: false,
            },
            delimiters: ["((", "))"],
            mounted() {
                const that = this;
                this.onLoadPagination();
            },
            computed: {
                selectAll: {
                    get: function() {
                        if (!this.list || this.selected.length == 0) return 0
                        if (this.selected.length == this.list.length) return 1
                        if (this.selected.length != this.list.length) return 2
                    },
                    set: function(value) {
                        this.selected = value ? this.list.map((row) => row.id) : [];
                    }
                }
            },
            methods: {
                generateSlug() {
                    console.log(1);
                    this.createObj.slug = this.slugify(this.createObj.name);

                    console.log(this.createObj.slug);

                },
                slugify(text) {
                    return text
                        .toString()
                        .toLowerCase() // chuyển thành chữ thường
                        .replace(/\s+/g, '-') // thay khoảng trắng bằng dấu gạch ngang
                        .replace(/[^\w\-]+/g, '') // loại bỏ các ký tự đặc biệt
                        .replace(/\-\-+/g, '-') // thay thế nhiều dấu gạch ngang liên tiếp bằng một dấu gạch ngang
                        .replace(/^-+/, '') // loại bỏ dấu gạch ngang ở đầu chuỗi
                        .replace(/-+$/, ''); // loại bỏ dấu gạch ngang ở cuối chuỗi
                },
                resetCreateObj() {
                    this.createObj = {
                        name: '',
                        slug: '',
                    }
                },
                copyItem(item) {
                    this.createObj = {
                        ...item,
                    }
                },
                sortSelect: function(s) {
                    if (s === this.sortBy) {
                        this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                    }
                    this.sortBy = s;
                    this.list.sort((p1, p2) => {
                        let modifier = 1;
                        if (this.sortDirection === 'asc') modifier = -1;
                        let indexA = this.selected.indexOf(p1.id);
                        let indexB = this.selected.indexOf(p2.id);
                        // Nếu id không có trong selected thì cho nó giá trị lớn để nó được đẩy về sau
                        if (indexA === -1) indexA = Infinity;
                        if (indexB === -1) indexB = Infinity;

                        return (indexA - indexB) * modifier;
                    });
                },
                sortTime: function(s) {
                    if (s === this.sortBy) {
                        this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                    }
                    this.sortBy = s;
                    this.list = this.list.sort((p1, p2) => {
                        let modifier = this.sortDirection === 'asc' ? 1 : -1;

                        const time1 = p1[this.sortBy].split(':').map(num => parseInt(num));
                        const time2 = p2[this.sortBy].split(':').map(num => parseInt(num));

                        if (time1[0] < time2[0]) return -1 * modifier;
                        if (time1[0] > time2[0]) return 1 * modifier;
                        if (time1[1] < time2[1]) return -1 * modifier;
                        if (time1[1] > time2[1]) return 1 * modifier;
                        return 0;
                    });
                },
                sort: function(s) {
                    if (s === this.sortBy) {
                        this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                    }
                    this.sortBy = s;
                    this.list = this.list.sort((p1, p2) => {
                        let modifier = 1;
                        if (this.sortDirection === 'desc') modifier = -1;

                        if (p1[this.sortBy] == undefined && p2[this.sortBy] != undefined) return -1 *
                            modifier;
                        if (p1[this.sortBy] != undefined && p2[this.sortBy] == undefined) return 1 *
                            modifier;
                        if (p1[this.sortBy] == undefined && p2[this.sortBy] == undefined) return 0;

                        if (p1[this.sortBy].length == 0 && p2[this.sortBy].length > 0) return -1 *
                            modifier;
                        if (p1[this.sortBy].length > 0 && p2[this.sortBy].length == 0) return 1 *
                            modifier;
                        if (p1[this.sortBy].length == 0 && p2[this.sortBy].length == 0) return 0;

                        if (!Number.isNaN(parseInt(p1[this.sortBy])) && !Number.isNaN(parseInt(p2[this
                                .sortBy]))) {
                            if (p1[this.sortBy].indexOf && p2[this.sortBy].indexOf && p1[this.sortBy]
                                .indexOf("-") == -1 && p2[this.sortBy].indexOf("-") == -1) {
                                return (p1[this.sortBy] - p2[this.sortBy]) * modifier;
                            }
                        }

                        if (p1[this.sortBy] < p2[this.sortBy]) return -1 * modifier;
                        if (p1[this.sortBy] > p2[this.sortBy]) return 1 * modifier;
                        return 0;
                    });
                },
                setViewType(type) {
                    this.viewType = type;
                },
                onPerPageChange(perPage) {
                    this.page = 1;
                    this.perPage = perPage;
                    this.onLoadPagination();
                },
                onPageChange(_p) {
                    this.page = _p;
                    this.onLoadPagination();
                },
                onPrePage() {
                    if (this.page > 1) {
                        this.page = this.page - 1;
                    }
                    this.onLoadPagination();
                },
                onNextPage() {
                    if (this.page < this.count) {
                        this.page = this.page + 1;
                    }
                    this.onLoadPagination();
                },
                async onLoadPagination() {
                    this.selected = [];
                    this.loading = true
                    const that = this;
                    that.list = [];
                    let conditionSearch = '?page=' + this.page;
                    conditionSearch += '&perPage=' + this.perPage;
                    conditionSearch += '&showcount=' + this.showCount;
                    conditionSearch += '&s=' + this.search;
                    this.conditionSearch = conditionSearch;

                    await jQuery.ajax({
                        type: 'GET',
                        url: "{{ route('api.artist.list') }}" + conditionSearch,
                        success: function(data) {

                            that.list = data?.result?.data;
                            that.count = data.result.last_page;
                            that.from = data.result.from;
                            that.to = data.result.to;
                            that.total = data.result.total;

                            let pageArr = [];
                            if (that.page - 2 > 0) {
                                pageArr.push(that.page - 2);
                            }
                            if (that.page - 1 > 0) {
                                pageArr.push(that.page - 1);
                            }
                            pageArr.push(that.page);
                            if (that.page + 1 <= that.count) {
                                pageArr.push(that.page + 1);
                            }
                            if (that.page + 2 <= that.count) {
                                pageArr.push(that.page + 2);
                            }
                            that.listPage = pageArr;
                            console.log(that.list);
                            that.loading = false
                        },
                        error: function(xhr, textStatus, error) {
                            notifier.warning('Lỗi Hệ Thống!');
                            that.loading = false
                        }
                    });
                },
                async createFormSubmit() {
                    if (this.createLoading) return;
                    let that = this;
                    this.createLoading = true
                    const form = $('#createForm');
                    const formData = new FormData(form[0]);
                    await jQuery.ajax({
                        type: 'POST',
                        data: formData,
                        cache: false,
                        contentType: false,
                        processData: false,
                        url: "{{ route('view.artist.store') }}",
                        success: function(data) {
                            that.createLoading = false
                            notifier.success('label.success')
                            $('#avatar').val('')
                            that.previewUrl = "{{ asset('assets/images/multi-user.jpg') }}";
                            form[0].reset()
                            $('.modal').modal('hide')
                            that.validateErrors = {}
                            that.onLoadPagination()
                        },
                        error: function(data) {
                            that.createLoading = false
                            that.validateErrors = data.responseJSON.errors
                            notifier.alert(data.responseJSON.message);
                        }
                    })
                },
                async bulkDelete() {
                    let that = this;

                    if (that.selected.length <= 0) {
                        notifier.alert("{{ trans('label.choosing_item') }}")
                        return;
                    }

                    const result = await Swal.fire({
                        title: "{{ trans('label.are_you_sure') }}",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#dc3545',
                        cancelButtonColor: '#ffffff',
                        confirmButtonText: "{{ trans('label.yes_delete_it') }}",
                        cancelButtonText: "{{ trans('label.cancel') }}"
                    });
                    if (result.isConfirmed) {
                        that.createLoading = true
                        await jQuery.ajax({
                            type: 'DELETE',
                            data: {
                                _method: 'DELETE',
                                ids: that.selected
                            },
                            url: "{{ route('view.artist.bulk_delete') }}",
                            success: function(data) {
                                notifier.success("{{ trans('label.delete_success') }}");
                                that.onLoadPagination();
                            },
                            error: function(data) {
                                notifier.alert(data.responseJSON.message);
                                /* notifier.alert(data.responseJSON.message); */
                            }
                        });
                        that.createLoading = false
                    }
                },
                handleSearch() {
                    this.loading = true
                    this.list = []
                    if (this.search !== '') this.showClearSearch = true
                    else this.showClearSearch = false;

                    if (this.searchTimeout) clearTimeout(this.searchTimeout)
                    this.searchTimeout = setTimeout(() => {
                        this.searchFunction();
                    }, 400);
                },
                searchFunction() {
                    this.page = 1
                    this.onLoadPagination();
                },
                clearInput() {
                    this.search = ''
                    this.showClearSearch = false
                    this.onLoadPagination();
                },
                resetSearch() {
                    this.search = ''
                    this.valid_from = ''
                    this.valid_to = ''
                    this.status = [1, 2, 3]
                    // this.onLoadPagination()
                },
                deleteItem(id) {
                    Swal.fire({
                        title: '{{ trans('label.are_you_sure') }}',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#dc3545',
                        cancelButtonColor: '#ffffff',
                        confirmButtonText: '{{ trans('label.yes_delete_it') }}',
                        cancelButtonText: '{{ trans('label.cancel') }}'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            jQuery('#formDelete_' + id).submit();
                        }
                    })

                },
                previewImage(event) {
                    const file = event.target.files[0];
                    if (file) {
                        this.previewUrl = URL.createObjectURL(file)
                    }
                },
            },
        });
    </script>

    @if ($errors->any())
        <script>
            let alertMessage = `
            @foreach ($errors->all() as $error)
            <br>
                {{ $error }}
            @endforeach
            `
            notifier.alert(alertMessage);
        </script>
    @endif

    @if (session('error'))
        <script>
            notifier.alert(`{{ session('error') }}`);
        </script>
    @endif

    @if (session('success'))
        <script>
            notifier.success(`{{ session('success') }}`);
        </script>
    @endif

@endsection
