<template id="list_film">
    <div>
        <div class="text-end d-flex flex-wrap justify-content-end gap-2 mb-2">
            <div class="input-group rounded-3 has-clear-btn-input-group">
                <span class="input-group-text bg-white border-end-0" style="border-color: #ced4da"><i
                        class="ri-search-line" style="color: #878a99"></i></span>
                <input type="text" class="form-control border-start-0  ps-0 pe-3 rounded-end-1 " v-model="search"
                    @keyup="handleSearch" style="border-color: #ced4da;"
                    placeholder="Search Tên, Category, Brand vv...">
                <i class="bi bi-x fs-22 position-absolute clearSearchButton" @click="clearInput"
                    v-if="showClearSearch"></i>
            </div>
            <a class="btn text-black bg-white border rounded-3 text-nowrap" @click="bulkDelete()">
                <i class="bi bi-trash-fill"></i> Xóa Item đã chọn
            </a>
            <div class=" text-end d-flex gap-2 align-self-end">
                <a class="btn text-black bg-white border rounded-3 text-nowrap" data-bs-toggle="modal"
                    @click="resetCreateObj" data-bs-target="#exampleModal">
                    <i class="fe fe-plus button_icon"></i>Thêm
                </a>

            </div>
        </div>
        <div class="position-relative table-wrapper bg-white rounded-3 mb-4">
            <div class="table-responsive gino-custom-table pb-0 rounded-3 border">
                <table class="table mb-0 text-nowrap bg-white ">
                    <thead>
                        <tr>
                            <th @click="sortSelect('select')" role='button' style="width: 1px"
                                class=" col_checkbox px-4">
                                <input type="checkbox"
                                    :class="[{ 'gino-checkbox--checked2': selectAll == 2 },
                                        'gino-checkbox form-check-input'
                                    ]"
                                    v-model="selectAll" :checked="selectAll" @click.stop>
                                <i v-if="sortBy == 'select'"
                                    v-bind:class="sortDirection == 'desc' ? 
                                    'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                            </th>
                            <th @click="sort('id')" role='button' class="col_id text-center">
                                ID
                                <i v-if="sortBy == 'id'"
                                    v-bind:class="sortDirection == 'desc' ? 
                                    'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                            </th>
                            <th>
                            </th>

                            <th @click="sort('name')" role='button'>
                                Tên
                                <i v-if="sortBy == 'name'"
                                    v-bind:class="sortDirection == 'desc' ? 
                                    'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                            </th>
                            <th @click="sort('category_id')" role='button'>
                                Category
                                <i v-if="sortBy == 'category_id'"
                                    v-bind:class="sortDirection == 'desc' ? 
                                    'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                            </th>
                            <th @click="sort('brand_id')" role='button'>
                                Brand
                                <i v-if="sortBy == 'brand_id'"
                                    v-bind:class="sortDirection == 'desc' ? 
                                    'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                            </th>
                            <th @click="sort('date')" role='button'>
                                Release Date
                                <i v-if="sortBy == 'date'"
                                    v-bind:class="sortDirection == 'desc' ? 
                                    'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                            </th>
                            <th>
                                Work Scope
                            </th>

                            <th style="width:1px">
                                <div></div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="item in list" :key="item.id">
                            <td scope="col" class=" px-4">
                                <input type="checkbox" class="gino-checkbox form-check-input" v-model="selected"
                                    :value="item.id">
                            </td>
                            <td class="text-center">
                                <a :href="`{{ asset('film') }}/` + item.id + `/detail`" class="text-primary">
                                    ((item.id))
                                </a>
                            </td>
                            <td class="text-center">
                                <img :src="item.img_url" class="object-fit-contain rounded-2 me-2" height="44"
                                    :alt="item.name">
                            </td>
                            <td>((item.name))</td>
                            <td>((item.category?.name))</td>
                            <td>((item.brand?.name))</td>
                            <td>((item.date))</td>
                            <td>((item.pivot?.work_scope))</td>
                            <td>
                                <div class="hstack gap-2 me-2">
                                    <a href="##" @click="deleteItem(item.id)" class="  action-btn rounded  p-1">
                                        @include('icons.trash')</a>
                                </div>
                            </td>
                        </tr>
                        <tr v-if="loading">
                            <td colspan="100%" class=" text-center">
                                <div class="spinner-border">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                            </td>
                        </tr>
                        <tr v-if="list.length < 1 && !loading">
                            <td colspan="100%" class="text-center border-bottom">Không có dữ liệu</td>
                        </tr>

                    </tbody>
                </table>
            </div>
        </div>
        @include('includes.pagination')


        <div class="modal fade gino-modal" id="exampleModal" tabindex="-1" role="dialog"
            aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog " role="document">
                <div class="modal-content custom-modal-content">
                    <div class="modal-header border-0  bg-light p-3">
                        <h6 class="modal-title" id="exampleModalLabel">Thêm / Chỉnh sửa</h6>
                        <button type="button" class="btn-close btn-close-black " data-bs-dismiss="modal"
                            aria-label="Close">
                        </button>
                    </div>
                    <form @submit.prevent="createFormSubmit" ref="createForm" id="createForm" method="post"
                        enctype="multipart/form-data">
                        <div class="modal-body p-20">
                            <div class="row">
                                <div class="col-sm-12 mb-3">
                                    <label for="film_ids" class="form-label">Film</label>

                                    <select2 name="film_ids[]" id="" v-model="createObj.film_ids"
                                        class="form-control" data-dropdown-parent="#exampleModal"
                                        data-allow-clear="true" multiple>
                                        @foreach ($films as $key => $item)
                                            <option value="{{ $item->id }}">{{ $item->brand?->name }} -
                                                {{ $item->name }}</option>
                                        @endforeach
                                    </select2>

                                    <div class="validate-error--text text-danger" v-if="validateErrors.film_ids"
                                        v-for="err in validateErrors.film_ids">
                                        <small>
                                            (( err ))
                                        </small>
                                    </div>
                                </div>
                                <div class="col-sm-12 mb-3">
                                    <label for="work_scope" class="form-label">Workscope</label>
                                    <input name="work_scope" id="" v-model="createObj.work_scope"
                                        class="form-control">
                                    <div class="validate-error--text text-danger" v-if="validateErrors.work_scope"
                                        v-for="err in validateErrors.work_scope">
                                        <small>
                                            (( err ))
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer border-0 p-3 pt-0 gap-2 justify-content-end">
                            <div v-if="createLoading">
                                <div class="spinner-border">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                            </div>
                            <div class="btn btn-light" data-bs-dismiss="modal" aria-hidden="true">
                                Hủy
                            </div>
                            <button type="submit" class="btn btn-primary ">
                                Lưu
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
</template>

<script type="text/javascript">
    var options = {
        durations: {
            alert: 5000,
            warning: 0,
            success: 1000,
        },
        icons: {
            enabled: false
        }
    }
    var notifier = new AWN(options);

    Vue.component('list_film', {
        template: `#list_film`,
        delimiters: ["((", "))"],

        data() {
            return {
                sortDirection: 'desc',
                sortBy: '',
                count: 0, //total page
                page: 1, //pagination: curent page
                perPage: 10, // pagination: records per page
                total: 0, //pagination: total records
                pageRange: 3, // pagination:controls nearby page display. currenpage counted
                from: 1,
                to: 10,
                list: [],
                conditionSearch: '',
                search: '',
                valid_from: '',
                valid_to: '',
                status: [1, 2, 3],
                showClearSearch: false,
                modalUrl: "{{ route('view.film.store') }}",
                putMethod: false,
                selectedObject: {},
                listPage: [],
                showCount: 10,
                selected: [],
                previewUrl: "{{ asset('assets/images/multi-user.jpg') }}",
                validateErrors: {},
                createLoading: false,
                viewType: 'list',
                createObj: {},
                loading: false,
            }
        },
        delimiters: ["((", "))"],
        mounted() {
            const that = this;
            this.onLoadPagination();
        },
        computed: {
            selectAll: {
                get: function() {
                    if (!this.list || this.selected.length == 0) return 0
                    if (this.selected.length == this.list.length) return 1
                    if (this.selected.length != this.list.length) return 2
                },
                set: function(value) {
                    this.selected = value ? this.list.map((row) => row.id) : [];
                }
            }
        },
        methods: {
            resetCreateObj() {
                this.createObj = {}
                $('#phone').val(this.createObj.phone)
                $('#postcode').val(this.createObj.postcode)
            },
            copyItem(item) {
                this.createObj = {
                    ...item,
                }
                $('#phone').val(this.createObj.phone)
                $('#postcode').val(this.createObj.postcode)
            },
            sortSelect: function(s) {
                if (s === this.sortBy) {
                    this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                }
                this.sortBy = s;
                this.list.sort((p1, p2) => {
                    let modifier = 1;
                    if (this.sortDirection === 'asc') modifier = -1;
                    let indexA = this.selected.indexOf(p1.id);
                    let indexB = this.selected.indexOf(p2.id);
                    // Nếu id không có trong selected thì cho nó giá trị lớn để nó được đẩy về sau
                    if (indexA === -1) indexA = Infinity;
                    if (indexB === -1) indexB = Infinity;

                    return (indexA - indexB) * modifier;
                });
            },
            sortTime: function(s) {
                if (s === this.sortBy) {
                    this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                }
                this.sortBy = s;
                this.list = this.list.sort((p1, p2) => {
                    let modifier = this.sortDirection === 'asc' ? 1 : -1;

                    const time1 = p1[this.sortBy].split(':').map(num => parseInt(num));
                    const time2 = p2[this.sortBy].split(':').map(num => parseInt(num));

                    if (time1[0] < time2[0]) return -1 * modifier;
                    if (time1[0] > time2[0]) return 1 * modifier;
                    if (time1[1] < time2[1]) return -1 * modifier;
                    if (time1[1] > time2[1]) return 1 * modifier;
                    return 0;
                });
            },
            sort: function(s) {
                if (s === this.sortBy) {
                    this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
                }
                this.sortBy = s;
                this.list = this.list.sort((p1, p2) => {
                    let modifier = 1;
                    if (this.sortDirection === 'desc') modifier = -1;

                    if (p1[this.sortBy] == undefined && p2[this.sortBy] != undefined) return -1 *
                        modifier;
                    if (p1[this.sortBy] != undefined && p2[this.sortBy] == undefined) return 1 *
                        modifier;
                    if (p1[this.sortBy] == undefined && p2[this.sortBy] == undefined) return 0;

                    if (p1[this.sortBy].length == 0 && p2[this.sortBy].length > 0) return -1 *
                        modifier;
                    if (p1[this.sortBy].length > 0 && p2[this.sortBy].length == 0) return 1 *
                        modifier;
                    if (p1[this.sortBy].length == 0 && p2[this.sortBy].length == 0) return 0;

                    if (!Number.isNaN(parseInt(p1[this.sortBy])) && !Number.isNaN(parseInt(p2[this
                            .sortBy]))) {
                        if (p1[this.sortBy].indexOf && p2[this.sortBy].indexOf && p1[this.sortBy]
                            .indexOf("-") == -1 && p2[this.sortBy].indexOf("-") == -1) {
                            return (p1[this.sortBy] - p2[this.sortBy]) * modifier;
                        }
                    }

                    if (p1[this.sortBy] < p2[this.sortBy]) return -1 * modifier;
                    if (p1[this.sortBy] > p2[this.sortBy]) return 1 * modifier;
                    return 0;
                });
            },
            setViewType(type) {
                this.viewType = type;
            },
            onPerPageChange(perPage) {
                this.page = 1;
                this.perPage = perPage;
                this.onLoadPagination();
            },
            onPageChange(_p) {
                this.page = _p;
                this.onLoadPagination();
            },
            onPrePage() {
                if (this.page > 1) {
                    this.page = this.page - 1;
                }
                this.onLoadPagination();
            },
            onNextPage() {
                if (this.page < this.count) {
                    this.page = this.page + 1;
                }
                this.onLoadPagination();
            },
            async onLoadPagination() {
                this.selected = [];
                this.loading = true
                const that = this;
                that.list = [];
                let conditionSearch = '?page=' + this.page;
                conditionSearch += '&perPage=' + this.perPage;
                conditionSearch += '&showcount=' + this.showCount;
                conditionSearch += '&s=' + this.search;
                this.conditionSearch = conditionSearch;

                await jQuery.ajax({
                    type: 'GET',
                    url: "{{ route('api.film.list_by_artist', $model->id) }}" + conditionSearch,
                    success: function(data) {

                        that.list = data?.result?.data;
                        that.count = data.result.last_page;
                        that.from = data.result.from;
                        that.to = data.result.to;
                        that.total = data.result.total;

                        let pageArr = [];
                        if (that.page - 2 > 0) {
                            pageArr.push(that.page - 2);
                        }
                        if (that.page - 1 > 0) {
                            pageArr.push(that.page - 1);
                        }
                        pageArr.push(that.page);
                        if (that.page + 1 <= that.count) {
                            pageArr.push(that.page + 1);
                        }
                        if (that.page + 2 <= that.count) {
                            pageArr.push(that.page + 2);
                        }
                        that.listPage = pageArr;
                        that.loading = false
                    },
                    error: function(xhr, textStatus, error) {
                        notifier.warning('Lỗi Hệ Thống!');
                        that.loading = false
                    }
                });
            },
            async createFormSubmit() {
                if (this.createLoading) return;
                let that = this;
                this.createLoading = true
                const form = $('#createForm');
                const formData = new FormData(form[0]);
                await jQuery.ajax({
                    type: 'POST',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    url: "{{ route('view.artist.add_films', $model->id) }}",
                    success: function(data) {
                        that.createLoading = false
                        notifier.success('label.success')
                        $('#avatar').val('')
                        that.previewUrl = "{{ asset('assets/images/multi-user.jpg') }}";
                        form[0].reset()
                        $('.modal').modal('hide')
                        that.validateErrors = {}
                        that.onLoadPagination()
                    },
                    error: function(data) {
                        that.createLoading = false
                        that.validateErrors = data.responseJSON.errors
                        notifier.alert(data.responseJSON.message);
                    }
                })
            },
            async bulkDelete() {
                let that = this;

                if (that.selected.length <= 0) {
                    notifier.alert("{{ trans('label.choosing_item') }}")
                    return;
                }

                const result = await Swal.fire({
                    title: "{{ trans('label.are_you_sure') }}",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#dc3545',
                    cancelButtonColor: '#ffffff',
                    confirmButtonText: "{{ trans('label.yes_delete_it') }}",
                    cancelButtonText: "{{ trans('label.cancel') }}"
                });
                if (result.isConfirmed) {
                    that.createLoading = true
                    await jQuery.ajax({
                        type: 'DELETE',
                        data: {
                            _method: 'DELETE',
                            ids: that.selected
                        },
                        url: "{{ route('view.artist.film_bulk_delete', $model->id) }}",
                        success: function(data) {
                            notifier.success("{{ trans('label.delete_success') }}");
                            that.onLoadPagination();
                        },
                        error: function(data) {
                            notifier.alert(data.responseJSON.message);
                            /* notifier.alert(data.responseJSON.message); */
                        }
                    });
                    that.createLoading = false
                }
            },
            handleSearch() {
                this.loading = true
                this.list = []
                if (this.search !== '') this.showClearSearch = true
                else this.showClearSearch = false;

                if (this.searchTimeout) clearTimeout(this.searchTimeout)
                this.searchTimeout = setTimeout(() => {
                    this.searchFunction();
                }, 400);
            },
            searchFunction() {
                this.page = 1
                this.onLoadPagination();
            },
            clearInput() {
                this.search = ''
                this.showClearSearch = false
                this.onLoadPagination();
            },
            resetSearch() {
                this.search = ''
                this.valid_from = ''
                this.valid_to = ''
                this.status = [1, 2, 3]
                // this.onLoadPagination()
            },
            deleteItem(id) {
                this.selected.push(id)
                this.bulkDelete()
            },
            previewImage(event) {
                const file = event.target.files[0];
                if (file) {
                    this.previewUrl = URL.createObjectURL(file)
                }
            },
        },
    });
</script>
