<div class="description-relative table-wrapper " id="listView" role="listView">
    <div class="table-responsive gino-custom-table pb-0 rounded-3 border">
        <table class="table mb-0 text-nowrap bg-white ">
            <thead>
                <tr>
                    <th @click="sortSelect('select')" role='button' style="width: 1px" class=" col_checkbox px-4">
                        <input type="checkbox"
                            :class="[{ 'gino-checkbox--checked2': selectAll == 2 },
                                'gino-checkbox form-check-input'
                            ]"
                            v-model="selectAll" :checked="selectAll" @click.stop>
                        <i v-if="sortBy == 'select'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>
                    <th @click="sort('id')" role='button' class="col_id text-center">
                        ID
                        <i v-if="sortBy == 'id'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>
                    <th>
                    </th>

                    <th @click="sort('name')" role='button'>
                        Tên
                        <i v-if="sortBy == 'name'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>

                    <th @click="sort('description')" role='button'>
                        Mô tả
                        <i v-if="sortBy == 'description'"
                            v-bind:class="sortDirection == 'desc' ? 
                        'fas fa-chevron-down' : 'fas fa-chevron-up'"></i>
                    </th>
                    <th style="width:1px">
                        <div></div>
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr v-for="item in list" :key="item.id">
                    <td scope="col" class=" px-4">
                        <input type="checkbox" class="gino-checkbox form-check-input" v-model="selected"
                            :value="item.id">
                    </td>
                    <td class="text-center">
                        
                        <a :href="`{{ route('view.artist.detail') }}/` + item.id " class="text-primary">
                            ((item.id))
                        </a>
                    </td>
                    <td class=" text-center">
                        <img :src="item.img_url" class="object-fit-contain rounded-2 me-2" height="44"
                            :alt="item.name">
                    </td>
                    <td>((item.name))</td>
                    <td class="text-wrap">((item.description))</td>
                    <td>
                        <div class="hstack gap-2 me-2">
                            <a :href="`{{ route('view.artist.detail') }}/` + item.id" class="  action-btn rounded  p-1"
                                title="{{ trans('label.view') }}">
                                @include('icons.eye')
                            </a>
                            <a href="##" @click="copyItem(item)" class="action-btn rounded p-1"
                                data-bs-toggle="modal" data-bs-target="#exampleModal">
                                @include('icons.copy')
                            </a>
                            <form :action="`{{ route('view.artist.destroy') }}/` + item.id"
                                :id="'formDelete_' + ((item.id))" method="post">
                                @method('DELETE')
                                @csrf
                                <a href="##" @click="deleteItem(item.id)" class="  action-btn rounded  p-1">
                                    @include('icons.trash')</a>
                            </form>
                        </div>
                    </td>
                </tr>
                <tr v-if="loading">
                    <td colspan="100%" class=" text-center">
                        <div class="spinner-border">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </td>
                </tr>
                <tr v-if="list.length < 1 && !loading">
                    <td colspan="100%" class="text-center border-bottom">Không có dữ liệu</td>
                </tr>

            </tbody>
        </table>
    </div>
</div>
@include('includes.pagination')
