@extends('layouts.master')

@section('title', 'about_us')

@section('content')
    <div class="container-fluid fixed-screen-container" id="App">
        <form action="{{ route('view.about_us.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Page Header -->
            <div class="d-flex flex-wrap justify-content-between gap-4 my-4 page-header-breadcrumb">
                <div class="my-auto d-flex align-items-start">
                    <h4 class="mb-0">Chỉnh Sửa Trang About Us</h4>

                </div>
                {{--  <div class="d-flex align-items-center">
                    <h4 class="d-inline-flex gap-2 me-3 align-items-center">
                        <a href="{{ route('view.about_us.detail', ['lang' => 'vi']) }}"
                            class="{{ $page->lang == 'vi' ? 'fw-bold' : '' }} link">
                            Tiếng Việt
                        </a>/
                        <a href="{{ route('view.about_us.detail', ['lang' => 'en']) }}"
                            class="{{ $page->lang == 'en' ? 'fw-bold' : '' }} link">
                            Tiếng Anh
                        </a>
                    </h4>
                </div> --}}
                <button class="btn btn-primary btn-submit" type="submit">Lưu</button>
            </div>
            <!-- End Page Header -->
            <div class="card bg-white position-relative table-wrapper p-3">
                {{--   <h4 class="mb-2 text-capitalize">Banner</h4>
                <div class="separator mb-3"></div> --}}
                <div class="row">

                    <div class="col-md-12 mb-3">
                        <div class="mb-3">
                            <label for="title" class="mb-2 text-capitalize">
                                Tiêu đề trang
                            </label>
                            <ckeditor height="100" v-model="createObj.title" name="title">
                            </ckeditor>
                        </div>

                    </div>

                    <div class="col-md-6 mb-3">
                        <div class="mb-3">
                            <label for="banner" class="mb-2 text-capitalize">Hình ảnh happy creator trên desktop</label>
                            <image-selector v-model="createObj.happy_creator_desktop"
                                name="happy_creator_desktop"></image-selector>
                        </div>
                    </div>
                    <div class="col-md-6 d-flex banner-img-holder mb-3">
                        <img :src="((createObj.happy_creator_desktop))" alt="" class="m-auto">
                    </div>

                    <div class="col-md-6 mb-3">
                        <div class="mb-3">
                            <label for="banner" class="mb-2 text-capitalize">Hình ảnh happy creator trên mobile</label>
                            <image-selector v-model="createObj.happy_creator_mobile"
                                name="happy_creator_mobile"></image-selector>
                        </div>
                    </div>
                    <div class="col-md-6 d-flex banner-img-holder mb-3">
                        <img :src="((createObj.happy_creator_mobile))" alt="" class="m-auto">
                    </div>



                    <div class="col-md-6 mb-3">
                        <div class="mb-3">
                            <label for="our_value_desktop" class="mb-2 text-capitalize">Hình ảnh our value trên
                                desktop</label>
                            <image-selector v-model="createObj.our_value_desktop" name="our_value_desktop"></image-selector>
                        </div>
                    </div>
                    <div class="col-md-6 d-flex banner-img-holder mb-3">
                        <img :src="((createObj.our_value_desktop))" alt="" class="m-auto">
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <div class="mb-3">
                            <label for="our_value_mobile" class="mb-2 text-capitalize">
                                our value trên mobile
                            </label>
                            <image-selector v-model="createObj.our_value_mobile" name="our_value_mobile"></image-selector>
                        </div>
                    </div>
                    <div class="col-md-6 d-flex banner-img-holder mb-3">
                        <img :src="((createObj.our_value_mobile))" alt="" class="m-auto">
                    </div>


                    <div class="col-md-6 mb-3">
                        <div class="mb-3">
                            <label for="year_of_archievements_img" class="mb-2 text-capitalize">Hình ảnh 7 Years of
                                achievements</label>
                            <image-selector v-model="createObj.year_of_archievements_img"
                                name="year_of_archievements_img"></image-selector>
                        </div>
                    </div>
                    <div class="col-md-6 d-flex banner-img-holder mb-3">
                        <img :src="((createObj.year_of_archievements_img))" alt="" class="m-auto">
                    </div>



                    <div class="col-md-12 mb-3">
                        <div class="mb-3">
                            <label for="year_of_archievements_text" class="mb-2 text-capitalize">
                                Nội dung 7 Years of achievements
                            </label>
                            <ckeditor v-model="createObj.year_of_archievements_text" name="year_of_archievements_text">
                            </ckeditor>
                        </div>
                    </div>



                    <div class="col-md-6 mb-3">
                        <div class="mb-3">
                            <label for="quote_avatar" class="mb-2 text-capitalize">quote avatar</label>
                            <image-selector v-model="createObj.quote_avatar" name="quote_avatar"></image-selector>
                        </div>
                    </div>
                    <div class="col-md-6 d-flex banner-img-holder mb-3">
                        <img :src="((createObj.quote_avatar))" alt="" class="m-auto">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="quote_user" class="mb-2 text-capitalize">
                            quote User
                        </label>
                        <input type="text" class="form-control" v-model="createObj.quote_user" name="quote_user">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="quote_position" class="mb-2 text-capitalize">
                            quote position
                        </label>
                        <input type="text" class="form-control" v-model="createObj.quote_position" name="quote_position">
                    </div>

                    <div class="col-md-12 mb-3">
                        <div class="mb-3">
                            <label for="quote_description" class="mb-2 text-capitalize">
                                quote description
                            </label>
                            <ckeditor v-model="createObj.quote_description" height="100" name="quote_description">
                            </ckeditor>
                        </div>
                    </div>

                    <div class="col-md-6 mb-3">
                        <div class="mb-3">
                            <label for="quote_logo" class="mb-2 text-capitalize">quote logo</label>
                            <image-selector v-model="createObj.quote_logo" name="quote_logo"></image-selector>
                        </div>
                    </div>
                    <div class="col-md-6 d-flex banner-img-holder mb-3">
                        <img :src="((createObj.quote_logo))" alt="" class="m-auto">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="quote_logo_title" class="mb-2 text-capitalize">
                            quote logo title
                        </label>
                        <input type="text" class="form-control" v-model="createObj.quote_logo_title"
                            name="quote_logo_title">
                    </div>
                </div>
            </div>


        </form>
        <!-- Button to trigger File Manager -->


    </div>

@endsection

@section('script-footer')

    <!-- Chartjs Chart JS -->
    <!-- <script src="{{ asset('assets/js/index.js') }}"></script> -->

    <script src="{{ asset('assets/js/prism-custom.js') }}"></script>

    <script src="{{ asset('assets/js/custom-switcher.min.js') }}"></script>
    <!-- Custom JS -->
    <script src="{{ asset('assets/js/custom.js') }}"></script>
    <script src="{{ asset('assets/js/csrf.js') }}"></script>

    <script>
        $(document).ready(function() {
            $('.lfm').filemanager('image');
        });
    </script>

    <script type="text/javascript">
        var options = {
            maxNotifications: 5,
            durations: {
                alert: 0,
                warning: 0,
                success: 0,
            },
            labels: {
                alert: '',
                warning: '',
                success: '',
            },
            icons: {
                enabled: false
            },
        }
        var notifier = new AWN(options);
    </script>


    <script>
        const EventBus = new Vue()

        new Vue({
            el: '#App',
            data: {
                sortDirection: 'desc',
                sortBy: '',
                count: 0, //total page
                page: 1, //pagination: curent page
                perPage: 10, // pagination: records per page
                total: 0, //pagination: total records
                pageRange: 3, // pagination:controls nearby page display. currenpage counted
                from: 1,
                to: 10,
                list: [],
                conditionSearch: '',
                search: '',
                airport_date_to: '',
                airport_date_from: '',
                return_date_to: '',
                return_date_from: '',
                filterObj: {},
                showClearSearch: false,
                putMethod: false,
                selectedObject: {},
                createObj: @json($page),
                listPage: [],
                showCount: 10,
                selected: [],
                previewUrl: "{{ asset('assets/images/multi-user.jpg') }}",
                validateErrors: {},
                createLoading: false,
                viewType: 'list',
                loading: false,
                loadCustomerStaff: false,

            },
            created() {

            },
            delimiters: ["((", "))"],
            mounted() {

            },
            computed: {

            },
            methods: {

            },
        });
    </script>

    @if ($errors->any())
        <script>
            let alertMessage = `
            @foreach ($errors->all() as $error)
            <br>
                {{ $error }}
            @endforeach
            `
            notifier.alert(alertMessage);
        </script>
    @endif

    @if (session('error'))
        <script>
            notifier.alert(`{{ session('error') }}`);
        </script>
    @endif

    @if (session('success'))
        <script>
            notifier.success(`{{ session('success') }}`);
        </script>
    @endif

@endsection
