@extends('layouts.master')

@section('title', 'about_us')

@section('content')
    <div class="container-fluid fixed-screen-container" id="App">
        <form action="{{ route('view.about_us.store', ['lang' => $page->lang]) }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Page Header -->
            <div class="d-flex flex-wrap justify-content-between gap-4 my-4 page-header-breadcrumb">
                <div class="my-auto d-flex align-items-start">
                    <h4 class="mb-0">Chỉnh Sửa Trang Chủ</h4>

                </div>
                <div class="d-flex align-items-center">
                    <h4 class="d-inline-flex gap-2 me-3 align-items-center">
                        <a href="{{ route('view.about_us.detail', ['lang' => 'vi']) }}"
                            class="{{ $page->lang == 'vi' ? 'fw-bold' : '' }} link">
                            Tiếng Việt
                        </a>/
                        <a href="{{ route('view.about_us.detail', ['lang' => 'en']) }}"
                            class="{{ $page->lang == 'en' ? 'fw-bold' : '' }} link">
                            Tiếng Anh
                        </a>
                    </h4>
                    <button class="btn btn-primary btn-submit" type="submit">Lưu</button>
                </div>
            </div>
            <!-- End Page Header -->
            <ul class="nav nav-custom nav-tabs bg-white p-2 d-sm-flex d-block mb-3 column-gap-3 rounded-3" role="tablist">
                <li class="nav-item m-0">
                    <a class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab_banner" aria-current="page"
                        href="#tab_banner">Banner
                    </a>
                </li>
                <li class="nav-item m-0">
                    <a class="nav-link" data-bs-toggle="tab" data-bs-target="#tab_service" aria-current="page"
                        href="#tab_service">Service
                    </a>
                </li>
                <li class="nav-item m-0">
                    <a class="nav-link" data-bs-toggle="tab" data-bs-target="#tab_award" aria-current="page"
                        href="#tab_award">Award
                    </a>
                </li>
                <li class="nav-item m-0">
                    <a class="nav-link" data-bs-toggle="tab" data-bs-target="#tab_client" aria-current="page"
                        href="#tab_client">Clients
                    </a>
                </li>
            </ul>

            <div class="tab-content tab-content-custom rounded-3 mt-1 bg-transparent p-0 collapse-all-content">
                <div class="tab-pane active border-0 p-0" id="tab_banner" role="tab_banner">
                    @include('admin.about_us.detail.banner')
                </div>
                <div class="tab-pane  border-0 p-0" id="tab_service" role="tab_service">
                    @include('admin.about_us.detail.service', [
                        'services' => $page->service_data ?? [[], [], []],
                        'service_title' => $page->service_title,
                    ])
                </div>
                <div class="tab-pane border-0 p-0" id="tab_award" role="tab_award">
                    <award_template></award_template>
                </div>
                <div class="tab-pane border-0 p-0" id="tab_client" role="tab_client">
                    <client_template></client_template>
                </div>
            </div>

            {{-- @include('admin.about_us.detail.content', ['page' => $page_en, 'lang' => $page_en->lang]) --}}

        </form>
        <!-- Button to trigger File Manager -->


    </div>

@endsection

@section('script-footer')

    <!-- Chartjs Chart JS -->
    <!-- <script src="{{ asset('assets/js/index.js') }}"></script> -->

    <script src="{{ asset('assets/js/prism-custom.js') }}"></script>

    <script src="{{ asset('assets/js/custom-switcher.min.js') }}"></script>
    <!-- Custom JS -->
    <script src="{{ asset('assets/js/custom.js') }}"></script>
    <script src="{{ asset('assets/js/csrf.js') }}"></script>
    {{--   <script src="//cdn.jsdelivr.net/npm/sortablejs@1.8.4/Sortable.min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/Vue.Draggable/2.20.0/vuedraggable.umd.min.js"></script>
    <link href='https://cdn.jsdelivr.net/npm/fullcalendar@5.8.0/main.min.css' rel='stylesheet' />
    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@5.8.0/main.min.js'></script>
 --}}

    <script>
        $(document).ready(function() {
            $('.lfm').filemanager('image');
        });
    </script>

    <script type="text/javascript">
        var options = {
            maxNotifications: 5,
            durations: {
                alert: 0,
                warning: 0,
                success: 0,
            },
            labels: {
                alert: '',
                warning: '',
                success: '',
            },
            icons: {
                enabled: false
            },
        }
        var notifier = new AWN(options);
    </script>

    @include('admin.about_us.detail.award_template', [
        'awards' => $page->award_data,
        'award_title' => $page->award_title,
        'lang' => $page->lang,
    ])
    @include('admin.about_us.detail.client_template', [
        'clients' => $page->client_data,
        'client_title' => $page->client_title,
        'lang' => $page->lang,
    ])

    <script>
        const EventBus = new Vue()

        new Vue({
            el: '#App',
            data: {
                sortDirection: 'desc',
                sortBy: '',
                count: 0, //total page
                page: 1, //pagination: curent page
                perPage: 10, // pagination: records per page
                total: 0, //pagination: total records
                pageRange: 3, // pagination:controls nearby page display. currenpage counted
                from: 1,
                to: 10,
                list: [],
                conditionSearch: '',
                search: '',
                airport_date_to: '',
                airport_date_from: '',
                return_date_to: '',
                return_date_from: '',
                filterObj: {},
                showClearSearch: false,
                putMethod: false,
                selectedObject: {},
                createObj: {
                    title: @json($page->title),
                },
                listPage: [],
                showCount: 10,
                selected: [],
                previewUrl: "{{ asset('assets/images/multi-user.jpg') }}",
                validateErrors: {},
                createLoading: false,
                viewType: 'list',
                loading: false,
                loadCustomerStaff: false,

            },
            created() {

            },
            delimiters: ["((", "))"],
            mounted() {

            },
            computed: {

            },
            methods: {

            },
        });
    </script>

    @if ($errors->any())
        <script>
            let alertMessage = `
            @foreach ($errors->all() as $error)
            <br>
                {{ $error }}
            @endforeach
            `
            notifier.alert(alertMessage);
        </script>
    @endif

    @if (session('error'))
        <script>
            notifier.alert(`{{ session('error') }}`);
        </script>
    @endif

    @if (session('success'))
        <script>
            notifier.success(`{{ session('success') }}`);
        </script>
    @endif

@endsection
